/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl.MqttMessageHandlerImpl;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class StartHandlerImpl
extends MqttMessageHandlerImpl
implements MqttMessageHandler {
    public StartHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("start", mqttClient, mqttMsgLogDao, false);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u5931\u8d25 <<< \u5f00\u59cb\u5145\u7535\u547d\u4ee4");
        if (chargeDeviceProps != null && StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getDeviceId())) {
            String deviceId = chargeDeviceProps.getDeviceId();
            String rcvdMsg = new String(mqttMessage.getPayload());
            String[] rcvdMsgArray = rcvdMsg.split("#");
            String plugId = null;
            String result = null;
            if (rcvdMsgArray.length >= 4) {
                plugId = rcvdMsgArray[2];
                result = rcvdMsgArray[3];
            }
            if (StringUtils.isNotBlank(plugId)) {
                Map<String, Object> chargeRecordMap = this.chargeRecordCache.getChargeRecordMap(deviceId, plugId);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" deviceId             : " + deviceId);
                    this.logger.debug(" plugId               : " + plugId);
                    this.logger.debug(" result               : " + result);
                    this.logger.debug(" chargeRecordMap      : " + JsonConvertUtils.convertToString(chargeRecordMap));
                }
                if (MapUtils.isNotEmpty(chargeRecordMap)) {
                    Integer chargeOpenFlag = (Integer)ObjectUtils.defaultIfNull((Object)chargeRecordMap.get("chargeOpenFlag"), (Object)0);
                    if (chargeOpenFlag == 1) {
                        if (StringUtils.equals((CharSequence)"0", (CharSequence)result)) {
                            String schemeType;
                            if (StringUtils.equals((CharSequence)chargeDeviceProps.getFactory(), (CharSequence)"gaea") && StringUtils.equals((CharSequence)chargeDeviceProps.getModelNo(), (CharSequence)"002")) {
                                schemeType = (String)chargeRecordMap.get("schemeType");
                                if (StringUtils.equals((CharSequence)schemeType, (CharSequence)"03")) {
                                    String voiceId = "3";
                                    String msg2Device = "voice#" + voiceId;
                                    this.response2device(deviceId, msg2Device, "voice");
                                } else if (StringUtils.equals((CharSequence)schemeType, (CharSequence)"01")) {
                                    String voiceId = "4";
                                    String msg2Device = "voice#" + voiceId + "#" + ((Double)chargeRecordMap.get("chargeAmount")).intValue();
                                    this.response2device(deviceId, msg2Device, "voice");
                                }
                            } else if (StringUtils.equals((CharSequence)chargeDeviceProps.getFactory(), (CharSequence)"gaea") && StringUtils.equals((CharSequence)chargeDeviceProps.getModelNo(), (CharSequence)"003")) {
                                schemeType = (String)chargeRecordMap.get("schemeType");
                                if (StringUtils.equals((CharSequence)schemeType, (CharSequence)"03")) {
                                    String voiceId = "10";
                                    String msg2Device = "voice#" + voiceId + "#" + plugId;
                                    this.response2device(deviceId, msg2Device, "voice");
                                } else if (StringUtils.equals((CharSequence)schemeType, (CharSequence)"01")) {
                                    String voiceId = "11";
                                    String msg2Device = "voice#" + voiceId + "#" + plugId + "#" + ((Double)chargeRecordMap.get("chargeAmount")).intValue();
                                    this.response2device(deviceId, msg2Device, "voice");
                                }
                            }
                            HashMap valueMap = Maps.newHashMap();
                            valueMap.put("chargeOpenFlag", Integer.valueOf(result));
                            valueMap.put("chargeOpenTime", new Date());
                            this.chargeRecordCache.updateChargeRecord(deviceId, plugId, valueMap);
                            this.chargeOrderEventPublisher.publishEvent("open", this.chargeRecordCache.getBeChargingRecord((String)chargeRecordMap.get("chargeRecordId")));
                        } else {
                            HashMap valueMap = Maps.newHashMap();
                            valueMap.put("chargeOpenFlag", Integer.valueOf(result));
                            valueMap.put("chargeOpenTime", new Date());
                            this.chargeRecordCache.updateChargeRecord(deviceId, plugId, valueMap);
                            HashMap<String, Object> finishValueMap = new HashMap<String, Object>();
                            finishValueMap.put("finishReason", result);
                            this.chargeRecordCache.finishChargeRecord(deviceId, plugId, finishValueMap);
                            if (StringUtils.equals((CharSequence)"1", (CharSequence)chargeDeviceProps.getOpStatus())) {
                                this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
                            } else {
                                this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "9");
                            }
                            this.chargeOrderEventPublisher.publishEvent("finish", this.chargeRecordCache.getHistroyChargeRecord((String)chargeRecordMap.get("chargeRecordId")));
                        }
                    }
                } else if (this.fitconnDebuggingCache.checkIsDebugging(deviceId, plugId)) {
                    if (StringUtils.equals((CharSequence)"0", (CharSequence)result)) {
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("debugOpenTime", new Date());
                        this.fitconnDebuggingCache.updateFitconnDebuggingLog(deviceId, plugId, valueMap);
                    } else {
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("debugOpenTime", new Date());
                        valueMap.put("debugFinishTime", new Date());
                        this.fitconnDebuggingCache.finishFitconnDebuggingLog(deviceId, plugId, valueMap);
                        if (StringUtils.equals((CharSequence)"1", (CharSequence)chargeDeviceProps.getOpStatus())) {
                            this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
                        } else {
                            this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "9");
                        }
                    }
                }
            }
            res.setStatus(0);
            res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u6210\u529f <<< \u5f00\u59cb\u5145\u7535\u547d\u4ee4");
            if (this.needRespond && res.getStatus() == 0) {
                res = this.handleDownMessage(chargeDeviceProps);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    public MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u6210\u529f >>> \u5f00\u59cb\u5145\u7535\u547d\u4ee4");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }
}

