/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.CollectionUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.DateFormatUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.DoubleUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.NumberUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.ObjectUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProtocolEnum;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.OpsWorkOrder;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.RefreshChargeRecordResult;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl.MqttMessageHandlerImpl;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class StatusHandlerImpl
extends MqttMessageHandlerImpl
implements MqttMessageHandler {
    private static final long START_RESULT_TIMEOUT = 10000L;

    public StatusHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("status", mqttClient, mqttMsgLogDao, true);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u5931\u8d25 <<< \u8bbe\u5907\u5404\u63d2\u5ea7\u7684\u72b6\u6001\u7684\u67e5\u8be2");
        if (chargeDeviceProps != null && StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getDeviceId())) {
            String strPower;
            String strRemain;
            int i;
            Integer plugSn = 0;
            List<OpsWorkOrder> opsWorkOrderList101 = this.opsWorkOrderCache.getOpsWorkOrderList(chargeDeviceProps.getDeviceId(), String.valueOf(plugSn), "101", "N");
            List<OpsWorkOrder> opsWorkOrderList102 = this.opsWorkOrderCache.getOpsWorkOrderList(chargeDeviceProps.getDeviceId(), String.valueOf(plugSn), "102", "N");
            List<OpsWorkOrder> opsWorkOrderList103 = this.opsWorkOrderCache.getOpsWorkOrderList(chargeDeviceProps.getDeviceId(), String.valueOf(plugSn), "103", "N");
            ArrayList<OpsWorkOrder> opsWorkOrderList = new ArrayList<OpsWorkOrder>();
            opsWorkOrderList.addAll(opsWorkOrderList101);
            opsWorkOrderList.addAll(opsWorkOrderList102);
            opsWorkOrderList.addAll(opsWorkOrderList103);
            if (CollectionUtils.sizeIsNotEmptyIgnoreNull(opsWorkOrderList)) {
                for (OpsWorkOrder opsWorkOrder : opsWorkOrderList) {
                    opsWorkOrder.setIsRecovery("Y");
                    opsWorkOrder.setRecoveryTime(new Date());
                    this.opsWorkOrderCache.recoveryOpsWorkOrder(opsWorkOrder);
                    if (!StringUtils.equals((CharSequence)"10", (CharSequence)opsWorkOrder.getOpsworkorderStatus())) continue;
                    HashMap<String, Object> archiveMap = new HashMap<String, Object>();
                    archiveMap.put("archiver", "EBIKE");
                    archiveMap.put("archiveType", "10");
                    archiveMap.put("archiveTime", new Date());
                    archiveMap.put("archiveDesc", "\u76f4\u63a5\u5f52\u6863");
                    this.opsWorkOrderCache.archiveOpsWorkOrder(opsWorkOrder, archiveMap);
                }
            }
            String deviceId = chargeDeviceProps.getDeviceId();
            String rcvdMsg = new String(mqttMessage.getPayload());
            String[] rcvdMsgArray = rcvdMsg.split("#");
            Integer plugCount = chargeDeviceProps.getPlugCount() != null ? chargeDeviceProps.getPlugCount() : 0;
            Double[] remains = new Double[plugCount.intValue()];
            Double[] powers = new Double[plugCount.intValue()];
            Double[] times = new Double[plugCount.intValue()];
            Date currTime = new Date();
            if (chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201804) || chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201805)) {
                if (rcvdMsgArray.length >= plugCount + 2) {
                    for (i = 0; i < plugCount; ++i) {
                        String strPlugValue = rcvdMsgArray[2 + i];
                        String[] plugValArray = strPlugValue.split(",");
                        String strRemain2 = plugValArray.length >= 1 ? plugValArray[0] : null;
                        String strTime = plugValArray.length >= 2 ? plugValArray[1] : null;
                        String strPower2 = plugValArray.length >= 3 ? plugValArray[2] : null;
                        remains[i] = NumberUtils.isParsable((String)strRemain2) ? Double.valueOf(Double.parseDouble(strRemain2)) : null;
                        powers[i] = NumberUtils.isParsable((String)strPower2) ? Double.valueOf(Double.parseDouble(strPower2)) : null;
                        times[i] = NumberUtils.isParsable((String)strTime) ? Double.valueOf(Double.parseDouble(strTime)) : null;
                    }
                }
            } else if (rcvdMsgArray.length >= plugCount * 3 + 2) {
                for (i = 0; i < plugCount; ++i) {
                    strRemain = rcvdMsgArray[2 + i * 2];
                    strPower = rcvdMsgArray[2 + i * 2 + 1];
                    String strTime = rcvdMsgArray[2 + plugCount * 3 - (plugCount - i)];
                    remains[i] = NumberUtils.isParsable((String)strRemain) ? Double.valueOf(Double.parseDouble(strRemain)) : null;
                    powers[i] = NumberUtils.isParsable((String)strPower) ? Double.valueOf(Double.parseDouble(strPower)) : null;
                    times[i] = NumberUtils.isParsable((String)strTime) ? Double.valueOf(Double.parseDouble(strTime)) : null;
                }
            } else if (rcvdMsgArray.length >= plugCount * 2 + 2) {
                for (i = 0; i < plugCount; ++i) {
                    strRemain = rcvdMsgArray[2 + i * 2];
                    strPower = rcvdMsgArray[2 + i * 2 + 1];
                    remains[i] = NumberUtils.isParsable((String)strRemain) ? Double.valueOf(Double.parseDouble(strRemain)) : null;
                    powers[i] = NumberUtils.isParsable((String)strPower) ? Double.valueOf(Double.parseDouble(strPower)) : null;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" deviceId     : " + deviceId);
                this.logger.debug(" remains      : " + JsonConvertUtils.convertToString(remains));
                this.logger.debug(" powers       : " + JsonConvertUtils.convertToString(powers));
                this.logger.debug(" times        : " + JsonConvertUtils.convertToString(times));
            }
            HashMap<String, Object> chargedeviceLoadMap = new HashMap<String, Object>();
            chargedeviceLoadMap.put("CHGDEVICEID", chargeDeviceProps.getChargedeviceId());
            chargedeviceLoadMap.put("CHGDEVICENO", chargeDeviceProps.getChargedeviceNo());
            chargedeviceLoadMap.put("LOADTIME", DateFormatUtils.format((Date)currTime, (String)"yyyyMMddHHmmss"));
            chargedeviceLoadMap.put("DEVICEID", chargeDeviceProps.getDeviceId());
            chargedeviceLoadMap.put("PLUG_COUNT", plugCount);
            Double sumLoadValue = 0.0;
            for (int i2 = 1; i2 <= plugCount; ++i2) {
                HashMap<String, Object> chargeplugLoadMap = new HashMap<String, Object>();
                chargeplugLoadMap.put("CHGPLUGNO", chargeDeviceProps.getChargedeviceNo() + String.format("%02d", i2));
                chargeplugLoadMap.put("LOADTIME", DateFormatUtils.format((Date)currTime, (String)"yyyyMMddHHmmss"));
                String plugId = String.valueOf(i2);
                Double remain = remains[i2 - 1];
                Double power = powers[i2 - 1];
                Double time = times[i2 - 1];
                Double loadValue = DoubleUtils.defaultIfNegValue(power, 0.0, 0.0) / 1000.0;
                chargeplugLoadMap.put("LOADVALUE", loadValue);
                chargedeviceLoadMap.put("P" + String.format("%02d", i2) + "_LOADVALUE", loadValue);
                sumLoadValue = sumLoadValue + loadValue;
                if (this.chargeRecordCache.checkIsCharging(deviceId, plugId)) {
                    HashMap<String, Object> chargeorderLoadMap = new HashMap<String, Object>();
                    RefreshChargeRecordResult result = this.refreshChargeRecord(deviceId, plugId, remain, power, time, currTime);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(" RefreshChargeRecordResult : " + JsonConvertUtils.convertToString(result));
                    }
                    boolean resendParam = result.isResendParamFlag();
                    Map<String, Object> valueMap = result.getChargeRecordValueMap();
                    chargeorderLoadMap.put("CHGORDERNO", valueMap.get("chargeRecordId"));
                    chargeorderLoadMap.put("LOADTIME", DateFormatUtils.format((Date)currTime, (String)"yyyyMMddHHmmss"));
                    chargeorderLoadMap.put("LOADVALUE", loadValue);
                    if (MapUtils.isNotEmpty(valueMap) && ObjectUtils.isNotNull(valueMap.get("chargeTime"))) {
                        Integer chargeOpenFlag = (Integer)ObjectUtils.defaultIfNull((Object)valueMap.get("chargeOpenFlag"), (Object)1);
                        Date chargeTime = (Date)valueMap.get("chargeTime");
                        long timeInterval = System.currentTimeMillis() - chargeTime.getTime();
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" chargeOpenFlag       : " + chargeOpenFlag);
                            this.logger.debug(" timeInterval         : " + timeInterval);
                            this.logger.debug(" chargeRecordValueMap : " + JsonConvertUtils.convertToString(valueMap));
                        }
                        if (chargeOpenFlag == 0 || timeInterval > 10000L) {
                            if (remain != null && time != null && remain.compareTo(0.0) > 0 && time.compareTo(0.0) > 0 || remain != null && time == null && remain.compareTo(0.0) > 0 || remain == null && time != null && time.compareTo(0.0) > 0) {
                                if (chargeOpenFlag == 1) {
                                    valueMap.put("chargeOpenFlag", 0);
                                    valueMap.put("chargeOpenTime", new Date());
                                    this.chargeRecordCache.updateChargeRecord(deviceId, plugId, valueMap);
                                    this.chargeOrderEventPublisher.publishEvent("open", this.chargeRecordCache.getBeChargingRecord((String)valueMap.get("chargeRecordId")));
                                } else {
                                    this.chargeRecordCache.updateChargeRecord(deviceId, plugId, valueMap);
                                }
                                if (resendParam) {
                                    Double remainElecCons = (Double)valueMap.get("remainElecCons");
                                    Double remainTime = (Double)valueMap.get("remainTime");
                                    String msg2Device = "start#" + plugId + "#" + Math.round(remainElecCons * 1000.0) + "#" + Math.round(remainTime);
                                    this.response2device(deviceId, msg2Device, "start");
                                    try {
                                        TimeUnit.MILLISECONDS.sleep(100L);
                                    }
                                    catch (InterruptedException e) {
                                        this.logger.error(e.getMessage(), e.fillInStackTrace());
                                    }
                                }
                            } else {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug(" >>> \u5269\u4f59\u5145\u7535\u7535\u91cf\u6216\u5269\u4f59\u5145\u7535\u65f6\u95f4\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u7ed3\u675f\u5145\u7535\u8bb0\u5f55 >>> ");
                                    this.logger.debug(" chargeOpenFlag   : " + chargeOpenFlag);
                                    this.logger.debug(" remain           : " + remain);
                                    this.logger.debug(" time             : " + time);
                                }
                                HashMap finishValueMap = Maps.newHashMap();
                                if (chargeOpenFlag == -99) {
                                    HashMap mapTemp = Maps.newHashMap();
                                    mapTemp.put("chargeOpenFlag", chargeOpenFlag);
                                    mapTemp.put("chargeOpenTime", new Date());
                                    this.chargeRecordCache.updateChargeRecord(deviceId, plugId, mapTemp);
                                    finishValueMap.put("finishReason", "-99");
                                } else {
                                    this.chargeRecordCache.updateChargeRecord(deviceId, plugId, valueMap);
                                    finishValueMap.put("finishReason", "-97");
                                }
                                finishValueMap.put("finishPower", power / 1000.0);
                                this.chargeRecordCache.finishChargeRecord(deviceId, plugId, finishValueMap);
                                this.chargeOrderEventPublisher.publishEvent("finish", this.chargeRecordCache.getHistroyChargeRecord((String)valueMap.get("chargeRecordId")));
                                if (StringUtils.equals((CharSequence)"1", (CharSequence)chargeDeviceProps.getOpStatus())) {
                                    this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
                                } else {
                                    this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "9");
                                }
                                if (remain != null && remain.compareTo(0.0) > 0 || time != null && time.compareTo(0.0) > 0) {
                                    String msg2Device = "stop#" + plugId;
                                    this.response2device(deviceId, msg2Device, "stop");
                                }
                            }
                        }
                    }
                    this.chargeRecordCache.saveChargeorderLoadMap(chargeorderLoadMap);
                } else if (remain != null && time != null && remain.compareTo(0.0) > 0 && time.compareTo(0.0) > 0 || remain != null && time == null && remain.compareTo(0.0) > 0 || remain == null && time != null && time.compareTo(0.0) > 0) {
                    if (chargeDeviceProps.getPlugPropsMap() != null && chargeDeviceProps.getPlugPropsMap().get(Integer.parseInt(plugId)) != null) {
                        chargeDeviceProps.getPlugPropsMap().get(Integer.parseInt(plugId)).setStatus("U");
                        chargeDeviceProps.getPlugPropsMap().get(Integer.parseInt(plugId)).setOpStatus("1");
                    }
                } else if (this.fitconnDebuggingCache.checkIsDebugging(deviceId, plugId)) {
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    valueMap.put("debugFinishTime", new Date());
                    this.fitconnDebuggingCache.finishFitconnDebuggingLog(deviceId, plugId, valueMap);
                    if (StringUtils.equals((CharSequence)"1", (CharSequence)chargeDeviceProps.getOpStatus())) {
                        this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
                    } else {
                        this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "9");
                    }
                }
                this.chargeRecordCache.saveChargeplugLoadMap(chargeplugLoadMap);
            }
            chargedeviceLoadMap.put("SUM_LOADVALUE", sumLoadValue);
            this.chargeRecordCache.saveChargedeviceLoadMap(chargedeviceLoadMap);
            res.setStatus(0);
            res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u6210\u529f <<< \u8bbe\u5907\u5404\u63d2\u5ea7\u7684\u72b6\u6001\u7684\u67e5\u8be2");
            if (this.needRespond && res.getStatus() == 0) {
                res = this.handleDownMessage(chargeDeviceProps);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    public MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u5931\u8d25 >>> \u8bbe\u5907\u5404\u63d2\u5ea7\u7684\u72b6\u6001\u7684\u67e5\u8be2");
        if (chargeDeviceProps != null && chargeDeviceProps.getDeviceId() != null) {
            Integer plugCount = chargeDeviceProps.getPlugCount() != null ? chargeDeviceProps.getPlugCount() : 0;
            StringBuilder msg2Device = new StringBuilder();
            msg2Device.append(this.opType);
            for (int i = 1; i <= plugCount; ++i) {
                String plugStatus = null;
                if (chargeDeviceProps.getPlugPropsMap() != null && chargeDeviceProps.getPlugPropsMap().get(i) != null) {
                    plugStatus = chargeDeviceProps.getPlugPropsMap().get(i).getStatus();
                }
                plugStatus = StringUtils.isNotBlank(plugStatus) ? plugStatus.trim() : "F";
                msg2Device.append("#").append(plugStatus);
            }
            boolean bp = this.response2device(chargeDeviceProps.getDeviceId(), msg2Device.toString(), this.opType);
            if (bp) {
                res.setStatus(0);
                res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u6210\u529f >>> \u8bbe\u5907\u5404\u63d2\u5ea7\u7684\u72b6\u6001\u7684\u67e5\u8be2");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }
}

