/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.DateFormatUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProtocolEnum;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.RefreshChargeRecordResult;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.impl.MqttMessageHandlerImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class StopHandlerImpl
extends MqttMessageHandlerImpl
implements MqttMessageHandler {
    public StopHandlerImpl(MqttClient mqttClient, MqttMsgLogDao mqttMsgLogDao) {
        super("stop", mqttClient, mqttMsgLogDao, false);
    }

    @Override
    public MsgHandleResponse handleUpMessage(ChargeDeviceProps chargeDeviceProps, MqttMessage mqttMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleUpMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(-1);
        res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u5931\u8d25 <<< \u7ed3\u675f\u5145\u7535\u547d\u4ee4");
        if (chargeDeviceProps != null && StringUtils.isNotBlank((CharSequence)chargeDeviceProps.getDeviceId())) {
            Map<String, Object> chargeRecordMap;
            boolean continueCharge = false;
            String deviceId = chargeDeviceProps.getDeviceId();
            String rcvdMsg = new String(mqttMessage.getPayload());
            String[] rcvdMsgArray = rcvdMsg.split("#");
            String plugId = null;
            String remain = null;
            String stopReason = null;
            String stopPower = null;
            String remainTime = null;
            Date currTime = new Date();
            if (rcvdMsgArray.length >= 3) {
                plugId = rcvdMsgArray[2];
            }
            if (rcvdMsgArray.length >= 4) {
                remain = rcvdMsgArray[chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201804) || chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201805) ? 5 : 3];
            }
            if (rcvdMsgArray.length >= 5) {
                stopReason = rcvdMsgArray[chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201804) || chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201805) ? 3 : 4];
            }
            if (rcvdMsgArray.length >= 6) {
                stopPower = rcvdMsgArray[chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201804) || chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201805) ? 4 : 5];
            }
            if (rcvdMsgArray.length >= 7) {
                remainTime = rcvdMsgArray[6];
            }
            if (MapUtils.isNotEmpty(chargeRecordMap = this.chargeRecordCache.getChargeRecordMap(deviceId, plugId))) {
                HashMap<String, Object> chargeorderLoadMap = new HashMap<String, Object>();
                Double valRemain = 0.0;
                Double valStopPower = 0.0;
                Double valRemainTime = 0.0;
                if (StringUtils.isNotBlank((CharSequence)remain)) {
                    try {
                        valRemain = Double.parseDouble(remain);
                    }
                    catch (NumberFormatException _nfe) {
                        this.logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)stopPower)) {
                    try {
                        valStopPower = Double.parseDouble(stopPower);
                    }
                    catch (NumberFormatException _nfe) {
                        this.logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)remainTime)) {
                    try {
                        valRemainTime = Double.parseDouble(remainTime);
                    }
                    catch (NumberFormatException _nfe) {
                        this.logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
                    }
                }
                RefreshChargeRecordResult result = this.refreshChargeRecord(deviceId, plugId, valRemain, valStopPower, valRemainTime, currTime);
                chargeorderLoadMap.put("CHGORDERNO", result.getChargeRecordValueMap().get("chargeRecordId"));
                chargeorderLoadMap.put("LOADTIME", DateFormatUtils.format((Date)currTime, (String)"yyyyMMddHHmmss"));
                chargeorderLoadMap.put("LOADVALUE", valStopPower / 1000.0);
                this.chargeRecordCache.updateChargeRecord(deviceId, plugId, result.getChargeRecordValueMap());
                Integer chargeOpenFlag = (Integer)result.getChargeRecordValueMap().get("chargeOpenFlag");
                Date chargeOpenTime = (Date)result.getChargeRecordValueMap().get("chargeOpenTime");
                if (!chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201804) && !chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_EBIKE_201805) && !chargeDeviceProps.getChargeDeviceProtocol().equals(ChargeDeviceProtocolEnum.MQTT_YJM2M_201804) && StringUtils.equals((CharSequence)stopReason, (CharSequence)"2") && (valStopPower.compareTo(0.0) > 0 && valRemain.compareTo(0.0) > 0 && valRemainTime.compareTo(0.0) > 0 || chargeOpenFlag == 0 && currTime.getTime() - chargeOpenTime.getTime() < 120000L)) {
                    String msg2Device = "start#" + plugId + "#" + Math.round(valRemain) + "#" + Math.round(valRemainTime);
                    this.response2device(deviceId, msg2Device, "start");
                    continueCharge = true;
                }
                if (!continueCharge) {
                    HashMap<String, Object> finishValueMap = new HashMap<String, Object>();
                    finishValueMap.put("finishReason", stopReason);
                    if (StringUtils.isNotBlank((CharSequence)stopPower)) {
                        try {
                            finishValueMap.put("finishPower", Double.valueOf(stopPower) / 1000.0);
                        }
                        catch (NumberFormatException _nfe) {
                            this.logger.error(_nfe.getMessage(), _nfe.fillInStackTrace());
                        }
                    }
                    this.chargeRecordCache.finishChargeRecord(deviceId, plugId, finishValueMap);
                    this.chargeOrderEventPublisher.publishEvent("finish", this.chargeRecordCache.getHistroyChargeRecord((String)chargeRecordMap.get("chargeRecordId")));
                }
                this.chargeRecordCache.saveChargeorderLoadMap(chargeorderLoadMap);
            } else if (this.fitconnDebuggingCache.checkIsDebugging(deviceId, plugId)) {
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                valueMap.put("debugFinishTime", new Date());
                this.fitconnDebuggingCache.finishFitconnDebuggingLog(deviceId, plugId, valueMap);
            }
            this.logger.debug(" chargedevice opstatus    : " + chargeDeviceProps.getOpStatus());
            this.logger.debug(" continueCharge           : " + continueCharge);
            if (StringUtils.equals((CharSequence)"1", (CharSequence)chargeDeviceProps.getOpStatus())) {
                if (!continueCharge) {
                    this.logger.debug(" deviceId : " + deviceId);
                    this.logger.debug(" plugId   : " + plugId);
                    this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
                }
            } else {
                this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "9");
            }
            res.setStatus(0);
            res.setMsg("\u5904\u7406\u4e0a\u884c\uff08\u8bbe\u5907\u5230\u670d\u52a1\u5668\uff09\u6d88\u606f\u6210\u529f <<< \u7ed3\u675f\u5145\u7535\u547d\u4ee4");
            if (this.needRespond && res.getStatus() == 0) {
                res = this.handleDownMessage(chargeDeviceProps);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleUpMessage <<<<<<< ");
        }
        return res;
    }

    @Override
    public MsgHandleResponse handleDownMessage(ChargeDeviceProps chargeDeviceProps) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start handleDownMessage >>>>>> ");
        }
        MsgHandleResponse res = new MsgHandleResponse();
        res.setStatus(0);
        res.setMsg("\u5904\u7406\u4e0b\u884c\uff08\u670d\u52a1\u5668\u5230\u8bbe\u5907\uff09\u6d88\u606f\u6210\u529f >>> \u7ed3\u675f\u5145\u7535\u547d\u4ee4");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end handleDownMessage <<<<<<< ");
        }
        return res;
    }
}

