/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.service.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.MapUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeDeviceCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.ChargeRecordCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.FitconnDebuggingCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.cache.OpsWorkOrderCache;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargePlugProps;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.MsgHandleResponse;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandler;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.handler.MqttMessageHandlerFactory;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeProfile;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeService;
import cn.yunrui.mqttclient.ebikesrv.syncevent.publisher.ChargeOrderEventPublisher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBikeChargeServiceImpl
implements EBikeChargeService {
    private static final int QOS = 1;
    private static final boolean RETAINED = false;
    private static final long WAITTIMEOUT = 3000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(30, 300, 90L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    private final EBikeChargeProfile ebikeChargeProfile;
    private final MqttClient mqttClient;
    @Resource(name="mqttMsgLogDao")
    private MqttMsgLogDao mqttMsgLogDao;
    @Resource(name="chargeDeviceCache")
    private ChargeDeviceCache chargeDeviceCache;
    @Resource(name="chargeRecordCache")
    private ChargeRecordCache chargeRecordCache;
    @Resource(name="fitconnDebuggingCache")
    private FitconnDebuggingCache fitconnDebuggingCache;
    @Resource(name="opsWorkOrderCache")
    private OpsWorkOrderCache opsWorkOrderCache;
    @Resource(name="chargeOrderEventPublisher")
    private ChargeOrderEventPublisher chargeOrderEventPublisher;

    public EBikeChargeServiceImpl(EBikeChargeProfile ebikeChargeProfile) throws MqttException {
        this.ebikeChargeProfile = ebikeChargeProfile;
        String serverURI = "tcp://" + ebikeChargeProfile.getBrokerHostIp() + ":" + ebikeChargeProfile.getBrokerHostPort();
        String clientId = ebikeChargeProfile.getServerClientId();
        this.mqttClient = new MqttClient(serverURI, clientId, (MqttClientPersistence)new MemoryPersistence());
        this.connectBroker();
    }

    @Override
    public boolean publish2device(String deviceId, byte[] payload, String type) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start publish2device >>>>>> ");
            this.logger.debug(" [ deviceId : " + deviceId + ", message : " + new String(payload) + ", type : " + type + " ] ");
        }
        try {
            String end = "";
            if (this.chargeDeviceCache.get(deviceId) != null && StringUtils.equals((CharSequence)"hzchaoxiang", (CharSequence)this.chargeDeviceCache.get(deviceId).getFactory())) {
                end = "#";
            } else if (this.chargeDeviceCache.get(deviceId) != null && StringUtils.equals((CharSequence)"silan", (CharSequence)this.chargeDeviceCache.get(deviceId).getFactory())) {
                end = "#" + String.format("%010d", new DateTime(DateTimeZone.forID((String)"Etc/GMT-8")).getMillis() / 1000L);
            }
            byte[] payloadExtend = new byte[payload.length + end.getBytes().length];
            System.arraycopy(payload, 0, payloadExtend, 0, payload.length);
            if (end.getBytes().length > 0) {
                System.arraycopy(end.getBytes(), 0, payloadExtend, payload.length, end.getBytes().length);
            }
            String messageFinal = new String(payloadExtend);
            MqttTopic mqttTopicDevice = this.mqttClient.getTopic(this.chargeDeviceCache.get(deviceId) != null && StringUtils.equals((CharSequence)"hzchaoxiang", (CharSequence)this.chargeDeviceCache.get(deviceId).getFactory()) ? "$client/" + deviceId : deviceId);
            MqttMessage mm = new MqttMessage(payloadExtend);
            mm.setQos(1);
            mm.setRetained(false);
            MqttDeliveryToken token = mqttTopicDevice.publish(mm);
            token.waitForCompletion(3000L);
            if (token.isComplete()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" >>>>>> mm         : " + new String(mm.getPayload()) + " >>>>>> ");
                    this.logger.debug(" >>>>>> completion : " + token.isComplete() + " >>>>>> ");
                }
                Thread thread = new Thread(() -> {
                    this.mqttMsgLogDao.insertMqttMsgLog(mqttTopicDevice.getName(), mm, deviceId, type, "down", "request");
                    if (StringUtils.equals((CharSequence)"start", (CharSequence)type) || StringUtils.equals((CharSequence)"cardCharge", (CharSequence)type) || StringUtils.equals((CharSequence)"cardCharge2", (CharSequence)type) || StringUtils.equals((CharSequence)"coinCharge", (CharSequence)type)) {
                        String[] msgArray;
                        String plugId = null;
                        if (StringUtils.isNotBlank((CharSequence)messageFinal) && (msgArray = messageFinal.split("#")).length >= 2) {
                            plugId = msgArray[1];
                        }
                        if (StringUtils.isNotBlank((CharSequence)deviceId) && StringUtils.isNotBlank(plugId)) {
                            this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "1");
                        }
                        ChargeDeviceProps cdp = this.chargeDeviceCache.reload(deviceId);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(" >>> \u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58 >>> ");
                            this.logger.debug(" ChargeDeviceProps : " + (cdp != null ? cdp.toString() : null));
                        }
                    }
                });
                this.pool.execute(thread);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" <<<<<<< end publish2device <<<<<<< ");
            }
            return token.isComplete();
        }
        catch (MqttException _me) {
            this.logger.error(_me.getMessage(), _me.fillInStackTrace());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" <<<<<<< end publish2device <<<<<<< ");
            }
            return false;
        }
    }

    @Override
    public boolean publish2device(String deviceId, String message, String type) {
        return this.publish2device(deviceId, message.getBytes(), type);
    }

    @Override
    public void finishChargeRecord(String deviceId, String plugId, int openFlag, int reason) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        if (openFlag == 1) {
            valueMap.put("chargeOpenFlag", reason >= 0 ? 0 : reason);
            valueMap.put("chargeOpenTime", new Date());
            this.chargeRecordCache.updateChargeRecord(deviceId, plugId, valueMap);
        }
        HashMap<String, Object> finishValueMap = new HashMap<String, Object>();
        finishValueMap.put("finishReason", String.valueOf(reason));
        this.chargeRecordCache.finishChargeRecord(deviceId, plugId, finishValueMap);
        ChargeDeviceProps cdp = this.chargeDeviceCache.get(deviceId);
        if (StringUtils.equals((CharSequence)"1", (CharSequence)cdp.getOpStatus())) {
            this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "0");
        } else {
            this.chargeDeviceCache.updatePlugStatus(deviceId, plugId, "9");
        }
    }

    @Override
    public void finishFitconnDebugging(String deviceId, String plugId) {
    }

    private void connectBroker() {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setAutomaticReconnect(true);
        options.setCleanSession(false);
        options.setUserName(this.ebikeChargeProfile.getBrokerUsername());
        options.setPassword(this.ebikeChargeProfile.getBrokerPassword().toCharArray());
        options.setConnectionTimeout(10);
        options.setKeepAliveInterval(30);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" >>>>>> connectBroker >>>>>> ");
            }
            this.mqttClient.connect(options);
            Object[] subTopics = (String[])Iterables.toArray((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)this.ebikeChargeProfile.getServerSubTopic()), String.class);
            int[] qoss = new int[subTopics.length];
            Arrays.fill(qoss, 1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" subTopics    : " + Arrays.toString(subTopics));
                this.logger.debug(" qoss         : " + Arrays.toString(qoss));
            }
            this.mqttClient.subscribe((String[])subTopics, qoss);
            this.mqttClient.setCallback((MqttCallback)new PushCallback());
            this.mqttClient.setManualAcks(false);
            this.mqttClient.setTimeToWait(3000L);
        }
        catch (MqttException _me) {
            this.logger.error(_me.getMessage(), _me.fillInStackTrace());
        }
    }

    private class PushCallback
    implements MqttCallbackExtended {
        private PushCallback() {
        }

        public void connectComplete(boolean reconnect, String serverURI) {
            if (EBikeChargeServiceImpl.this.logger.isDebugEnabled()) {
                EBikeChargeServiceImpl.this.logger.debug(" >>>>>> [main service] start connectComplete >>>>>> ");
                EBikeChargeServiceImpl.this.logger.debug(" reconnect  : " + reconnect);
                EBikeChargeServiceImpl.this.logger.debug(" serverURI  : " + serverURI);
                EBikeChargeServiceImpl.this.logger.debug(" <<<<<<< [main service] end connectComplete <<<<<<< ");
            }
        }

        public void connectionLost(Throwable throwable) {
            EBikeChargeServiceImpl.this.logger.warn(" >>>>>> [main service] start connectionLost >>>>>> ");
            EBikeChargeServiceImpl.this.logger.error(" Connection lost with cause \"" + throwable.getMessage() + "\", Reason code : " + ((MqttException)throwable).getReasonCode() + "\" Cause : \"" + throwable.getCause() + "\"");
            EBikeChargeServiceImpl.this.logger.error(" error ", throwable);
            EBikeChargeServiceImpl.this.logger.warn(" <<<<<<< [main service] end connectionLost <<<<<<< ");
        }

        public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
            if (EBikeChargeServiceImpl.this.logger.isDebugEnabled()) {
                EBikeChargeServiceImpl.this.logger.debug(" >>>>>> [main service] start messageArrived >>>>>> ");
                EBikeChargeServiceImpl.this.logger.debug(" topic            : " + topic);
                if (mqttMessage != null && mqttMessage.getPayload() != null) {
                    EBikeChargeServiceImpl.this.logger.debug(" messageId        : " + mqttMessage.getId());
                    EBikeChargeServiceImpl.this.logger.debug(" messageContent   : " + new String(mqttMessage.getPayload()));
                    EBikeChargeServiceImpl.this.logger.debug(" qos              : " + mqttMessage.getQos());
                    EBikeChargeServiceImpl.this.logger.debug(" retained         : " + mqttMessage.isRetained());
                    EBikeChargeServiceImpl.this.logger.debug(" duplicate        : " + mqttMessage.isDuplicate());
                } else {
                    EBikeChargeServiceImpl.this.logger.debug(" mqttMessage is null ");
                }
            }
            if (mqttMessage != null && mqttMessage.getPayload() != null) {
                Thread thread = new Thread(() -> {
                    String[] rcvdMsgArray;
                    String receivedMsg = new String(mqttMessage.getPayload());
                    if (StringUtils.isNotBlank((CharSequence)receivedMsg) && receivedMsg.length() > 0 && (rcvdMsgArray = receivedMsg.trim().split("#")).length >= 2) {
                        MqttMessageHandler handler;
                        String deviceId = rcvdMsgArray[0].trim();
                        String opType = rcvdMsgArray[1].trim();
                        if (EBikeChargeServiceImpl.this.logger.isDebugEnabled()) {
                            EBikeChargeServiceImpl.this.logger.debug(" deviceId : " + deviceId + " , opType : " + opType);
                        }
                        EBikeChargeServiceImpl.this.mqttMsgLogDao.insertMqttMsgLog(topic, mqttMessage, deviceId, opType, "up", "request");
                        ChargeDeviceProps cdp = EBikeChargeServiceImpl.this.chargeDeviceCache.get(deviceId);
                        if (cdp != null && MapUtils.isNotEmpty(cdp.getPlugPropsMap())) {
                            String[] plugStatus = null;
                            if (StringUtils.equals((CharSequence)"0", (CharSequence)cdp.getOpStatus())) {
                                plugStatus = new String[cdp.getPlugPropsMap().size()];
                                for (int i = 0; i < cdp.getPlugPropsMap().size(); ++i) {
                                    ChargePlugProps cpp = cdp.getPlugPropsMap().get(i + 1);
                                    if (cpp != null && StringUtils.equals((CharSequence)"8", (CharSequence)cpp.getOpStatus())) {
                                        plugStatus[i] = "8";
                                        continue;
                                    }
                                    if (cpp != null && StringUtils.isNotBlank((CharSequence)cpp.getStatus())) {
                                        if (StringUtils.equals((CharSequence)"F", (CharSequence)cpp.getStatus())) {
                                            plugStatus[i] = "0";
                                            continue;
                                        }
                                        if (StringUtils.equals((CharSequence)"U", (CharSequence)cpp.getStatus())) {
                                            plugStatus[i] = "1";
                                            continue;
                                        }
                                        if (StringUtils.equals((CharSequence)"R", (CharSequence)cpp.getStatus())) {
                                            plugStatus[i] = "2";
                                            continue;
                                        }
                                        plugStatus[i] = "0";
                                        continue;
                                    }
                                    plugStatus[i] = "0";
                                }
                            }
                            EBikeChargeServiceImpl.this.chargeDeviceCache.updateOpStatus(deviceId, "1", plugStatus);
                            if (StringUtils.equals((CharSequence)"02", (CharSequence)cdp.getStatus())) {
                                EBikeChargeServiceImpl.this.chargeDeviceCache.updateDeviceAssertStatus(deviceId, "03");
                            }
                        }
                        if ((handler = MqttMessageHandlerFactory.getInstance(opType, EBikeChargeServiceImpl.this.mqttClient, EBikeChargeServiceImpl.this.mqttMsgLogDao)) != null) {
                            handler.setChargeDeviceCache(EBikeChargeServiceImpl.this.chargeDeviceCache);
                            handler.setChargeRecordCache(EBikeChargeServiceImpl.this.chargeRecordCache);
                            handler.setFitconnDebuggingCache(EBikeChargeServiceImpl.this.fitconnDebuggingCache);
                            handler.setOpsWorkOrderCache(EBikeChargeServiceImpl.this.opsWorkOrderCache);
                            handler.setChargeOrderEventPublisher(EBikeChargeServiceImpl.this.chargeOrderEventPublisher);
                            MsgHandleResponse res = handler.handleUpMessage(cdp, mqttMessage);
                            if (EBikeChargeServiceImpl.this.logger.isDebugEnabled()) {
                                EBikeChargeServiceImpl.this.logger.debug("ChargeDeviceProps : " + JsonConvertUtils.convertToString(cdp));
                                EBikeChargeServiceImpl.this.logger.debug("MsgHandleResponse : " + JsonConvertUtils.convertToString(res));
                            }
                        } else {
                            EBikeChargeServiceImpl.this.logger.error(" MqttMessageHandlerFactory getInstance is null. [ opType : " + opType + " ] ");
                            EBikeChargeServiceImpl.this.logger.error(" receivedMsg : " + receivedMsg);
                        }
                    }
                });
                EBikeChargeServiceImpl.this.pool.execute(thread);
            }
            if (EBikeChargeServiceImpl.this.logger.isDebugEnabled()) {
                EBikeChargeServiceImpl.this.logger.debug(" <<<<<<< [main service] end messageArrived <<<<<<< ");
            }
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
            if (EBikeChargeServiceImpl.this.logger.isDebugEnabled()) {
                EBikeChargeServiceImpl.this.logger.debug(" >>>>>> [main service] start deliveryComplete >>>>>> ");
                EBikeChargeServiceImpl.this.logger.debug(" deliveryComplete : " + token.isComplete());
                EBikeChargeServiceImpl.this.logger.debug(" <<<<<<< [main service] end deliveryComplete <<<<<<< ");
            }
        }
    }
}

