/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.mqttclient.service.impl;

import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.MqttMsgLogDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.dao.TestingDao;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeDeviceProtocolEnum;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.TestingChargeDevice;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.TestingChargePlug;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeChargeProfile;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.service.EBikeTestingService;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBikeTestingServiceImpl
implements EBikeTestingService {
    private static final int QOS = 1;
    private static final boolean RETAINED = false;
    private static final long WAITTIMEOUT = 3000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(10, 30, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    private final EBikeChargeProfile ebikeTestingProfile;
    private final MqttClient mqttClient;
    @Resource(name="testingDao")
    private TestingDao testingDao;
    @Resource(name="mqttMsgLogDao")
    private MqttMsgLogDao mqttMsgLogDao;

    public EBikeTestingServiceImpl(EBikeChargeProfile ebikeTestingProfile) throws MqttException {
        this.ebikeTestingProfile = ebikeTestingProfile;
        String serverURI = "tcp://" + ebikeTestingProfile.getBrokerHostIp() + ":" + ebikeTestingProfile.getBrokerHostPort();
        String clientId = ebikeTestingProfile.getServerClientId();
        this.mqttClient = new MqttClient(serverURI, clientId, (MqttClientPersistence)new MemoryPersistence());
        this.connectBroker();
    }

    @Override
    public boolean publish2device(String deviceId, byte[] payload, String type) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start publish2device >>>>>> ");
            this.logger.debug(" [ deviceId : " + deviceId + ", message : " + new String(payload) + ", type : " + type + " ] ");
        }
        try {
            TestingChargeDevice tcd = this.testingDao.getTestingChargeDeviceByDeviceId(deviceId);
            String end = "";
            if (tcd != null && StringUtils.equals((CharSequence)"hzchaoxiang", (CharSequence)tcd.getFactory())) {
                end = "#";
            } else if (tcd != null && StringUtils.equals((CharSequence)"silan", (CharSequence)tcd.getFactory())) {
                end = "#" + String.format("%010d", new DateTime(DateTimeZone.forID((String)"Etc/GMT-8")).getMillis() / 1000L);
            }
            byte[] payloadExtend = new byte[payload.length + end.getBytes().length];
            System.arraycopy(payload, 0, payloadExtend, 0, payload.length);
            if (end.getBytes().length > 0) {
                System.arraycopy(end.getBytes(), 0, payloadExtend, payload.length, end.getBytes().length);
            }
            MqttTopic mqttTopicDevice = this.mqttClient.getTopic(tcd != null && StringUtils.equals((CharSequence)"hzchaoxiang", (CharSequence)tcd.getFactory()) ? "$client/" + deviceId : deviceId);
            MqttMessage mm = new MqttMessage(payloadExtend);
            mm.setQos(1);
            mm.setRetained(false);
            MqttDeliveryToken token = mqttTopicDevice.publish(mm);
            token.waitForCompletion(3000L);
            if (token.isComplete()) {
                Thread thread = new Thread(() -> this.mqttMsgLogDao.insertTestingMqttMsgLog(mqttTopicDevice.getName(), mm, deviceId, type, "down", "request"));
                this.pool.execute(thread);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" <<<<<<< end publish2device <<<<<<< ");
            }
            return token.isComplete();
        }
        catch (MqttException _me) {
            this.logger.error(_me.getMessage(), _me.fillInStackTrace());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" <<<<<<< end publish2device <<<<<<< ");
            }
            return false;
        }
    }

    @Override
    public boolean publish2device(String deviceId, String message, String type) {
        return this.publish2device(deviceId, message.getBytes(), type);
    }

    private void connectBroker() {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setAutomaticReconnect(true);
        options.setCleanSession(false);
        options.setUserName(this.ebikeTestingProfile.getBrokerUsername());
        options.setPassword(this.ebikeTestingProfile.getBrokerPassword().toCharArray());
        options.setConnectionTimeout(10);
        options.setKeepAliveInterval(30);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" >>>>>> connectBroker >>>>>> ");
            }
            this.mqttClient.connect(options);
            Object[] subTopics = (String[])Iterables.toArray((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)this.ebikeTestingProfile.getServerSubTopic()), String.class);
            int[] qoss = new int[subTopics.length];
            Arrays.fill(qoss, 1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" subTopics    : " + Arrays.toString(subTopics));
                this.logger.debug(" qoss         : " + Arrays.toString(qoss));
            }
            this.mqttClient.subscribe((String[])subTopics, qoss);
            this.mqttClient.setCallback((MqttCallback)new PushCallback());
            this.mqttClient.setManualAcks(false);
            this.mqttClient.setTimeToWait(3000L);
        }
        catch (MqttException _me) {
            this.logger.error(_me.getMessage(), _me.fillInStackTrace());
        }
    }

    private class PushCallback
    implements MqttCallbackExtended {
        private PushCallback() {
        }

        public void connectComplete(boolean reconnect, String serverURI) {
            if (EBikeTestingServiceImpl.this.logger.isDebugEnabled()) {
                EBikeTestingServiceImpl.this.logger.debug(" >>>>>> [testing service] start connectComplete >>>>>> ");
                EBikeTestingServiceImpl.this.logger.debug(" reconnect  : " + reconnect);
                EBikeTestingServiceImpl.this.logger.debug(" serverURI  : " + serverURI);
                EBikeTestingServiceImpl.this.logger.debug(" <<<<<<< [testing service] end connectComplete <<<<<<< ");
            }
        }

        public void connectionLost(Throwable throwable) {
            EBikeTestingServiceImpl.this.logger.warn(" >>>>>> [testing service] start connectionLost >>>>>> ");
            EBikeTestingServiceImpl.this.logger.error(" Connection lost with cause \"" + throwable.getMessage() + "\", Reason code : " + ((MqttException)throwable).getReasonCode() + "\" Cause : \"" + throwable.getCause() + "\"");
            EBikeTestingServiceImpl.this.logger.error(" error ", throwable);
            EBikeTestingServiceImpl.this.logger.warn(" <<<<<<< [testing service] end connectionLost <<<<<<< ");
        }

        public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
            if (EBikeTestingServiceImpl.this.logger.isDebugEnabled()) {
                EBikeTestingServiceImpl.this.logger.debug(" >>>>>> [testing service] start messageArrived >>>>>> ");
                EBikeTestingServiceImpl.this.logger.debug(" topic            : " + topic);
                if (mqttMessage != null) {
                    EBikeTestingServiceImpl.this.logger.debug(" mqttMessage      : " + new String(mqttMessage.getPayload()));
                } else {
                    EBikeTestingServiceImpl.this.logger.debug(" mqttMessage is null ");
                }
            }
            if (mqttMessage != null) {
                Thread thread = new Thread(() -> {
                    Object[] strMsgArray;
                    String strMsg = new String(mqttMessage.getPayload());
                    if (StringUtils.isNotBlank((CharSequence)strMsg) && strMsg.length() > 0 && (strMsgArray = strMsg.trim().split("#")).length >= 2) {
                        String deviceId = strMsgArray[0].trim();
                        String opType = strMsgArray[1].trim();
                        if (EBikeTestingServiceImpl.this.logger.isDebugEnabled()) {
                            EBikeTestingServiceImpl.this.logger.debug(" deviceId : " + deviceId + " , opType : " + opType);
                            EBikeTestingServiceImpl.this.logger.debug(" msgArray : " + Arrays.toString(strMsgArray));
                            EBikeTestingServiceImpl.this.logger.debug(" size     : " + strMsgArray.length);
                        }
                        EBikeTestingServiceImpl.this.mqttMsgLogDao.insertTestingMqttMsgLog(topic, mqttMessage, deviceId, opType, "up", "request");
                        TestingChargeDevice tcd = EBikeTestingServiceImpl.this.testingDao.getTestingChargeDeviceByDeviceId(deviceId);
                        if (tcd != null) {
                            tcd.setOpStatus("1");
                            EBikeTestingServiceImpl.this.testingDao.updateTestingChargeDevice(tcd);
                        }
                        if (StringUtils.equals((CharSequence)"mqtt", (CharSequence)opType)) {
                            String msg2Device = "mqtt#ERROR";
                            EBikeTestingServiceImpl.this.publish2device(deviceId, msg2Device, opType);
                        } else if (StringUtils.equals((CharSequence)"param", (CharSequence)opType)) {
                            if (tcd != null) {
                                String maxPlugPower = "600";
                                String maxDevicePower = "2500";
                                String cardPassword = "000000000000";
                                String factor = "1000";
                                String reporttime = "1";
                                StringBuilder msg2Device = new StringBuilder();
                                msg2Device.append("param");
                                if (ChargeDeviceProtocolEnum.MQTT_EBIKE_201804.equals(tcd.getChargeDeviceProtocol())) {
                                    msg2Device.append("#").append(maxPlugPower);
                                    msg2Device.append("#").append(maxDevicePower);
                                    msg2Device.append("#").append(factor);
                                } else if (ChargeDeviceProtocolEnum.MQTT_EBIKE_201805.equals(tcd.getChargeDeviceProtocol())) {
                                    msg2Device.append("#").append(maxPlugPower);
                                    msg2Device.append("#").append(maxDevicePower);
                                    msg2Device.append("#").append(factor);
                                    msg2Device.append("#").append(reporttime);
                                } else {
                                    msg2Device.append("#").append(maxPlugPower);
                                    msg2Device.append("#").append(maxDevicePower);
                                    msg2Device.append("#").append(cardPassword);
                                    msg2Device.append("#").append(factor);
                                }
                                String r = "0";
                                String t = "0";
                                for (int i = 0; i < tcd.getPlugCount(); ++i) {
                                    msg2Device.append("#").append(r).append(",").append(t);
                                }
                                EBikeTestingServiceImpl.this.publish2device(deviceId, msg2Device.toString(), opType);
                            }
                        } else if (StringUtils.equals((CharSequence)"attachParam", (CharSequence)opType)) {
                            if (tcd != null) {
                                String floatChargeTime = "120";
                                String noloadTime = "180";
                                String unitLimit = "1000";
                                String unitLimitTime = "180";
                                StringBuilder msg2Device = new StringBuilder();
                                msg2Device.append("attachParam");
                                if (ChargeDeviceProtocolEnum.MQTT_EBIKE_201804.equals(tcd.getChargeDeviceProtocol())) {
                                    if (StringUtils.equals((CharSequence)"hzchaoxiang", (CharSequence)tcd.getFactory())) {
                                        msg2Device.append("#").append(String.valueOf(Integer.parseInt(floatChargeTime) * 60));
                                    } else {
                                        msg2Device.append("#").append(floatChargeTime);
                                    }
                                    msg2Device.append("#").append(noloadTime);
                                    msg2Device.append("#").append(unitLimit);
                                    msg2Device.append("#").append(unitLimitTime);
                                } else if (ChargeDeviceProtocolEnum.MQTT_EBIKE_201805.equals(tcd.getChargeDeviceProtocol())) {
                                    msg2Device.append("#").append(floatChargeTime);
                                    msg2Device.append("#").append(noloadTime);
                                    if (StringUtils.equals((CharSequence)"gaea", (CharSequence)tcd.getFactory())) {
                                        msg2Device.append("#").append(unitLimit);
                                        msg2Device.append("#").append(unitLimitTime);
                                    }
                                } else {
                                    msg2Device.append("#").append(floatChargeTime);
                                }
                                EBikeTestingServiceImpl.this.publish2device(deviceId, msg2Device.toString(), opType);
                            }
                        } else if (StringUtils.equals((CharSequence)"status", (CharSequence)opType)) {
                            if (tcd != null) {
                                int i;
                                String rcvdMsg = new String(mqttMessage.getPayload());
                                String[] rcvdMsgArray = rcvdMsg.split("#");
                                Integer plugCount = tcd.getPlugCount() != null ? tcd.getPlugCount() : 0;
                                Double[] remains = new Double[plugCount.intValue()];
                                Double[] powers = new Double[plugCount.intValue()];
                                Double[] times = new Double[plugCount.intValue()];
                                if (ChargeDeviceProtocolEnum.MQTT_EBIKE_201804.equals(tcd.getChargeDeviceProtocol()) || ChargeDeviceProtocolEnum.MQTT_EBIKE_201805.equals(tcd.getChargeDeviceProtocol())) {
                                    if (rcvdMsgArray.length >= plugCount + 2) {
                                        for (i = 0; i < plugCount; ++i) {
                                            String[] plugValArray = rcvdMsgArray[2 + i].split(",");
                                            String strRemain = plugValArray.length >= 1 ? plugValArray[0] : null;
                                            String strTime = plugValArray.length >= 2 ? plugValArray[1] : null;
                                            String strPower = plugValArray.length >= 3 ? plugValArray[2] : null;
                                            remains[i] = StringUtils.isNotBlank((CharSequence)strRemain) ? Double.valueOf(Double.parseDouble(strRemain)) : null;
                                            powers[i] = StringUtils.isNotBlank((CharSequence)strPower) ? Double.valueOf(Double.parseDouble(strPower)) : null;
                                            times[i] = StringUtils.isNotBlank((CharSequence)strTime) ? Double.valueOf(Double.parseDouble(strTime)) : null;
                                        }
                                    }
                                } else if (rcvdMsgArray.length >= plugCount * 3 + 2) {
                                    for (i = 0; i < plugCount; ++i) {
                                        remains[i] = StringUtils.isNotBlank((CharSequence)rcvdMsgArray[2 + i * 2]) ? Double.valueOf(Double.parseDouble(rcvdMsgArray[2 + i * 2])) : null;
                                        powers[i] = StringUtils.isNotBlank((CharSequence)rcvdMsgArray[2 + i * 2 + 1]) ? Double.valueOf(Double.parseDouble(rcvdMsgArray[2 + i * 2 + 1])) : null;
                                        times[i] = StringUtils.isNotBlank((CharSequence)rcvdMsgArray[2 + plugCount * 3 - (plugCount - i)]) ? Double.valueOf(Double.parseDouble(rcvdMsgArray[2 + plugCount * 3 - (plugCount - i)])) : null;
                                    }
                                }
                                if (EBikeTestingServiceImpl.this.logger.isDebugEnabled()) {
                                    EBikeTestingServiceImpl.this.logger.debug(" remains      : " + JsonConvertUtils.convertToString(remains));
                                    EBikeTestingServiceImpl.this.logger.debug(" powers       : " + JsonConvertUtils.convertToString(powers));
                                    EBikeTestingServiceImpl.this.logger.debug(" times        : " + JsonConvertUtils.convertToString(times));
                                }
                                StringBuilder msg2Device = new StringBuilder();
                                msg2Device.append(opType);
                                for (int i2 = 0; i2 < plugCount; ++i2) {
                                    Double remain = remains[i2];
                                    Double time = times[i2];
                                    String plugStatus = "F";
                                    if (remain != null && time != null && remain.compareTo(0.0) > 0 && time.compareTo(0.0) > 0 || remain != null && time == null && remain.compareTo(0.0) > 0 || remain == null && time != null && time.compareTo(0.0) > 0) {
                                        plugStatus = "U";
                                    }
                                    msg2Device.append("#").append(plugStatus);
                                }
                                EBikeTestingServiceImpl.this.publish2device(deviceId, msg2Device.toString(), opType);
                            }
                        } else if (StringUtils.equals((CharSequence)"start", (CharSequence)opType)) {
                            String rcvdMsg = new String(mqttMessage.getPayload());
                            String[] rcvdMsgArray = rcvdMsg.split("#");
                            String plugId = null;
                            String result = null;
                            if (rcvdMsgArray.length >= 4) {
                                plugId = rcvdMsgArray[2];
                                result = rcvdMsgArray[3];
                            }
                            if (EBikeTestingServiceImpl.this.logger.isDebugEnabled()) {
                                EBikeTestingServiceImpl.this.logger.debug(" plugId   : " + plugId);
                                EBikeTestingServiceImpl.this.logger.debug(" result   : " + result);
                            }
                            if (StringUtils.isNotBlank((CharSequence)plugId)) {
                                TestingChargePlug tcp = EBikeTestingServiceImpl.this.testingDao.getTestingChargePlugByDeviceIdAndPlugSn(deviceId, Integer.parseInt(plugId));
                                if (StringUtils.equals((CharSequence)"0", (CharSequence)result)) {
                                    tcp.setTestStatus("02");
                                    tcp.setTestStatusDesc("\u5f00\u542f\u6210\u529f");
                                } else {
                                    tcp.setTestStatus("03");
                                    tcp.setTestStatusDesc("\u5f00\u542f\u5931\u8d25");
                                }
                                EBikeTestingServiceImpl.this.testingDao.updateTestingChargePlug(tcp);
                            }
                        } else if (StringUtils.equals((CharSequence)"stop", (CharSequence)opType)) {
                            String rcvdMsg = new String(mqttMessage.getPayload());
                            String[] rcvdMsgArray = rcvdMsg.split("#");
                            String plugId = null;
                            if (rcvdMsgArray.length >= 3) {
                                plugId = rcvdMsgArray[2];
                            }
                            if (EBikeTestingServiceImpl.this.logger.isDebugEnabled()) {
                                EBikeTestingServiceImpl.this.logger.debug(" plugId   : " + plugId);
                            }
                            if (StringUtils.isNotBlank((CharSequence)plugId)) {
                                TestingChargePlug tcp = EBikeTestingServiceImpl.this.testingDao.getTestingChargePlugByDeviceIdAndPlugSn(deviceId, Integer.parseInt(plugId));
                                tcp.setTestStatus("07");
                                tcp.setTestStatusDesc("\u5145\u7535\u7ed3\u675f");
                                tcp.setEndTestTime(new Date());
                                EBikeTestingServiceImpl.this.testingDao.updateTestingChargePlug(tcp);
                            }
                        }
                    }
                });
                EBikeTestingServiceImpl.this.pool.execute(thread);
            }
            if (EBikeTestingServiceImpl.this.logger.isDebugEnabled()) {
                EBikeTestingServiceImpl.this.logger.debug(" <<<<<<< [testing service] end messageArrived <<<<<<< ");
            }
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
            if (EBikeTestingServiceImpl.this.logger.isDebugEnabled()) {
                EBikeTestingServiceImpl.this.logger.debug(" >>>>>> [testing service] start deliveryComplete >>>>>> ");
                EBikeTestingServiceImpl.this.logger.debug(" deliveryComplete : " + token.isComplete());
                EBikeTestingServiceImpl.this.logger.debug(" <<<<<<< [testing service] end deliveryComplete <<<<<<< ");
            }
        }
    }
}

