/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.syncevent.publisher.impl;

import cn.cc.cisp.message.Event;
import cn.cc.cisp.message.SyncEventType;
import cn.yunrui.mqttclient.ebikesrv.common.utils.DateFormatUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.JsonConvertUtils;
import cn.yunrui.mqttclient.ebikesrv.common.utils.StringUtils;
import cn.yunrui.mqttclient.ebikesrv.mqttclient.entity.ChargeRecord;
import cn.yunrui.mqttclient.ebikesrv.syncevent.publisher.ChargeOrderEventPublisher;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class ChargeOrderEventPublisherImpl
implements ChargeOrderEventPublisher {
    private static final String TOPIC = "SyncEventTopic";
    private static final String EVENT_TYPE = "CHARGERECORD_EVENT";
    private static final String EVENT_TYPE_YZ = "CHARGERECORD_EVENT_YZ";
    private static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="redisTemplate")
    private RedisTemplate redisTemplate;

    @Override
    public void publishEvent(Map<String, Object> eventContent) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start publishEvent >>>>>> ");
            this.logger.debug(" eventContent     : " + JsonConvertUtils.convertToString(eventContent));
        }
        this.redisTemplate.convertAndSend(TOPIC, (Object)new Event(SyncEventType.valueOfKey((String)EVENT_TYPE), (Serializable)JSONObject.fromObject(eventContent)));
    }

    @Override
    public void publishEventYz(Map<String, Object> eventContent) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start publishEventYz >>>>>> ");
            this.logger.debug(" eventContent     : " + JsonConvertUtils.convertToString(eventContent));
        }
        this.redisTemplate.convertAndSend(TOPIC, (Object)new Event(SyncEventType.valueOfKey((String)EVENT_TYPE_YZ), (Serializable)JSONObject.fromObject(eventContent)));
    }

    @Override
    public void publishEvent(String type, ChargeRecord chargeRecord) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start publishEvent >>>>>> ");
            this.logger.debug(" type             : " + type);
            this.logger.debug(" chargeRecord     : " + JsonConvertUtils.convertToString(chargeRecord));
        }
        if (chargeRecord != null) {
            this.publishEventYz(this.buildEventContent(type, chargeRecord));
        }
    }

    private Map<String, Object> buildEventContent(String type, ChargeRecord chargeRecord) {
        HashMap<String, Object> eventContent = new HashMap<String, Object>();
        eventContent.put("type", type);
        eventContent.put("chargeRecordId", chargeRecord.getChargeRecordId());
        eventContent.put("chargeUserId", chargeRecord.getChargeUserId());
        eventContent.put("chargeUserNo", chargeRecord.getChargeUserNo());
        eventContent.put("chargeUserType", chargeRecord.getChargeUserType());
        eventContent.put("chargeplugNo", chargeRecord.getChargedeviceNo() + String.format("%02d", chargeRecord.getPlugSn()));
        eventContent.put("chargedeviceNo", chargeRecord.getChargedeviceNo());
        eventContent.put("plugSn", chargeRecord.getPlugSn());
        eventContent.put("chargestationName", chargeRecord.getChargestationName());
        eventContent.put("chargestationAddr", chargeRecord.getChargestationAddr());
        eventContent.put("chargeTime", DateFormatUtils.format((Date)chargeRecord.getChargeTime(), (String)PATTERN_DATETIME));
        eventContent.put("chargeMoney", chargeRecord.getChargeMoney());
        if (chargeRecord.getChargeOpenTime() != null) {
            eventContent.put("chargeOpenTime", DateFormatUtils.format((Date)chargeRecord.getChargeOpenTime(), (String)PATTERN_DATETIME));
        } else if (StringUtils.equals((CharSequence)type, (CharSequence)"finish")) {
            eventContent.put("chargeOpenTime", DateFormatUtils.format((Date)chargeRecord.getChargeFinishTime(), (String)PATTERN_DATETIME));
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"finish") || StringUtils.equals((CharSequence)type, (CharSequence)"return")) {
            eventContent.put("chargeDuration", Math.round((double)(chargeRecord.getChargeFinishTime().getTime() - chargeRecord.getChargeOpenTime().getTime()) / 60000.0));
            eventContent.put("chargeFinishTime", DateFormatUtils.format((Date)chargeRecord.getChargeFinishTime(), (String)PATTERN_DATETIME));
            eventContent.put("finishReason", chargeRecord.getFinishReason());
            if (StringUtils.equals((CharSequence)chargeRecord.getFinishReason(), (CharSequence)"0")) {
                eventContent.put("finishReasonDesc", "\u7535\u91cf\u7528\u5b8c");
            } else if (StringUtils.equals((CharSequence)chargeRecord.getFinishReason(), (CharSequence)"1")) {
                eventContent.put("finishReasonDesc", "\u6d6e\u5145\u65f6\u95f4\u5b8c\u6210");
            } else if (StringUtils.equals((CharSequence)chargeRecord.getFinishReason(), (CharSequence)"2")) {
                eventContent.put("finishReasonDesc", "\u63d2\u5934\u62d4\u6389\u6216\u5145\u7535\u5145\u6ee1");
            } else if (StringUtils.equals((CharSequence)chargeRecord.getFinishReason(), (CharSequence)"3")) {
                eventContent.put("finishReasonDesc", "\u529f\u7387\u8d85\u9650");
            } else if (StringUtils.equals((CharSequence)chargeRecord.getFinishReason(), (CharSequence)"4")) {
                eventContent.put("finishReasonDesc", "\u8ba1\u65f6\u65f6\u95f4\u5230");
            } else if (StringUtils.equals((CharSequence)chargeRecord.getFinishReason(), (CharSequence)"5")) {
                eventContent.put("finishReasonDesc", "\u63d2\u5ea7\u7aef\u5b50\u5931\u7535");
            } else if (StringUtils.equals((CharSequence)chargeRecord.getFinishReason(), (CharSequence)"-1")) {
                eventContent.put("finishReasonDesc", "\u8bbe\u5907\u603b\u4f53\u529f\u7387\u8d85\u9650");
            } else if (StringUtils.equals((CharSequence)chargeRecord.getFinishReason(), (CharSequence)"-2")) {
                eventContent.put("finishReasonDesc", "\u63d2\u5ea7\u6295\u5e01\u5360\u7528");
            } else if (StringUtils.equals((CharSequence)chargeRecord.getFinishReason(), (CharSequence)"-97")) {
                eventContent.put("finishReasonDesc", "\u7535\u91cf\u7528\u5b8c\u6216\u8ba1\u65f6\u65f6\u95f4\u5230");
            } else if (StringUtils.equals((CharSequence)chargeRecord.getFinishReason(), (CharSequence)"-98")) {
                eventContent.put("finishReasonDesc", "\u5145\u7535\u7ed3\u675f\u8d85\u65f6");
            } else if (StringUtils.equals((CharSequence)chargeRecord.getFinishReason(), (CharSequence)"-99")) {
                eventContent.put("finishReasonDesc", "\u5145\u7535\u5f00\u542f\u8d85\u65f6");
            }
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"return")) {
            eventContent.put("returnMoney", chargeRecord.getReturnMoney());
            eventContent.put("returnTime", DateFormatUtils.format((Date)chargeRecord.getReturnTime(), (String)PATTERN_DATETIME));
            eventContent.put("returnDesc", chargeRecord.getReturnDesc());
        }
        return eventContent;
    }
}

