/*
 * Decompiled with CFR 0.152.
 */
package cn.yunrui.mqttclient.ebikesrv.tablestore;

import cn.yunrui.mqttclient.ebikesrv.tablestore.TableStoreOperations;
import cn.yunrui.mqttclient.ebikesrv.tablestore.TableStoreSource;
import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreTemplate
implements TableStoreOperations {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SyncClient syncClient;
    private final AsyncClient asyncClient;
    private final TableStoreSource tablestoreSource;

    public TableStoreTemplate(TableStoreSource tablestoreSource) {
        this.syncClient = new SyncClient(tablestoreSource.getEndPoint(), tablestoreSource.getAccessKeyId(), tablestoreSource.getAccessKeySecret(), tablestoreSource.getInstanceName(), tablestoreSource.getClientConfiguration());
        this.asyncClient = new AsyncClient(tablestoreSource.getEndPoint(), tablestoreSource.getAccessKeyId(), tablestoreSource.getAccessKeySecret(), tablestoreSource.getInstanceName(), tablestoreSource.getClientConfiguration());
        this.tablestoreSource = tablestoreSource;
    }

    public SyncClient getSyncClient() {
        return this.syncClient;
    }

    public AsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    public TableStoreSource getTablestoreSource() {
        return this.tablestoreSource;
    }

    @Override
    public PutRowResponse putRowSync(PutRowRequest putRowRequest) {
        return this.syncClient.putRow(putRowRequest);
    }

    @Override
    public GetRowResponse getRowSync(GetRowRequest getRowRequest) {
        return this.syncClient.getRow(getRowRequest);
    }

    @Override
    public UpdateRowResponse updateRowSync(UpdateRowRequest updateRowRequest) {
        return this.syncClient.updateRow(updateRowRequest);
    }

    @Override
    public DeleteRowResponse deleteRowSync(DeleteRowRequest deleteRowRequest) {
        return this.syncClient.deleteRow(deleteRowRequest);
    }

    @Override
    public BatchGetRowResponse batchGetRowSync(BatchGetRowRequest batchGetRowRequest) {
        return this.syncClient.batchGetRow(batchGetRowRequest);
    }

    @Override
    public BatchWriteRowResponse batchWriteRowSync(BatchWriteRowRequest batchWriteRowRequest) {
        return this.syncClient.batchWriteRow(batchWriteRowRequest);
    }

    @Override
    public GetRangeResponse getRangeSync(GetRangeRequest getRangeRequest) {
        return this.syncClient.getRange(getRangeRequest);
    }
}

