package com.ebike.openservices.base.service.util;

import java.util.HashMap;
import java.util.Map;

/**
 * 增强的put，可以一次put很多次
 *
 * @param <K>
 * @param <V>
 */
public class BuilderGenericMap<K, V> {
    public Builder<K, V> bd;

    public BuilderGenericMap(Builder<K, V> bd) {
        this.bd = bd;
    }

    public V get(K k) {
        return bd.map.get(k);
    }

    public Map<K, V> map() {
        return bd.map;
    }

    public static class Builder<K, V> {
        Map<K, V> map;

        public Builder() {
            map = new HashMap<K, V>();
        }

        public Builder<K, V> put(K k, V v) {
            map.put(k, v);
            return this;
        }

        public BuilderGenericMap<K, V> builder() {
            return new BuilderGenericMap<K, V>(this);
        }
    }
}
