package com.ebike.openservices.base.service.util;

import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 曲线工具类
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-04-13
 */
public class CurveUtil {
    public static <T> List<String> getValues(T model, String name, int acc, int endIndex) {
        if (model == null) {
            return null;
        }
        Class<?> aClass = model.getClass();
        List<String> result = new ArrayList<>();
        for (int i = 1; i < endIndex; i++) {
            String name2 = name + String.format("%02d", i);
            try {
                Field field = aClass.getDeclaredField(name2);
                if (field == null) {
                    result.add("");
                } else {
                    field.setAccessible(true);
                    Object value = field.get(model);
                    if (value == null) {
                        result.add("");
                    } else {
                        String toString = value.toString();
                        toString = stringAccuracy(toString, acc);
                        result.add(toString);
                    }

                }

            } catch (NoSuchFieldException | IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String stringAccuracy(String value, int acc) {
        if (value == null) {
            return null;
        }

        if (value.equals("0E-8")) {
            value = "0.00000000";
        }

        if (value.length() > acc + 1) {
            value = value.substring(0, value.indexOf(".") + acc + 1);
        }
        // 去掉末尾多余的0
        value = subZeroAndDot(value);
        return value;
    }

    public static String subZeroAndDot(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(".") > 0) {
            // 去掉多余的0
            s = s.replaceAll("0+?$", "");
            // 如最后一位是.则去掉
            s = s.replaceAll("[.]$", "");
        }
        return s;
    }

    /**
     * Description: 生成曲线时间
     *
     * @param length: 时间点位
     * @param step:   每次增长的时长
     * @author: ghl
     * @return: java.util.List<java.lang.String>
     * @date: 2020/4/28 20:14
     */
    public static String[] getDayLables(int length, int step) {

        try {
            String[] strings = new String[length];

            String newTime = "00:00";
            strings[0] = newTime;
            for (int i = 1; i < length; i++) {
                newTime = timeAddStep(newTime, step);
                strings[i] = newTime;
            }

            return strings;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * Description: 处理时间变量
     *
     * @param oldTime: 原时间
     * @param step:    处理时间时长
     * @author: ghl
     * @return: java.lang.String
     * @date: 2020/4/28 20:15
     */
    public static String timeAddStep(String oldTime, int step) {
        try {
            DateFormat df = new SimpleDateFormat("HH:mm");
            Date date = df.parse(oldTime);
            Date expireTime = new Date(date.getTime() + (long) step * 60 * 1000);
            return df.format(expireTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取 获取某年某月 所有日期（yyyy-mm-dd格式字符串）
     *
     * @param year
     * @param month
     * @return
     */
    public static List<String> getMonthFullDay(int year, int month) {
        SimpleDateFormat dateFormatYYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");
        List<String> fullDayList = new ArrayList<>(32);
        // 获得当前日期对象
        Calendar cal = Calendar.getInstance();
        cal.clear();// 清除信息
        cal.set(Calendar.YEAR, year);
        // 1月从0开始
        cal.set(Calendar.MONTH, month - 1);
        // 当月1号
        cal.set(Calendar.DAY_OF_MONTH, 1);
        int count = cal.getActualMaximum(Calendar.DAY_OF_MONTH);
        for (int j = 1; j <= count; j++) {
            fullDayList.add(dateFormatYYYYMMDD.format(cal.getTime()));
            cal.add(Calendar.DAY_OF_MONTH, 1);
        }
        return fullDayList;
    }

    /**
     * 获取某年所有的月份（格式：yyyyMM）
     *
     * @return
     */
    public static List<String> getMonthsByYearForMonth(Integer year) {
        List<String> list = new ArrayList<String>();
        for (int i = 1; i <= 12; i++) {
            list.add(String.valueOf(i));
        }
        return list;
    }

    /**
     * 获取 获取某年某月 所有日期（dd格式字符串）
     *
     * @param year
     * @param month
     * @return
     */
    public static List<String> getMonthFullDayForDay(int year, int month) {
        SimpleDateFormat dateFormatYYYYMMDD = new SimpleDateFormat("dd");
        List<String> fullDayList = new ArrayList<>(32);
        // 获得当前日期对象
        Calendar cal = Calendar.getInstance();
        cal.clear();// 清除信息
        cal.set(Calendar.YEAR, year);
        // 1月从0开始
        cal.set(Calendar.MONTH, month - 1);
        // 当月1号
        cal.set(Calendar.DAY_OF_MONTH, 1);
        int count = cal.getActualMaximum(Calendar.DAY_OF_MONTH);
        for (int j = 1; j <= count; j++) {
            fullDayList.add(dateFormatYYYYMMDD.format(cal.getTime()));
            cal.add(Calendar.DAY_OF_MONTH, 1);
        }
        return fullDayList;
    }

    /**
     * 获取某年所有的月份（格式：yyyyMM）
     *
     * @return
     */
    public static List<String> getMonthsByYear(Integer year) {
        List<String> list = new ArrayList<String>();
        for (int i = 1; i <= 12; i++) {
            switch (i) {
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                case 8:
                case 9:
                    list.add(year + "0" + i);
                    break;
                default:
                    list.add(year + "" + i);
                    break;
            }

        }
        return list;
    }

    /**
     * 给月份去符号 如2020-03  返回202003
     *
     * @param dataStr
     * @return
     */
    public static String removeFormatDataMonth(String dataStr) {
        String newDate = dataStr.substring(0, 4) + dataStr.substring(5, 7);
        return newDate;
    }

    /**
     * 给月份加符号 如202003  返回2020-03
     *
     * @param dataStr
     * @return
     */
    public static String formatDataMonth(String dataStr) {
        String newDate = dataStr.substring(0, 4) + "-" + dataStr.substring(4, 6);
        return newDate;
    }

    /**
     * 给月份集合加符号 如202003  返回2020-03
     *
     * @param labels
     * @return
     */
    public static List<String> formatDataMonthList(List<String> labels) {
        List<String> list = new ArrayList<>();
        for (int i = 0; i < labels.size(); i++) {
            String month = formatDataMonth(labels.get(i));
            list.add(month);
        }
        return list;
    }

    /**
     * 根据开始时间和结束时间返回时间段内的时间集合[01, 02, 03 …… 31]
     *
     * @param beginDate
     * @param endDate
     * @return List
     */
    public static List<String> getDatesBetweenTwoDate(Date beginDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        List<String> lDate = new ArrayList<>();
        cal.setTime(beginDate);
        lDate.add(String.format("%02d", cal.get(Calendar.DAY_OF_MONTH)));// 把开始时间加入集合
        boolean bContinue = true;
        while (bContinue) {
            // 根据日历的规则，为给定的日历字段添加或减去指定的时间量
            cal.add(Calendar.DAY_OF_MONTH, 1);
            // 测试此日期是否在指定日期之后
            if (endDate.after(cal.getTime())) {
                lDate.add(String.format("%02d", cal.get(Calendar.DAY_OF_MONTH)));
            } else {
                break;
            }
        }
        cal.setTime(endDate);
        lDate.add(String.format("%02d", cal.get(Calendar.DAY_OF_MONTH)));// 把结束时间加入集合
        System.out.println(lDate);
        return lDate;
    }

    /**
     * 根据开始时间，结束时间获取期间所有日期yyyy-MM-dd
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    public static List<String> getDatesBetweenTwoDateFormat(Date beginDate, Date endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        List<String> allDate = new ArrayList();
        allDate.add(sdf.format(beginDate));
        Calendar calBegin = Calendar.getInstance();
        // 使用给定的 Date 设置此 Calendar 的时间
        calBegin.setTime(beginDate);
        Calendar calEnd = Calendar.getInstance();
        // 使用给定的 Date 设置此 Calendar 的时间
        calEnd.setTime(endDate);
        // 测试此日期是否在指定日期之后
        while (endDate.after(calBegin.getTime())) {
            // 根据日历的规则，为给定的日历字段添加或减去指定的时间量
            calBegin.add(Calendar.DAY_OF_MONTH, 1);
            allDate.add(sdf.format(calBegin.getTime()));
        }
        return allDate;
    }

    /***
     * 获取两个月份时间段的月份集合 [202101, 202102, 202103, 202104, 202105]
     * @param beginDate
     * @param endDate
     * @return
     */
    public static List<String> getDatesBetweenTwoMonths(String beginDate, String endDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        Date start = sdf.parse(beginDate);
        Date end = sdf.parse(endDate);
        List<String> allDate = new ArrayList();
        Calendar calBegin = Calendar.getInstance();
        allDate.add(beginDate);
        // 使用给定的 Date 设置此 Calendar 的时间
        calBegin.setTime(start);
        // 测试此日期是否在指定日期之后
        while (end.after(calBegin.getTime())) {
            // 根据日历的规则，为给定的日历字段添加或减去指定的时间量
            calBegin.add(Calendar.MONTH, 1);
            allDate.add(sdf.format(calBegin.getTime()));
        }
        return allDate;
    }
}

