package com.ebike.openservices.chgmgmt.dao;

import com.easesource.data.bean.Pager;
import com.ebike.openservices.chgmgmt.entity.EcarCurrentOrdersVo;
import com.ebike.openservices.chgmgmt.entity.EcarHistoryOrdersVo;
import com.ebike.openservices.chgmgmt.request.EcarCurrentOrdersRequestParam;
import com.ebike.openservices.chgmgmt.request.EcarHistoryOrdersRequestParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 功能描述  电动汽车充电订单接口
 *
 * @author zhouyi
 * @return
 * @data 2021/4/13
 */
@Mapper
public interface EcarOrdersDao {
    /**
     * 功能描述  当前订单查询
     *
     * @param param
     * @param pager
     * @return java.util.List<com.ebike.openservices.chgmgmt.entity.EcarCurrentOrdersVo>
     * @author zhouyi
     * @data 2021/4/13
     */
    List<EcarCurrentOrdersVo> getEcarCurrentOrdersData(@Param("param") EcarCurrentOrdersRequestParam param, @Param("pager") Pager pager);

    /**
     * 功能描述 当前订单总数
     *
     * @param param
     * @return int
     * @author zhouyi
     * @data 2021/4/13
     */
    int getEcarCurrentOrdersTotalData(@Param("param") EcarCurrentOrdersRequestParam param);

    /**
     * 功能描述  历史订单查询
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.chgmgmt.entity.EcarHistoryOrdersVo>
     * @data 2021/4/14
     * @param param
     * @param pager
     */
    List<EcarHistoryOrdersVo> getEcarHistoryOrdersData(@Param("param") EcarHistoryOrdersRequestParam param, @Param("pager") Pager pager);

    /**
     * 功能描述  历史订单总数查询
     * @author zhouyi
     * @return int
     * @data 2021/4/14
     * @param param
     */
    int getEcarHistoryOrdersTotalData(@Param("param") EcarHistoryOrdersRequestParam param);

    /**
     * 获取投诉建议--充电曲线分析订单信息
     */
    EcarHistoryOrdersVo getEcarHistoryOrdersInfo(String chargeRecordId);

}
