package com.ebike.openservices.chgmgmt.service.impl;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.chgmgmt.dao.EbikeChargeOrderDao;
import com.ebike.openservices.chgmgmt.entity.EbikeChargeOrderHisVo;
import com.ebike.openservices.chgmgmt.entity.EbikeChargeOrderVo;
import com.ebike.openservices.chgmgmt.service.EbikeChargeOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class EbikeChargeOrderServiceImpl implements EbikeChargeOrderService {
    private final EbikeChargeOrderDao ebikeChargeOrderDao;
    @Autowired
    public EbikeChargeOrderServiceImpl(EbikeChargeOrderDao ebikeChargeOrderDao) {
        this.ebikeChargeOrderDao = ebikeChargeOrderDao;
    }

    @Override
    public List<EbikeChargeOrderVo> getEbikeChargeOrderList(Map params, Sorter sorter, Pager pager) {
        return ebikeChargeOrderDao.getEbikeChargeOrderList(params, sorter, pager);
    }

    @Override
    public Integer getEbikeChargeOrderCount(Map params) {
        return ebikeChargeOrderDao.getEbikeChargeOrderCount(params);
    }

    @Override
    public List<EbikeChargeOrderHisVo> getEbikeChargeOrderHisList(Map params, Sorter sorter, Pager pager) {
        return ebikeChargeOrderDao.getEbikeChargeOrderHisList(params, sorter, pager);
    }

    @Override
    public Integer getEbikeChargeOrderHisCount(Map params) {
        return ebikeChargeOrderDao.getEbikeChargeOrderHisCount(params);
    }
}
