package com.ebike.openservices.chgmgmt.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.easesource.data.bean.Pager;
import com.ebike.openservices.chgmgmt.dao.EcarOrdersDao;
import com.ebike.openservices.chgmgmt.entity.EcarCurrentOrdersVo;
import com.ebike.openservices.chgmgmt.entity.EcarHistoryOrdersVo;
import com.ebike.openservices.chgmgmt.enums.*;
import com.ebike.openservices.chgmgmt.request.EcarCurrentOrdersRequestParam;
import com.ebike.openservices.chgmgmt.request.EcarHistoryOrdersRequestParam;
import com.ebike.openservices.chgmgmt.service.EcarOrdersService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @param
 * @ClassName EcarOrdersServiceImpl
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/13 19:04
 * @Version 1.0
 **/
@Service
public class EcarOrdersServiceImpl implements EcarOrdersService {

    private static final Logger LOGGER = LoggerFactory.getLogger(EcarOrdersServiceImpl.class);
    @Resource
    private EcarOrdersDao ecarOrdersDao;

    /**
     * 功能描述 当前订单信息查询
     *
     * @param param
     * @return java.util.List<com.ebike.openservices.chgmgmt.entity.EcarCurrentOrdersVo>
     * @author zhouyi
     * @data 2021/4/13
     */
    @Override
    public Map<String, Object> getEcarCurrentOrders(EcarCurrentOrdersRequestParam param) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("请求参数：{}", param);
        }
        Pager pager = new Pager();
        pager.setPageNumber(param.getCurrent());
        pager.setPageSize(10);
        //分页数据
        List<EcarCurrentOrdersVo> currentOrdersVos = ecarOrdersDao.getEcarCurrentOrdersData(param, pager);
        currentOrdersVos.stream().map(currentOrdersVo -> {
            currentOrdersVo.setChargingPileTypeStr(CharGingPileTypeEnum.getNameByValue(currentOrdersVo.getChargingPileType()))
                .setChargeStatusStr(ChargeStatusEnum.getNameByValue(currentOrdersVo.getChargeStatus()))
                .setCustomerTypeStr(CustomerTypeEnum.getNameByValue(currentOrdersVo.getCustomerType()))
                .setChargeModeStr(ChargeModeEnum.getNameByValue(currentOrdersVo.getChargeMode()))
                .setChargePayTypeStr(ChargePayTypeEnum.getNameByValue(currentOrdersVo.getChargePayType()));
            return currentOrdersVo;
        }).collect(Collectors.toList());
        //数据总量
        int total = ecarOrdersDao.getEcarCurrentOrdersTotalData(param);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("分页数据：{}", currentOrdersVos);
            LOGGER.debug("数据总量：{}", total);
        }
        Map<String, Object> map = new HashMap<>(2);
        map.put("currentOrdersVos", currentOrdersVos);
        map.put("total", total);
        return map;
    }

    /**
     * 功能描述 当前订单导出excle
     *
     * @param param
     * @return java.util.List<com.ebike.openservices.chgmgmt.entity.EcarCurrentOrdersVo>
     * @author zhouyi
     * @data 2021/4/14
     */
    @Override
    public List<EcarCurrentOrdersVo> exportEcarCurrentOrders(EcarCurrentOrdersRequestParam param) {
        Pager pager = new Pager();
        return ecarOrdersDao.getEcarCurrentOrdersData(param, pager);
    }

    /**
     * 功能描述  历史订单查询
     *
     * @param param
     * @return java.util.Map<java.lang.String, java.lang.Object>
     * @author zhouyi
     * @data 2021/4/14
     */
    @Override
    public Map<String, Object> getEcarHistoryOrders(EcarHistoryOrdersRequestParam param) {
        Pager pager = new Pager();
        pager.setPageNumber(param.getCurrent());
        pager.setPageSize(10);
        DateTime startTime2 = null;
        DateTime endTime2 = null;
        if (ObjectUtil.isNotEmpty(param.getStartTime2())) {
            startTime2 = DateUtil.endOfDay(DateUtil.parse(param.getStartTime2()));
        }
        if(ObjectUtil.isNotEmpty(param.getEndTime2())){
            endTime2 = DateUtil.endOfDay(DateUtil.parse(param.getEndTime2()));
        }
        param.setStartTime2(DateUtil.formatDateTime(startTime2));
        param.setEndTime2(DateUtil.formatDateTime(endTime2));
        //分页数据
        List<EcarHistoryOrdersVo> ecarHistoryOrdersVos = ecarOrdersDao.getEcarHistoryOrdersData(param, pager);
        ecarHistoryOrdersVos.forEach(item -> {
            if (Objects.equals(item.getPriceRateTypeNo(), 3)) {
                //自定义时间段
                List<String> timeList = Lists.newArrayList();
                // 计费参数
                JSONObject billingParamsJsonObject = JSONUtil.parseObj(item.getBillingParams());
                //电量详情
                JSONObject chargeEconsDetail = JSONUtil.parseObj(item.getChargeEconsDetail());
                //电费详情
                JSONObject chargeExpenseDetail = JSONUtil.parseObj(item.getChargeExpenseDetail());

                for (int i = 1; i <= 10; i++) {
                    String startIndex = String.format("%02d", i);
                    String endIndex = String.format("%02d", i + 1);
                    // 设置时间段
                    String startTime = billingParamsJsonObject.getStr("start_value_rate_period" + startIndex);
                    String endTime = billingParamsJsonObject.getStr("start_value_rate_period" + endIndex);
                    if (StringUtils.isNotBlank(endTime)) {
                        timeList.add(startTime + "-" + endTime);
                    } else {
                        timeList.add(startTime + "-23:59");
                        break;
                    }
                }
                //自定义时间段对应的电量值
                List<BigDecimal> chargeEconsRateList = Lists.newArrayList();
                for (int i = 0; i < timeList.size(); i++) {
                    chargeEconsRateList.add(BigDecimal.ZERO);
                }
                //自定义时间段对应的电费值
                List<BigDecimal> chargeExpenseRateList = Lists.newArrayList();
                for (int i = 0; i < timeList.size(); i++) {
                    chargeExpenseRateList.add(BigDecimal.ZERO);
                }
                for (int i = 0; i < timeList.size(); i++) {
                    BigDecimal econsValue = chargeEconsDetail.getBigDecimal("charge_econs_rate" + String.format("%02d", i + 1));
                    BigDecimal expenseValue = chargeExpenseDetail.getBigDecimal("charge_expense_rate" + String.format("%02d", i + 1));
                    chargeEconsRateList.set(i, NumberUtil.add(econsValue, chargeEconsRateList.get(i)));
                    chargeExpenseRateList.set(i, NumberUtil.add(expenseValue, chargeExpenseRateList.get(i)));
                }
                item.setTimeList(timeList);
                item.setEconsDetailList(chargeEconsRateList);
                item.setExpenseDetailList(chargeExpenseRateList);
            }
        });

        ecarHistoryOrdersVos.stream().map(ecarHistoryOrdersVo -> {
            ecarHistoryOrdersVo.setChargingPileTypeStr(CharGingPileTypeEnum.getNameByValue(ecarHistoryOrdersVo.getChargingPileType()))
                .setChargePayTypeStr(ChargePayTypeEnum.getNameByValue(ecarHistoryOrdersVo.getChargePayType()))
                .setCustomerTypeStr(CustomerTypeEnum.getNameByValue(ecarHistoryOrdersVo.getCustomerType()))
                .setChargeModeStr(ChargeModeEnum.getNameByValue(ecarHistoryOrdersVo.getChargeMode()));
            return ecarHistoryOrdersVo;
        }).collect(Collectors.toList());

        //数据总量
        int total = ecarOrdersDao.getEcarHistoryOrdersTotalData(param);
        Map<String, Object> map = new HashMap<>(2);
        map.put("currentOrdersVos", ecarHistoryOrdersVos);
        map.put("total", total);
        return map;
    }

    /**
     * 功能描述 历史订单导出
     *
     * @param param
     * @return java.util.List<com.ebike.openservices.chgmgmt.entity.EcarHistoryOrdersVo>
     * @author zhouyi
     * @data 2021/4/14
     */
    @Override
    public List<EcarHistoryOrdersVo> exportEcarHistoryOrders(EcarHistoryOrdersRequestParam param) {
        Pager pager = new Pager();
        DateTime startTime = null;
        DateTime endTime = null;
        if (StrUtil.isNotBlank(param.getStartTime2())) {
            startTime = DateUtil.endOfDay(DateUtil.parse(param.getStartTime2()));
        }
        if (StrUtil.isNotBlank(param.getEndTime2())) {
            endTime = DateUtil.endOfDay(DateUtil.parse(param.getEndTime2()));
        }
        param.setStartTime2(DateUtil.formatDateTime(startTime));
        param.setEndTime2(DateUtil.formatDateTime(endTime));
        return ecarOrdersDao.getEcarHistoryOrdersData(param, pager);
    }

    @Override
    public EcarHistoryOrdersVo getEcarHistoryOrdersInfo(String chargeRecordId) {
        return ecarOrdersDao.getEcarHistoryOrdersInfo(chargeRecordId);
    }
}
