/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.chgmgmt.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.easesource.data.bean.Pager;
import com.ebike.openservices.chgmgmt.dao.EcarOrdersDao;
import com.ebike.openservices.chgmgmt.entity.EcarCurrentOrdersVo;
import com.ebike.openservices.chgmgmt.entity.EcarHistoryOrdersVo;
import com.ebike.openservices.chgmgmt.enums.CharGingPileTypeEnum;
import com.ebike.openservices.chgmgmt.enums.ChargeModeEnum;
import com.ebike.openservices.chgmgmt.enums.ChargePayTypeEnum;
import com.ebike.openservices.chgmgmt.enums.ChargeStatusEnum;
import com.ebike.openservices.chgmgmt.enums.CustomerTypeEnum;
import com.ebike.openservices.chgmgmt.request.EcarCurrentOrdersRequestParam;
import com.ebike.openservices.chgmgmt.request.EcarHistoryOrdersRequestParam;
import com.ebike.openservices.chgmgmt.service.EcarOrdersService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EcarOrdersServiceImpl
implements EcarOrdersService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EcarOrdersServiceImpl.class);
    @Resource
    private EcarOrdersDao ecarOrdersDao;

    public Map<String, Object> getEcarCurrentOrders(EcarCurrentOrdersRequestParam param) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        }
        Pager pager = new Pager();
        pager.setPageNumber(param.getCurrent());
        pager.setPageSize(10);
        List<EcarCurrentOrdersVo> currentOrdersVos = this.ecarOrdersDao.getEcarCurrentOrdersData(param, pager);
        currentOrdersVos.stream().map(currentOrdersVo -> {
            currentOrdersVo.setChargingPileTypeStr(CharGingPileTypeEnum.getNameByValue((Integer)currentOrdersVo.getChargingPileType())).setChargeStatusStr(ChargeStatusEnum.getNameByValue((Integer)currentOrdersVo.getChargeStatus())).setCustomerTypeStr(CustomerTypeEnum.getNameByValue((Integer)currentOrdersVo.getCustomerType())).setChargeModeStr(ChargeModeEnum.getNameByValue((Integer)currentOrdersVo.getChargeMode())).setChargePayTypeStr(ChargePayTypeEnum.getNameByValue((Integer)currentOrdersVo.getChargePayType()));
            return currentOrdersVo;
        }).collect(Collectors.toList());
        int total = this.ecarOrdersDao.getEcarCurrentOrdersTotalData(param);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5206\u9875\u6570\u636e\uff1a{}", currentOrdersVos);
            LOGGER.debug("\u6570\u636e\u603b\u91cf\uff1a{}", (Object)total);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("currentOrdersVos", currentOrdersVos);
        map.put("total", total);
        return map;
    }

    public List<EcarCurrentOrdersVo> exportEcarCurrentOrders(EcarCurrentOrdersRequestParam param) {
        Pager pager = new Pager();
        return this.ecarOrdersDao.getEcarCurrentOrdersData(param, pager);
    }

    public Map<String, Object> getEcarHistoryOrders(EcarHistoryOrdersRequestParam param) {
        Pager pager = new Pager();
        pager.setPageNumber(param.getCurrent());
        pager.setPageSize(10);
        DateTime startTime2 = null;
        DateTime endTime2 = null;
        if (ObjectUtil.isNotEmpty((Object)param.getStartTime2())) {
            startTime2 = DateUtil.endOfDay((Date)DateUtil.parse((CharSequence)param.getStartTime2()));
        }
        if (ObjectUtil.isNotEmpty((Object)param.getEndTime2())) {
            endTime2 = DateUtil.endOfDay((Date)DateUtil.parse((CharSequence)param.getEndTime2()));
        }
        param.setStartTime2(DateUtil.formatDateTime((Date)startTime2));
        param.setEndTime2(DateUtil.formatDateTime((Date)endTime2));
        List<EcarHistoryOrdersVo> ecarHistoryOrdersVos = this.ecarOrdersDao.getEcarHistoryOrdersData(param, pager);
        ecarHistoryOrdersVos.forEach(item -> {
            if (Objects.equals(item.getPriceRateTypeNo(), 3)) {
                int i;
                ArrayList timeList = Lists.newArrayList();
                JSONObject billingParamsJsonObject = JSONUtil.parseObj((String)item.getBillingParams());
                JSONObject chargeEconsDetail = JSONUtil.parseObj((String)item.getChargeEconsDetail());
                JSONObject chargeExpenseDetail = JSONUtil.parseObj((String)item.getChargeExpenseDetail());
                for (int i2 = 1; i2 <= 10; ++i2) {
                    String startIndex = String.format("%02d", i2);
                    String endIndex = String.format("%02d", i2 + 1);
                    String startTime = billingParamsJsonObject.getStr((Object)("start_value_rate_period" + startIndex));
                    String endTime = billingParamsJsonObject.getStr((Object)("start_value_rate_period" + endIndex));
                    if (!StringUtils.isNotBlank((CharSequence)endTime)) {
                        timeList.add(startTime + "-23:59");
                        break;
                    }
                    timeList.add(startTime + "-" + endTime);
                }
                ArrayList chargeEconsRateList = Lists.newArrayList();
                for (int i3 = 0; i3 < timeList.size(); ++i3) {
                    chargeEconsRateList.add(BigDecimal.ZERO);
                }
                ArrayList chargeExpenseRateList = Lists.newArrayList();
                for (i = 0; i < timeList.size(); ++i) {
                    chargeExpenseRateList.add(BigDecimal.ZERO);
                }
                for (i = 0; i < timeList.size(); ++i) {
                    BigDecimal econsValue = chargeEconsDetail.getBigDecimal((Object)("charge_econs_rate" + String.format("%02d", i + 1)));
                    BigDecimal expenseValue = chargeExpenseDetail.getBigDecimal((Object)("charge_expense_rate" + String.format("%02d", i + 1)));
                    chargeEconsRateList.set(i, NumberUtil.add((Number)econsValue, (Number)((Number)chargeEconsRateList.get(i))));
                    chargeExpenseRateList.set(i, NumberUtil.add((Number)expenseValue, (Number)((Number)chargeExpenseRateList.get(i))));
                }
                item.setTimeList((List)timeList);
                item.setEconsDetailList((List)chargeEconsRateList);
                item.setExpenseDetailList((List)chargeExpenseRateList);
            }
        });
        ecarHistoryOrdersVos.stream().map(ecarHistoryOrdersVo -> {
            ecarHistoryOrdersVo.setChargingPileTypeStr(CharGingPileTypeEnum.getNameByValue((Integer)ecarHistoryOrdersVo.getChargingPileType())).setChargePayTypeStr(ChargePayTypeEnum.getNameByValue((Integer)ecarHistoryOrdersVo.getChargePayType())).setCustomerTypeStr(CustomerTypeEnum.getNameByValue((Integer)ecarHistoryOrdersVo.getCustomerType())).setChargeModeStr(ChargeModeEnum.getNameByValue((Integer)ecarHistoryOrdersVo.getChargeMode()));
            return ecarHistoryOrdersVo;
        }).collect(Collectors.toList());
        int total = this.ecarOrdersDao.getEcarHistoryOrdersTotalData(param);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("currentOrdersVos", ecarHistoryOrdersVos);
        map.put("total", total);
        return map;
    }

    public List<EcarHistoryOrdersVo> exportEcarHistoryOrders(EcarHistoryOrdersRequestParam param) {
        Pager pager = new Pager();
        DateTime startTime = null;
        DateTime endTime = null;
        if (StrUtil.isNotBlank((CharSequence)param.getStartTime2())) {
            startTime = DateUtil.endOfDay((Date)DateUtil.parse((CharSequence)param.getStartTime2()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getEndTime2())) {
            endTime = DateUtil.endOfDay((Date)DateUtil.parse((CharSequence)param.getEndTime2()));
        }
        param.setStartTime2(DateUtil.formatDateTime((Date)startTime));
        param.setEndTime2(DateUtil.formatDateTime((Date)endTime));
        return this.ecarOrdersDao.getEcarHistoryOrdersData(param, pager);
    }

    public EcarHistoryOrdersVo getEcarHistoryOrdersInfo(String chargeRecordId) {
        return this.ecarOrdersDao.getEcarHistoryOrdersInfo(chargeRecordId);
    }
}

