package com.ebike.openservices.cscmgmt.dao;


import com.ebike.openservices.cscmgmt.request.CustomerAddRequest;
import com.ebike.openservices.cscmgmt.request.CustomerHisAddRequest;
import com.ebike.openservices.cscmgmt.request.CustomerRequest;
import com.ebike.openservices.cscmgmt.request.DeviceQueryRequest;
import com.ebike.openservices.cscmgmt.response.BpCodeResponse;
import com.ebike.openservices.cscmgmt.response.CustomerQueryResponse;
import com.ebike.openservices.cscmgmt.response.DeviceQueryResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface CustomerWorkOrderDao {

    List<CustomerQueryResponse> queryCustomerList(CustomerRequest customerRequest);

    int queryCustomerListTotal(CustomerRequest customerRequest);

    List<DeviceQueryResponse> queryDeviceList(DeviceQueryRequest deviceQueryRequest);

    List<Integer> queryDeviceListTotal(DeviceQueryRequest deviceQueryRequest);

    int addCustomer(CustomerAddRequest customerAddRequest);

    String queryChargeUserIdByPhone(String phone);

    int updateCustomer(CustomerAddRequest customerAddRequest);

    int deleteCustomer(@Param("idList") List<String> idList);

    CustomerQueryResponse queryCustomerDetails(String csworkorderId);

    /**
     * 存档时修改
     * @return
     */
    int updateCustomerOnFile(CustomerHisAddRequest customerHisAddRequest);

    /**
     * 存档时新增历史客服工单
     */
    int addCustomerHis(CustomerHisAddRequest customerHisAddRequest);

    List<BpCodeResponse> queryCode(BpCodeResponse bpCodeResponse);
}
