package com.ebike.openservices.cscmgmt.serviceImpl;

import com.easesource.data.id.generator.IdGenerator;
import com.ebike.openservices.cscmgmt.constant.CarServiceConstant;
import com.ebike.openservices.cscmgmt.dao.CarDao;
import com.ebike.openservices.cscmgmt.service.CarCustomerService;
import com.ebike.openservices.cscmgmt.vo.CarExcelTemplate;
import com.ebike.openservices.cscmgmt.vo.CarServiceOrgVo;
import com.ebike.openservices.cscmgmt.vo.CustomerCarInfoVo;
import com.ebike.openservices.cscmgmt.vo.CustomerInfoVo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author liumu
 * @date 2021/4/13 16:53
 * 汽车充电桩-客户信息管理
 */
@Service
public class CarCustomerServiceImpl implements CarCustomerService {

    /**
     * id生成工具
     */
    @Resource(name = "idGenerator")
    protected IdGenerator idGenerator;

    @Resource
    private CarDao carDao;

    @Override
    public Map<Integer, String> getCustomerTypes() {
        return new HashMap<>(CarServiceConstant.CUSTOMER_TYPE);
    }

    @Override
    public List<CarServiceOrgVo> getOrgs() {
        return carDao.selectOrgs();
    }

    @Override
    public List<CustomerInfoVo> searchCustomer(String orgNo, String name, String phone, String type,String card, String vin, int current, int size) {
        current = (current - 1) * size;
        List<CustomerInfoVo> data = null;
        if(CarServiceConstant.ROOT_ORG_NO.equals(orgNo)){
            //检索所有运营商
            data = carDao.searchCustomerAll(name, phone, type,card, vin, current, size);
        }else{
            //检索当前运营商
            data = carDao.searchCustomer(orgNo,name, phone, type,card, vin, current, size);
        }
        if(data == null){
            return null;
        }
        //客户类型转义
        data.forEach(bean -> {
            bean.setCustomerTypeStr(CarServiceConstant.CUSTOMER_TYPE.get(bean.getCustomerType()));
            //查询是否有车辆
            List<CarExcelTemplate> cars = carDao.selectCars(orgNo,String.valueOf(bean.getId()));
            if(cars == null || cars.size() ==0){
                //添加是否绑定车辆的标识
                bean.setExistCar(0);
            }else{
                bean.setExistCar(1);
            }
        });
        return data;
    }

    @Override
    public void addCustomer(CustomerInfoVo bean) {
        carDao.insertCustomer(bean);
    }

    @Override
    public String queryCustomerById(String orgNo, String id) {
        return carDao.selectCustomerById(orgNo, id);
    }

    @Override
    public String queryCustomerByCustomerNo(String orgNo, String customerNo) {
        return carDao.selectCustomerByCustomerNo(orgNo, customerNo);
    }

    @Override
    public String queryCurrentOrderByCustomerId(String orgNo, String customerId) {
        return carDao.selectCurrentOrderByCustomerId(orgNo, customerId);
    }

    @Override
    public String queryHistoryOrderByCustomerId(String orgNo, String customerId) {
        return carDao.selectHistoryOrderByCustomerId(orgNo, customerId);
    }

    @Override
    public void logicalDeleteCustomerById(String orgNo, String userNo,String id) {
        carDao.logicalDeleteCustomerById(orgNo, userNo,id);
    }

    @Override
    public void delCustomerByOrgno(String orgNo) {
        carDao.delCustomerByOrgno(orgNo);
    }

    @Override
    public void updateCustomerById(String orgNo, String id, String name, String account, String phone, String type) {
        carDao.updateCustomerById(orgNo, id, name, account, phone, type);
    }

    @Override
    public Map<String, Object> searchCar(String orgNo, String customerId, String card, String vin, int current, int size) {
        current = (current - 1) * size;
        Map<String, Object> result = new HashMap<>(2);
        //平台级用户查询所有
        if(CarServiceConstant.ROOT_ORG_NO.equals(orgNo)){
            orgNo = null;
        }
        //为方便前端，每次翻页均查询总数（不合理）
        int total = carDao.carCount(orgNo, customerId, card, vin);
        result.put("total", total);
        List<CustomerCarInfoVo> data = carDao.searchCar(orgNo, customerId, card, vin, current, size);
        result.put("record", data);
        return result;


    }

    @Override
    public void addCar(CustomerCarInfoVo car) {
        carDao.insertCar(car);
    }

    @Override
    public String queryCarByCustomerId(String orgNo, String customerId) {
        return carDao.selectCarByCustomerId(orgNo, customerId);
    }

    @Override
    public List<CarExcelTemplate> queryCars(String orgNo, String customerId) {
        return carDao.selectCars(orgNo, customerId);
    }

    @Override
    public int queryCarCount(String orgNo, String customerId, String card, String vin) {
        return carDao.carCount(orgNo, customerId, card, vin);
    }

//    @Override
//    public void updateCarByCustomerId(String orgNo, String customerId, String card, String vin) {
//        carDao.updateCarByCustomerId(orgNo,customerId,card,vin);
//    }

    @Override
    public void updateCarById(String orgNo, String id, String card, String vin) {
        carDao.updateCarById(orgNo, id, card, vin);
    }

    @Override
    public void delCarByCustomerId(String orgNo, String customerId) {
        carDao.delCarByCustomerId(orgNo, customerId);
    }

    @Override
    public void delCarById(String orgNo, String id) {
        carDao.delCarById(orgNo,id);
    }

    @Override
    public int customerCountAll(String name, String phone, String type, String card, String vin) {
        return carDao.customerCountAll(name, phone, type, card, vin);
    }

    @Override
    public int customerCount(String orgNo, String name, String phone, String type, String card, String vin) {
        return carDao.customerCount(orgNo, name, phone, type, card, vin);
    }
}
