package com.ebike.openservices.cscmgmt.serviceImpl;


import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.easesource.data.id.generator.IdGenerator;
import com.ebike.openservices.cscmgmt.dao.ClientSessionDao;
import com.ebike.openservices.cscmgmt.request.*;
import com.ebike.openservices.cscmgmt.response.ClientCountDayResponse;
import com.ebike.openservices.cscmgmt.response.ClientCountMonthAndYearResponse;
import com.ebike.openservices.cscmgmt.response.ClientMessaagesRecordsResponse;
import com.ebike.openservices.cscmgmt.response.ClientRoleResponse;
import com.ebike.openservices.cscmgmt.service.ClientSessionServices;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
/**
 * @ClassName ClientSessionServicesImpl
 * @Description TODO
 * @Author zhouby
 * @Data 2021/1/6 15:03
 * @Version 1.0
 **/
@Service
public class ClientSessionServicesImpl implements ClientSessionServices {
    @Resource(name = "idGenerator")
    protected IdGenerator idGenerator;
    @Autowired
    private ClientSessionDao clientSessionDao;

    //get请求
    public JSONObject getHttpMethod(String recordUrl) {
        JSONObject jsonObject = null;
        try {
            URL resultUrl = new URL(recordUrl);
            //得到connection连接对象
            HttpURLConnection urlConnection = (HttpURLConnection) resultUrl.openConnection();
            //设置请求的方式
            urlConnection.setRequestMethod("GET");
            //连接
            urlConnection.connect();
            //得到响应码
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == HttpURLConnection.HTTP_OK) {
                //得到响应流
                InputStream inputStream = urlConnection.getInputStream();
                //获取响应的数据
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder content = new StringBuilder();
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    content.append(line);
                }
                jsonObject = (JSONObject) JSON.parse(content.toString());
                System.out.println(jsonObject.get("kf_list"));
//                //客服列表 List<ClientRoleRequest> 不存数据库 数据太少 没必要 非要存再存
//                if (jsonObject.get("kf_list")!=null){
//                    List<ClientRoleRequest> roleList = (List<ClientRoleRequest>) JSONArray.parseArray(jsonObject.get("kf_list").toString(), ClientRoleRequest.class);
//                      roleList.forEach(item->{
//                      });
//                       int i = clientSessionDao.insertRoleList(roleList);
//                    System.out.println(roleList);
//                }
                bufferedReader.close();
                //断开连接
                urlConnection.disconnect();
                return jsonObject;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int daysBetween2(String startTime, String endTime) throws ParseException {
        //时间处理
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long startLongTimeStamp = new Long(new Long(Integer.valueOf(startTime)) * 1000);
        long endLongTimeStamp = new Long(new Long(Integer.valueOf(endTime)) * 1000);
        Date startData = new Date(startLongTimeStamp);
        Date endData = new Date(endLongTimeStamp);
        String startDataStr = simpleDateFormat.format(startData);
        String endDataStr = simpleDateFormat.format(endData);
        DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        //获取参数毫秒数
        long l1 = sdf.parse(startDataStr).getTime();
        //获取末尾时间的long
        long l2 = sdf.parse(endDataStr).getTime();
        //两者相减，获得时间差的毫秒数
        long mills = l2 - l1;
//        System.out.println(mills);//如果这里的值不为零 证明时间差计算成功
        //将时间差的毫秒数转化成整个的小时数
        int requiredHours = (int) (mills / 1000 / 3600);
        //将所需时间返回
        return requiredHours;
    }


    public static int secondsBetween2(String startTime, String endTime) throws ParseException {
        //时间处理
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long startLongTimeStamp = new Long(new Long(Integer.valueOf(startTime)) * 1000);
        long endLongTimeStamp = new Long(new Long(Integer.valueOf(endTime)) * 1000);
        Date startData = new Date(startLongTimeStamp);
        Date endData = new Date(endLongTimeStamp);
        String startDataStr = simpleDateFormat.format(startData);
        String endDataStr = simpleDateFormat.format(endData);
        DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        //获取参数毫秒数
        long l1 = sdf.parse(startDataStr).getTime();
        //获取末尾时间的long
        long l2 = sdf.parse(endDataStr).getTime();
        //两者相减，获得时间差的毫秒数
        long mills = l2 - l1;
//        System.out.println(mills);//如果这里的值不为零 证明时间差计算成功
        //将时间差的毫秒数转化成整个的小时数
        int requiredHours = (int) (mills / 1000);
        //将所需时间返回
        return requiredHours;
    }

    @Override
    public JSONObject countSessionDay(String url, Long starttime, Long endtime, String userNo) {
        //这个只用来做重新计算的接口------------------（防止漏算）
        String jsonParam = "   {\n" +
            "      \"starttime\" : " + starttime.toString()+","+
            "      \"endtime\" : " +endtime.toString()+","+
            "      \"msgid\" : \"1\",\n" +
            "      \"number\" : \"10000\" \n" +
            "} ";
//        String jsonParam = "   {\n" +
//            "      \"starttime\" : \"1609862400\",\n" +
//            "      \"endtime\" : \"1609948799\",\n" +
//            "      \"msgid\" : \"1\",\n" +
//            "      \"number\" : \"10000\" \n" +
//            "} ";
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        CloseableHttpResponse closeableHttpResponse;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
            StringEntity entity = new StringEntity(jsonParam, ContentType.create("text/json", "UTF-8"));
            httpPost.setEntity(entity);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectTimeout(2000).build();
            httpPost.setConfig(requestConfig);

            closeableHttpResponse = closeableHttpClient.execute(httpPost);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            String asset_synchronization = EntityUtils.toString(httpEntity, "UTF-8");
            cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(asset_synchronization);
            List<ClientSessionRequest> requestsList = (List<ClientSessionRequest>) JSONArray.parseArray(jsonObject.get("recordlist").toString(), ClientSessionRequest.class);
            if (requestsList.isEmpty()) {
                return null;
            }
            Map<String, List<ClientSessionRequest>> map = new HashMap<>();
            for (ClientSessionRequest clientSessionRequest : requestsList) {
                String key = clientSessionRequest.getOpenid();
                if (map.containsKey(key)) {
                    //map中存在以此id作为的key，将数据存放当前key的map中
                    map.get(key).add(clientSessionRequest);
                } else {
                    //map中不存在以此id作为的key，新建key用来存放数据
                    List<ClientSessionRequest> clientSessionList = new ArrayList<>();
                    clientSessionList.add(clientSessionRequest);
                    map.put(key, clientSessionList);
                }
            }
            //分组后的数据
            System.out.println(map);
            //统计服务----------------------------------------------------------Cli entCountDayRequest

            List<ClientSessionRequest> countrequestsList = (List<ClientSessionRequest>) JSONArray.parseArray(jsonObject.get("recordlist").toString(), ClientSessionRequest.class);
            if (requestsList.isEmpty()) {
                return null;
            }
            Map<String, List<ClientSessionRequest>> countmap = new HashMap<>();
            for (ClientSessionRequest countclientSessionRequest : countrequestsList) {
                String key = countclientSessionRequest.getOpenid();
                if (countmap.containsKey(key)) {
                    //map中存在以此id作为的key，将数据存放当前key的map中
                    countmap.get(key).add(countclientSessionRequest);
                } else {
                    //map中不存在以此id作为的key，新建key用来存放数据
                    List<ClientSessionRequest> clientSessionList = new ArrayList<>();
                    clientSessionList.add(countclientSessionRequest);
                    countmap.put(key, clientSessionList);
                }
            }
            //分组后的数据
            System.out.println(countmap);
            List<ClientCountDayRequest> countNumDay = new ArrayList<>();
            //先找出今天的总客服数
//            List<ClientSessionRequest> dislodgeList = countrequestsList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getWorker()))), ArrayList::new));
//            dislodgeList.forEach(itemRole -> {
//                ClientCountDayRequest clientCountDayRequest = new ClientCountDayRequest();
//                String worker = itemRole.getWorker();
//                clientCountDayRequest.setKfAccount(worker);
//                clientCountDayRequest.setCountSession(0);
//                clientCountDayRequest.setAverageTime("0");
//                clientCountDayRequest.setRecentlySessionTime("0000-00-00 00:00:00");
//                countNumDay.add(clientCountDayRequest);
//            });
            //计算当前统计时间
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long startLongTimeStamp = new Long(starttime * 1000);
            Date startData = new Date(startLongTimeStamp);
            String startDataStrs = simpleDateFormat.format(startData);
            String substring1 = startDataStrs.substring(0, 10);

//            找出所有的客服数量
            List<ClientRoleResponse> dislodgeList =clientSessionDao.queryClientRole();
            //找出每个客服的最后接待时间
            List<ClientMessaagesRecordsResponse> clientRecordsResponses =  clientSessionDao.queryMaxTime(dislodgeList);
            dislodgeList.forEach(itemRole -> {
                clientRecordsResponses.forEach(itemRoleRes->{
                    if (itemRoleRes.getKfAccount().equals(itemRole.getKfAccount())) {
                        if (itemRoleRes.getMAXIMUM()==null){
                            itemRoleRes.setMAXIMUM("0000-00-00 00:00:00");
                        }
                        //把时间戳转成时间
                        String maximum = itemRoleRes.getMAXIMUM();
                        long maxLong = new Long(new Long(Integer.valueOf(maximum)) * 1000);
                        Date maxLongData = new Date(maxLong);
                        String startDataStr = simpleDateFormat.format(maxLongData);
                        DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        ClientCountDayRequest clientCountDayRequest = new ClientCountDayRequest();
                        String worker = itemRole.getKfAccount();
                        clientCountDayRequest.setKfAccount(worker);
                        clientCountDayRequest.setId(idGenerator.nextId() + "");
                        clientCountDayRequest.setCreateTime(DateUtil.now());
                        clientCountDayRequest.setStatDay(substring1);
                        clientCountDayRequest.setCountSession(0);
                        clientCountDayRequest.setAverageTime("0");
                        clientCountDayRequest.setRecentlySessionTime(null);
                        countNumDay.add(clientCountDayRequest);
                    }
                });
            });

            //计算每个客服的接待数量
            Iterator<Map.Entry<String, List<ClientSessionRequest>>> mapenties = countmap.entrySet().iterator();
            while (mapenties.hasNext()) {
                Map.Entry<String, List<ClientSessionRequest>> entry = mapenties.next();
                String key = entry.getKey();
                List<ClientSessionRequest> value = entry.getValue();
                //将每个openid里面的list按照code分组分为接收和发送 2002  2003
                Map<String, List<ClientSessionRequest>> findMessageByCode = new HashMap<>();
                for (ClientSessionRequest codeKeyRequest : value) {
                    String codeKey = codeKeyRequest.getOpercode();
                    if (findMessageByCode.containsKey(codeKey)) {
                        //map中存在以此id作为的key，将数据存放当前key的map中
                        findMessageByCode.get(codeKey).add(codeKeyRequest);
                    } else {
                        //map中不存在以此id作为的key，新建key用来存放数据
                        List<ClientSessionRequest> clientSessionList = new ArrayList<>();
                        clientSessionList.add(codeKeyRequest);
                        findMessageByCode.put(codeKey, clientSessionList);
                    }
                }
                //分组后的数据
                System.out.println(findMessageByCode);
                List<ClientSessionRequest> me = new ArrayList<>();
                List<ClientSessionRequest> customer = new ArrayList<>();
                //客服回答的信息列表
                if (findMessageByCode.get("2002") != null) {
                    me = findMessageByCode.get("2002");
                }
                ;
                //用户咨询的列表
                if (findMessageByCode.get("2003") != null) {
                    customer = findMessageByCode.get("2003");
                }
                ;

                //计算平均接待时间
                if (me.size() == 0 || customer.size() == 0) {
                    //如果我方没回答客户则不统计
                } else {
                    String time = me.get(0).getTime(); // 我方回答时间
                    String time1 = customer.get(0).getTime();//用户咨询时间
                    int i = secondsBetween2(time1, time);//秒数
                    String seconds = String.valueOf(i);
                    //计算最后接待时间
                    Long time2 = Long.parseLong(me.get(0).getTime());
                    String time2Result1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(time2 * 1000));
                    Date time2Date1 = new Date(time2 * 1000);   //对应的就是时间戳对应的Date
                    String time2DateTime = DateUtil.formatDateTime(time2Date1);
                    //计算客服接待数量
                    List<ClientSessionRequest> dislodgeListByWorker = value.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getWorker()))), ArrayList::new));
                    //记录时间
                    String now = DateUtil.now();
                    //统计日期
                    Date date = DateUtil.parse(time2DateTime, "yyyy-MM-dd");
                    String formatDate = DateUtil.formatDateTime(date);
                    ClientCountDayRequest searchStatDay = new ClientCountDayRequest();
                    String substring = formatDate.substring(0, 10);
                    searchStatDay.setStatDay(substring);
                    List<ClientCountDayResponse> chouseCountList = clientSessionDao.selectByFormatDate(searchStatDay);
                    if (chouseCountList.isEmpty()) {
                    } else if (!chouseCountList.isEmpty()) {
                        int delete = clientSessionDao.deleteByStatDay(searchStatDay);
                    }
//                    String today= DateUtil.today();
//                    Date date = DateUtil.parse(today);
//                    Date newDate = DateUtil.offset(date, DateField.DAY_OF_MONTH, -1);
//                    String formatDate = DateUtil.formatDate(newDate);
//
//                    System.out.println(now);
//                    System.out.println(formatDate);
                    dislodgeListByWorker.forEach(sessionValue -> {
                        countNumDay.forEach(count -> {
                            String worker = sessionValue.getWorker();
                            String kfAccount = count.getKfAccount();
                            int iflag = worker.indexOf(kfAccount);
                            if (iflag == -1) {
                            } else {
                                count.setId(idGenerator.nextId() + "");
                                count.setStatDay(substring);
                                count.setCreateTime(now);
                                int countSession = count.getCountSession();
                                count.setAverageTime(seconds);
                                count.setRecentlySessionTime(time2DateTime);
                                count.setCountSession(countSession + 1);
                            }
                        });
                    });
                }
            }
            System.out.println(countNumDay);
            int countClient = clientSessionDao.statisticsClient(countNumDay);
            return null;
        }
        catch (Exception e){
            throw new RuntimeException(e);
        }
            //统计服务----------------------------------------------------------ClientCountDayRequest
    }
    @Override
    public JSONObject setRecordsMessages(String url, Long starttime, Long endtime, String userNo) {
        String jsonParam = "   {\n" +
            "      \"starttime\" : " + starttime.toString()+","+
            "      \"endtime\" : " +endtime.toString()+","+
            "      \"msgid\" : \"1\",\n" +
            "      \"number\" : \"10000\" \n" +
            "} ";
//        String jsonParam = "   {\n" +
//            "      \"starttime\" : \"1609862400\",\n" +
//            "      \"endtime\" : \"1609948799\",\n" +
//            "      \"msgid\" : \"1\",\n" +
//            "      \"number\" : \"10000\" \n" +
//            "} ";
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        CloseableHttpResponse closeableHttpResponse;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
            StringEntity entity = new StringEntity(jsonParam, ContentType.create("text/json", "UTF-8"));
            httpPost.setEntity(entity);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectTimeout(2000).build();
            httpPost.setConfig(requestConfig);

            closeableHttpResponse = closeableHttpClient.execute(httpPost);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            String asset_synchronization = EntityUtils.toString(httpEntity, "UTF-8");
            cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(asset_synchronization);
            List<ClientSessionRequest> requestsList = (List<ClientSessionRequest>) JSONArray.parseArray(jsonObject.get("recordlist").toString(), ClientSessionRequest.class);
            if (requestsList.isEmpty()) {
                return null;
            }
            Map<String, List<ClientSessionRequest>> map = new HashMap<>();
            for (ClientSessionRequest clientSessionRequest : requestsList) {
                String key = clientSessionRequest.getOpenid();
                if (map.containsKey(key)) {
                    //map中存在以此id作为的key，将数据存放当前key的map中
                    map.get(key).add(clientSessionRequest);
                } else {
                    //map中不存在以此id作为的key，新建key用来存放数据
                    List<ClientSessionRequest> clientSessionList = new ArrayList<>();
                    clientSessionList.add(clientSessionRequest);
                    map.put(key, clientSessionList);
                }
            }
            //分组后的数据
                System.out.println(map);
            //统计服务----------------------------------------------------------ClientCountDayRequest

            List<ClientSessionRequest> countrequestsList = (List<ClientSessionRequest>) JSONArray.parseArray(jsonObject.get("recordlist").toString(), ClientSessionRequest.class);
            if (requestsList.isEmpty()) {
                return null;
            }
            Map<String, List<ClientSessionRequest>> countmap = new HashMap<>();
            for (ClientSessionRequest countclientSessionRequest : countrequestsList) {
                String key = countclientSessionRequest.getOpenid();
                if (countmap.containsKey(key)) {
                    //map中存在以此id作为的key，将数据存放当前key的map中
                    countmap.get(key).add(countclientSessionRequest);
                } else {
                    //map中不存在以此id作为的key，新建key用来存放数据
                    List<ClientSessionRequest> clientSessionList = new ArrayList<>();
                    clientSessionList.add(countclientSessionRequest);
                    countmap.put(key, clientSessionList);
                }
            }
            //分组后的数据
            System.out.println(countmap);

//            List<ClientCountDayRequest> countNumDay = new ArrayList<>();
//            //先找出今天的总客服数
//List<ClientSessionRequest> dislodgeList = countrequestsList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o ->  o.getWorker()))), ArrayList::new));
//            dislodgeList.forEach(itemRole->{
//                ClientCountDayRequest clientCountDayRequest = new ClientCountDayRequest();
//                String worker = itemRole.getWorker();
//                clientCountDayRequest.setKfAccount(worker);
//                clientCountDayRequest.setCountSession(0);
//                clientCountDayRequest.setAverageTime("0");
//                clientCountDayRequest.setRecentlySessionTime("0000-00-00 00:00:00");
//                countNumDay.add(clientCountDayRequest);
//            });
            List<ClientCountDayRequest> countNumDay = new ArrayList<>();
            //计算当前统计时间
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long startLongTimeStamp = new Long(starttime * 1000);
            Date startData = new Date(startLongTimeStamp);
            String startDataStrs = simpleDateFormat.format(startData);
            String substring1 = startDataStrs.substring(0, 10);
//               找出所有的客服数量初始化
            List<ClientRoleResponse> dislodgeList =clientSessionDao.queryClientRole();
            //找出每个客服的最后接待时间
//            List<ClientMessaagesRecordsResponse> clientRecordsResponses =  clientSessionDao.queryMaxTime(dislodgeList);
            dislodgeList.forEach(itemRole -> {
//                clientRecordsResponses.forEach(itemRoleRes->{
//                    if (itemRoleRes.getKfAccount().equals(itemRole.getKfAccount())) {
//                        if (itemRoleRes.getMAXIMUM()!=null){
//
//                        }
                        //把时间戳转成时间
//                        String maximum = itemRoleRes.getMAXIMUM();
//                        long maxLong = new Long(new Long(Integer.valueOf(maximum)) * 1000);
//                        Date maxLongData = new Date(maxLong);
//                        String startDataStr = simpleDateFormat.format(maxLongData);
//                        DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        ClientCountDayRequest clientCountDayRequest = new ClientCountDayRequest();
                        String worker = itemRole.getKfAccount();
                        clientCountDayRequest.setKfAccount(worker);
                        clientCountDayRequest.setId(idGenerator.nextId() + "");
                        clientCountDayRequest.setCreateTime(DateUtil.now());
                        clientCountDayRequest.setStatDay(substring1);
                        clientCountDayRequest.setCountSession(0);
                        clientCountDayRequest.setAverageTime("0");
                        clientCountDayRequest.setRecentlySessionTime(null);
                        countNumDay.add(clientCountDayRequest);
//                    }
//                });
            });
            //计算每个客服的接待数量
            Iterator<Map.Entry<String, List<ClientSessionRequest>>> mapenties = countmap.entrySet().iterator();
            while (mapenties.hasNext()) {
                Map.Entry<String, List<ClientSessionRequest>> entry = mapenties.next();
                String key = entry.getKey();
                List<ClientSessionRequest> value = entry.getValue();
                //将每个openid里面的list按照code分组分为接收和发送 2002  2003
                Map<String, List<ClientSessionRequest>> findMessageByCode = new HashMap<>();
                for (ClientSessionRequest codeKeyRequest : value) {
                    String codeKey = codeKeyRequest.getOpercode();
                    if (findMessageByCode.containsKey(codeKey)) {
                        //map中存在以此id作为的key，将数据存放当前key的map中
                        findMessageByCode.get(codeKey).add(codeKeyRequest);
                    } else {
                        //map中不存在以此id作为的key，新建key用来存放数据
                        List<ClientSessionRequest> clientSessionList = new ArrayList<>();
                        clientSessionList.add(codeKeyRequest);
                        findMessageByCode.put(codeKey, clientSessionList);
                    }
                }
                //分组后的数据
                System.out.println(findMessageByCode);
                List<ClientSessionRequest> me = new ArrayList<>();
                List<ClientSessionRequest> customer = new ArrayList<>();
                //客服回答的信息列表
               if (findMessageByCode.get("2002")!=null){
                    me = findMessageByCode.get("2002");
                };
                //用户咨询的列表
                if (findMessageByCode.get("2003")!=null){
                    customer = findMessageByCode.get("2003");
                };

                //计算平均接待时间
                if (me.size()==0||customer.size()==0){
                    //如果我方没回答客户则不统计
                }else {
                    String time = me.get(0).getTime(); // 我方回答时间
                    String time1 = customer.get(0).getTime();//用户咨询时间
                    int i = secondsBetween2(time1, time);//秒数
                    String seconds = String.valueOf(i);
                //计算最后接待时间
                Long time2 = Long.parseLong(me.get(0).getTime());
                    String time2Result1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(time2 * 1000));
                    Date time2Date1 = new Date(time2*1000);   //对应的就是时间戳对应的Date
                    String time2DateTime = DateUtil.formatDateTime(time2Date1);

                //计算客服接待数量
                List<ClientSessionRequest> dislodgeListByWorker = value.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o ->  o.getWorker()))), ArrayList::new));
                //记录时间
                String now = DateUtil.now();
                //统计日期
                    Date date = DateUtil.parse(time2DateTime, "yyyy-MM-dd");
                    String formatDate = DateUtil.formatDateTime(date);
                    ClientCountDayRequest searchStatDay = new ClientCountDayRequest();
                    String substring = formatDate.substring(0, 10);
                    searchStatDay.setStatDay(substring);
                    List<ClientCountDayResponse> chouseCountList= clientSessionDao.selectByFormatDate(searchStatDay);
                    if (chouseCountList.isEmpty()){
                    }else if (!chouseCountList.isEmpty()){
                        int delete = clientSessionDao.deleteByStatDay(searchStatDay);
                    }
//                    String today= DateUtil.today();
//                    Date date = DateUtil.parse(today);
//                    Date newDate = DateUtil.offset(date, DateField.DAY_OF_MONTH, -1);
//                    String formatDate = DateUtil.formatDate(newDate);
//
//                    System.out.println(now);
//                    System.out.println(formatDate);
                dislodgeListByWorker.forEach(sessionValue -> {
                    countNumDay.forEach(count->{
                        String worker = sessionValue.getWorker();
                        String kfAccount = count.getKfAccount();
                        int iflag = worker.indexOf(kfAccount);
                        if (iflag == -1){}else {
                            count.setId(idGenerator.nextId() + "");
                            count.setStatDay(substring);
                            count.setCreateTime(now);
                            int countSession = count.getCountSession();
                            count.setAverageTime(seconds);
                            count.setRecentlySessionTime(time2DateTime);
                            count.setCountSession(countSession+1);
                        }
                    });
                });
            }
            }


            System.out.println(countNumDay);

            int countClient = clientSessionDao.statisticsClient(countNumDay);

            //统计服务----------------------------------------------------------ClientCountDayRequest


            //统计服务----------------------------------------------------------月
            String today= DateUtil.today();
            String format = today.substring(0,7);
            ClientCountMonthAndYearRequest clientCountMonthAndYearRequest = new ClientCountMonthAndYearRequest();
            clientCountMonthAndYearRequest.setMonth(format);
            List<ClientCountDayResponse> clientCountDayResponses = clientSessionDao.selectByMonth(clientCountMonthAndYearRequest);
            if (!clientCountDayResponses.isEmpty()){
                List<ClientCountMonthAndYearRequest> saveMonthList = new ArrayList<>();
                //对返回的数据进行处理
                clientCountDayResponses.forEach(rechangeMonth->{
                    String sumaverageday = rechangeMonth.getSumaverageday();
                    String num = rechangeMonth.getNum();
                    String  monthAverageTimeString = "0";
                    if (!sumaverageday.equals("0") && !num.equals("0")){
                        double v1 = Double.parseDouble(sumaverageday);
                        double v2 = Double.parseDouble(num);
                       double v3 = v1/v2;
                        int i = new Double(v3).intValue();
                        monthAverageTimeString = String.valueOf(i);
                    }
                    ClientCountMonthAndYearRequest saveMonth = new ClientCountMonthAndYearRequest();
                    Date date = DateUtil.date();
                    String formatDateTime = DateUtil.formatDateTime(date);
                    saveMonth.setId(idGenerator.nextId()+"");
                    saveMonth.setKfAccount(rechangeMonth.getKfAccount());
                    saveMonth.setCountSession(num);
                    saveMonth.setAverageTime(monthAverageTimeString);
                    saveMonth.setRecentlySessionTime(rechangeMonth.getMaxReTime());
                    saveMonth.setStatMonth(clientCountMonthAndYearRequest.getMonth());
                    saveMonth.setCreateTime(formatDateTime);
                    saveMonthList.add(saveMonth);
                });
                try{
                    List<ClientCountMonthAndYearResponse>  clientCountMonthAndYearResponse = clientSessionDao.selectByMonthTime(saveMonthList);
                    if (clientCountMonthAndYearResponse.isEmpty()){
                        int i = clientSessionDao.insertCountMonth(saveMonthList);
                    }
                    if (!clientCountMonthAndYearResponse.isEmpty()){
                        int i = clientSessionDao.deleteByMonth(saveMonthList);
                        int a = clientSessionDao.insertCountMonth(saveMonthList);
                    }
                }catch (Exception e){
                    throw  new RuntimeException(e);
                }
            }
            //统计服务----------------------------------------------------------月
            //统计服务----------------------------------------------------------年
            String todayyear= DateUtil.today();
            String formatyear = todayyear.substring(0,4);
            ClientCountMonthAndYearRequest clientCountMonthAndYearRequestYear = new ClientCountMonthAndYearRequest();
            clientCountMonthAndYearRequestYear.setYear(formatyear);
            List<ClientCountMonthAndYearResponse> clientCountYearResponses = clientSessionDao.selectByYear(clientCountMonthAndYearRequestYear);
            if (!clientCountYearResponses.isEmpty()) {
                List<ClientCountMonthAndYearRequest> saveYearList = new ArrayList<>();
                //对返回的数据进行处理
                clientCountYearResponses.forEach(rechangeMonth -> {
                    String sumaverageday = rechangeMonth.getSumaverageday();
                    String num = rechangeMonth.getNum();
                    String  monthAverageTimeString = "0";
                    if (!sumaverageday.equals("0") && !num.equals("0")){
                        double v1 = Double.parseDouble(sumaverageday);
                        double v2 = Double.parseDouble(num);
                        double v3 = v1/v2;
                        int i = new Double(v3).intValue();
                        monthAverageTimeString = String.valueOf(i);
                    }
                    ClientCountMonthAndYearRequest saveYear = new ClientCountMonthAndYearRequest();
                    Date dateNow = DateUtil.date();
                    String formatDateTime = DateUtil.formatDateTime(dateNow);
                    saveYear.setId(idGenerator.nextId() + "");
                    saveYear.setKfAccount(rechangeMonth.getKfAccount());
                    saveYear.setCountSession(rechangeMonth.getNum());
                    saveYear.setAverageTime(monthAverageTimeString);
                    saveYear.setRecentlySessionTime(rechangeMonth.getMaxReTime());
                    saveYear.setYear(clientCountMonthAndYearRequestYear.getYear());
                    saveYear.setCreateTime(formatDateTime);
                    saveYearList.add(saveYear);
                });
                try {
                    List<ClientCountMonthAndYearResponse> clientCountMonthAndYearResponse = clientSessionDao.selectByYearTime(saveYearList);
                    if (clientCountMonthAndYearResponse.isEmpty()) {
                        int i = clientSessionDao.insertCountYear(saveYearList);
                    }
                    if (!clientCountMonthAndYearResponse.isEmpty()) {
                        int i = clientSessionDao.deleteByYear(saveYearList);
                        int b = clientSessionDao.insertCountYear(saveYearList);
                    }
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            //统计服务----------------------------------------------------------年
            String dateStr = DateUtil.now();
//            Date date = DateUtil.parse(dateStr);
            DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//            String beginStr=df.format(date);
            Long dataTimeByFk = df.parse(dateStr).getTime() / 1000;
            //去重获得openid的数量，这里是为了用于查询
            List<ClientSessionRequest> finallClientNumResult = requestsList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getOpenid()))), ArrayList::new));
            List<ClientSessionRequest> result = clientSessionDao.selectByOpenid(finallClientNumResult);
            if (result.isEmpty()){
                //创建全新会话
                List<ClientMessaagesRecordsRequest> clientMessagesList = new ArrayList<>();
                //用迭代器遍历分组数据
                Iterator<Map.Entry<String, List<ClientSessionRequest>>> entries = map.entrySet().iterator();
                while (entries.hasNext()) {
                    String sessionId = idGenerator.nextId() + "";
                    Map.Entry<String, List<ClientSessionRequest>> entry = entries.next();
                    String key = entry.getKey();
                    List<ClientSessionRequest> value = entry.getValue();
                    //对每一个分组数据是一个会话 处理每个会话存入的聊天记录
                    value.forEach(sessionValue -> {
                        ClientMessaagesRecordsRequest clientMessaagesRecordsRequest = new ClientMessaagesRecordsRequest();
                        clientMessaagesRecordsRequest.setSessionId(sessionId);
                        clientMessaagesRecordsRequest.setCreator(userNo);
                        clientMessaagesRecordsRequest.setGmtCreate(dataTimeByFk);
                        //每个id都是独立的
                        clientMessaagesRecordsRequest.setId(idGenerator.nextId() + "");
                        clientMessaagesRecordsRequest.setKfAccount(sessionValue.getWorker());
                        clientMessaagesRecordsRequest.setOpercode(sessionValue.getOpercode());
                        clientMessaagesRecordsRequest.setText(sessionValue.getText());
                        clientMessaagesRecordsRequest.setTime(sessionValue.getTime());
                        clientMessaagesRecordsRequest.setOpenid(sessionValue.getOpenid());
                        clientMessagesList.add(clientMessaagesRecordsRequest);
                    });
                }
                //再对worker+openid组合去重，找出每个会话中的客服人员和对应的会话id
                List<ClientMessaagesRecordsRequest> resultSessionValues = clientMessagesList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getOpenid() + ";" + o.getKfAccount()))), ArrayList::new));
                //再用map分组
                //初始化一个map
                Map<String, List<ClientMessaagesRecordsRequest>> mapregrp = new HashMap<>();
                for (ClientMessaagesRecordsRequest clientMessaagesRecordsRequestRegroup : resultSessionValues) {
                    String key = clientMessaagesRecordsRequestRegroup.getSessionId();
                    if (mapregrp.containsKey(key)) {
                        //map中存在以此id作为的key，将数据存放当前key的map中
                        mapregrp.get(key).add(clientMessaagesRecordsRequestRegroup);
                    } else {
                        //map中不存在以此id作为的key，新建key用来存放数据
                        List<ClientMessaagesRecordsRequest> regroupagain = new ArrayList<>();
                        regroupagain.add(clientMessaagesRecordsRequestRegroup);
                        mapregrp.put(key, regroupagain);
                    }
                }
                System.out.println(mapregrp);








                //会话列表的List用于新增
                List<ClientSessionRequest> insertSessionResult = new ArrayList<>();
                //分组结束，迭代map重组会话内容
                //用迭代器遍历分组数据
                Iterator<Map.Entry<String, List<ClientMessaagesRecordsRequest>>> regroupSessionList = mapregrp.entrySet().iterator();
                while (regroupSessionList.hasNext()) {
                    Map.Entry<String, List<ClientMessaagesRecordsRequest>> regroupSessionEntry = regroupSessionList.next();
                    String key = regroupSessionEntry.getKey();
                    List<ClientMessaagesRecordsRequest> value = regroupSessionEntry.getValue();
                    //每一次就是一个会话 完全遍历后处理好数据插入会话表中 list存储的引用对象
                    ClientSessionRequest clientSessionRequest = new ClientSessionRequest();
                    //每个会话对应唯一的array
                    JSONArray array = new JSONArray();
                    //这里是处理每一个会话对应多少个客服的
                    value.forEach(fkresult -> {
                        array.add(fkresult.getKfAccount());
                        clientSessionRequest.setWorker(fkresult.getKfAccount());
                        clientSessionRequest.setOpenid(fkresult.getOpenid());
                        clientSessionRequest.setId(fkresult.getSessionId());
                        clientSessionRequest.setGmtModified(dataTimeByFk);
                        clientSessionRequest.setGmtCreate(dataTimeByFk);
                        clientSessionRequest.setCreator(userNo);
                        clientSessionRequest.setModifier(userNo);
                    });
                    clientSessionRequest.setKfList(array.toString());
                    insertSessionResult.add(clientSessionRequest);
                    System.out.println(key + ":" + value);
                }
                //存入会话实例记录表中
                int session = clientSessionDao.insertSessionList(insertSessionResult);
                System.out.println(clientMessagesList);
                //将分组数据存入聊天记录表中
                int nb = clientSessionDao.insertMessageRecords(clientMessagesList);
                System.out.println(clientMessagesList);
            }else {
                //数据库中查到这个会话，取这个会话最后的时间和聊天记录第一条的时间对比，超过48小时新建会话，
                /**
                 * 查询openid对应时间戳的最大值
                 * select openid, max(time) AS MAXIMUM
                 * FROM session_records
                 * GROUP BY openid
                 **/
            List<ClientSessionRequest> resultTimeList = clientSessionDao.selectMaxTime(finallClientNumResult);
                for (int i = 0; i < finallClientNumResult.size(); i++) {
                    String openid = finallClientNumResult.get(i).getOpenid();
                    String time1 = finallClientNumResult.get(i).getTime();
                    for (int j = 0; j < resultTimeList.size(); j++) {
                        String openid1 = resultTimeList.get(j).getOpenid();
                        String time = resultTimeList.get(j).getTime();
                        if (openid.equals(openid1)) {
                            //返回了两个时间戳间隔的小时
                            int i1 = daysBetween2(time, time1);
                            if (i1 > 48) {
                                //创建全新会话
                                List<ClientMessaagesRecordsRequest> clientMessagesList = new ArrayList<>();
                                //用迭代器遍历分组数据
                                Iterator<Map.Entry<String, List<ClientSessionRequest>>> entries = map.entrySet().iterator();
                                while (entries.hasNext()) {
                                    String sessionId = idGenerator.nextId() + "";
                                    Map.Entry<String, List<ClientSessionRequest>> entry = entries.next();
                                    String key = entry.getKey();
                                    List<ClientSessionRequest> value = entry.getValue();
                                    //对每一个分组数据是一个会话 处理每个会话存入的聊天记录
                                    value.forEach(sessionValue -> {
                                        ClientMessaagesRecordsRequest clientMessaagesRecordsRequest = new ClientMessaagesRecordsRequest();
                                        clientMessaagesRecordsRequest.setSessionId(sessionId);
                                        clientMessaagesRecordsRequest.setCreator(userNo);
                                        clientMessaagesRecordsRequest.setGmtCreate(dataTimeByFk);
                                        //每个id都是独立的
                                        clientMessaagesRecordsRequest.setId(idGenerator.nextId() + "");
                                        clientMessaagesRecordsRequest.setKfAccount(sessionValue.getWorker());
                                        clientMessaagesRecordsRequest.setOpercode(sessionValue.getOpercode());
                                        clientMessaagesRecordsRequest.setText(sessionValue.getText());
                                        clientMessaagesRecordsRequest.setTime(sessionValue.getTime());
                                        clientMessaagesRecordsRequest.setOpenid(sessionValue.getOpenid());
                                        clientMessagesList.add(clientMessaagesRecordsRequest);
                                    });
                                }
                                //再对worker+openid组合去重，找出每个会话中的客服人员和对应的会话id
                                List<ClientMessaagesRecordsRequest> resultSessionValues = clientMessagesList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getOpenid() + ";" + o.getKfAccount()))), ArrayList::new));
                                //再用map分组
                                //初始化一个map
                                Map<String, List<ClientMessaagesRecordsRequest>> mapregrp = new HashMap<>();
                                for (ClientMessaagesRecordsRequest clientMessaagesRecordsRequestRegroup : resultSessionValues) {
                                    String key = clientMessaagesRecordsRequestRegroup.getSessionId();
                                    if (mapregrp.containsKey(key)) {
                                        //map中存在以此id作为的key，将数据存放当前key的map中
                                        mapregrp.get(key).add(clientMessaagesRecordsRequestRegroup);
                                    } else {
                                        //map中不存在以此id作为的key，新建key用来存放数据
                                        List<ClientMessaagesRecordsRequest> regroupagain = new ArrayList<>();
                                        regroupagain.add(clientMessaagesRecordsRequestRegroup);
                                        mapregrp.put(key, regroupagain);
                                    }
                                }
                                System.out.println(mapregrp);
                                //会话列表的List用于新增
                                List<ClientSessionRequest> insertSessionResult = new ArrayList<>();
                                //分组结束，迭代map重组会话内容
                                //用迭代器遍历分组数据
                                Iterator<Map.Entry<String, List<ClientMessaagesRecordsRequest>>> regroupSessionList = mapregrp.entrySet().iterator();
                                while (regroupSessionList.hasNext()) {
                                    Map.Entry<String, List<ClientMessaagesRecordsRequest>> regroupSessionEntry = regroupSessionList.next();
                                    String key = regroupSessionEntry.getKey();
                                    List<ClientMessaagesRecordsRequest> value = regroupSessionEntry.getValue();
                                    //每一次就是一个会话 完全遍历后处理好数据插入会话表中 list存储的引用对象
                                    ClientSessionRequest clientSessionRequest = new ClientSessionRequest();
                                    //每个会话对应唯一的array
                                    JSONArray array = new JSONArray();
                                    //这里是处理每一个会话对应多少个客服的
                                    value.forEach(fkresult -> {
                                        array.add(fkresult.getKfAccount());
                                        clientSessionRequest.setWorker(fkresult.getKfAccount());
                                        clientSessionRequest.setOpenid(fkresult.getOpenid());
                                        clientSessionRequest.setId(fkresult.getSessionId());
                                        clientSessionRequest.setGmtModified(dataTimeByFk);
                                        clientSessionRequest.setGmtCreate(dataTimeByFk);
                                        clientSessionRequest.setCreator(userNo);
                                        clientSessionRequest.setModifier(userNo);
                                    });
                                    clientSessionRequest.setKfList(array.toString());
                                    insertSessionResult.add(clientSessionRequest);
                                    System.out.println(key + ":" + value);
                                }
                                //存入会话实例记录表中
                                int session = clientSessionDao.insertSessionList(insertSessionResult);
                                System.out.println(clientMessagesList);
                                //将分组数据存入聊天记录表中
                                int nb = clientSessionDao.insertMessageRecords(clientMessagesList);
                                System.out.println(clientMessagesList);
                            }
                            else if (i1<48){
                                for (int k = 0; k < result.size(); k++) {
                                    //DB的KFLIST
                                    String kfList1 = result.get(k).getKfList();
                                    String openid2 = result.get(k).getOpenid();
                                    System.out.println(map);
                                    List<ClientSessionRequest> clientSessionRequests = map.get(openid2.toString());
                                    //去重减少数据库的操作
                                    List<ClientSessionRequest> ctslist = clientSessionRequests.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getOpenid() + ";" + o.getWorker()))), ArrayList::new));
                                    ctslist.forEach(resultItem->{
                                        String worker = resultItem.getWorker();
                                        int flag = kfList1.indexOf(worker);
                                        if (flag==-1){
                                            ClientSessionRequest updateRequest = new ClientSessionRequest();
                                            updateRequest.setOpenid(openid2);
                                            cn.hutool.json.JSONArray kflistJsonArray = JSONUtil.parseArray(kfList1);
                                            kflistJsonArray.add(worker);
                                            updateRequest.setKfList(kflistJsonArray.toString());
                                            int nb = clientSessionDao.updateSessionKfList(updateRequest);
                                        }else {

                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    @Override
    public JSONObject saveRoleList(String recordUrl) {
        try {
            JSONObject httpMethod = getHttpMethod(recordUrl);
            if (httpMethod.get("kf_list") != null) {
                List<ClientRoleRequest> roleList = (List<ClientRoleRequest>) JSONArray.parseArray(httpMethod.get("kf_list").toString(), ClientRoleRequest.class);
                roleList.forEach(item -> {
                    item.setId(idGenerator.nextId() + "");
                    item.setSortSn("1");
                });
                int delete = clientSessionDao.deleteRoleList(roleList);
                int i = clientSessionDao.insertRoleList(roleList);
            }
            return httpMethod;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JSONObject getWxToken(String recordUrl) {
        try {
            JSONObject httpMethod = getHttpMethod(recordUrl);
            return httpMethod;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public  List<ClientRoleResponse> queryClientRole() {
        try {
            List<ClientRoleResponse> clientRoleResponse = clientSessionDao.queryClientRole();
            return clientRoleResponse;
        }catch (Exception e){
            throw new RuntimeException("运行失败"+e);
        }

    }

    @Override
    public List<ClientMessaagesRecordsResponse> queryMessageByAny(ClientMessaagesRecordsRequest clientMessages) {
        try{
            List<ClientMessaagesRecordsResponse> clientMessaagesRecordsResponses = clientSessionDao.queryMessageByAny(clientMessages);
            return clientMessaagesRecordsResponses;
        }catch (Exception e){
            throw  new RuntimeException("查询失败"+e);
        }

    }

    @Override
    public List<ClientCountDayResponse> queryCountDetail(ClientCountDayRequest clientCountDayRequest) {
      try {
          List<ClientCountDayResponse> clientCountDayResponses = clientSessionDao.queryCountDetail(clientCountDayRequest);
          clientCountDayResponses.forEach(changeResponse->{
              String countSession = changeResponse.getCountSession();
              String s = removeTrim(countSession);
              changeResponse.setCountSession(s);
          });
          return clientCountDayResponses;
      }catch (Exception e){
          throw new RuntimeException("查询失败"+e);
      }
    }

    public static String removeTrim(String str){
        if(str.indexOf(".") > 0){
            str = str.replaceAll("0+?$", "");//去掉多余的0
            str = str.replaceAll("[.]$", "");//如最后一位是.则去掉
        }
        return str;
    }
    @Override
    public  List<ClientCountMonthAndYearResponse>  queryCountDetailMonth(ClientCountMonthAndYearRequest clientCountDayRequest) {
        try {
            List<ClientCountMonthAndYearResponse> clientCountDayResponses = clientSessionDao.queryCountDetailMonth(clientCountDayRequest);
            clientCountDayResponses.forEach(changeResponse->{
                String countSession = changeResponse.getCountSession();
                String s = removeTrim(countSession);
                changeResponse.setCountSession(s);
            });
            return clientCountDayResponses;
        }catch (Exception e){
            throw new RuntimeException("查询失败"+e);
        }
    }

    @Override
    public  List<ClientCountMonthAndYearResponse>  queryCountDetailYear(ClientCountMonthAndYearRequest clientCountDayRequest) {
        try {
            List<ClientCountMonthAndYearResponse> clientCountDayResponses = clientSessionDao.queryCountDetailYear(clientCountDayRequest);
            clientCountDayResponses.forEach(changeResponse->{
                String countSession = changeResponse.getCountSession();
                String s = removeTrim(countSession);
                changeResponse.setCountSession(s);
            });
            return clientCountDayResponses;
        }catch (Exception e){
            throw new RuntimeException("查询失败"+e);
        }
    }
}
