package com.ebike.openservices.cscmgmt.serviceImpl;


import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.cscmgmt.dao.CustomerWorkOrderDao;
import com.ebike.openservices.cscmgmt.request.*;
import com.ebike.openservices.cscmgmt.response.BpCodeResponse;
import com.ebike.openservices.cscmgmt.response.CustomerQueryResponse;
import com.ebike.openservices.cscmgmt.response.DeviceQueryResponse;
import com.ebike.openservices.cscmgmt.service.CustomerWorkOrderService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class CustomerWorkOrderImpl extends AbstractEbikeBaseService implements CustomerWorkOrderService {

    @Resource
    private CustomerWorkOrderDao customerWorkOrderDao;

    @Override
    public Map<String, Object> queryCustomerList(CustomerRequest customerRequest) {
        Map<String, Object> resultMap = new HashMap<>();
        List<CustomerQueryResponse> list = customerWorkOrderDao.queryCustomerList(customerRequest);
        list.forEach(response->{
            String csCheckinInfo = response.getCsCheckinInfo();
            Map map = JsonConvertUtils.convertFromString(csCheckinInfo, Map.class);
            if (map != null) {
                response.setCallTime(ObjectUtils.toStringDefaultEmpty(map.get("callTime")));
                response.setPhoneNo(ObjectUtils.toStringDefaultEmpty(map.get("phoneNo")));
                response.setPlugSn(ObjectUtils.toStringDefaultEmpty(map.get("plugSn")));
                response.setChargePayMode(ObjectUtils.toStringDefaultEmpty(map.get("chargePayMode")));
                response.setRemark(ObjectUtils.toStringDefaultEmpty(map.get("remark")));
                response.setChargestationNameInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargestationName")));
                response.setChargedeviceNoInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargedeviceNo")));
            }
        });
        int total = customerWorkOrderDao.queryCustomerListTotal(customerRequest);
        resultMap.put("list", list);
        resultMap.put("total", total);
        return resultMap;
    }

    @Override
    public Map<String, Object> queryDeviceList(DeviceQueryRequest deviceQueryRequest) {
        Map<String, Object> resultMap = new HashMap<>();
        List<DeviceQueryResponse> list = customerWorkOrderDao.queryDeviceList(deviceQueryRequest);
        Integer type = deviceQueryRequest.getType();
        Integer total = 0;
        List<Integer> totals = customerWorkOrderDao.queryDeviceListTotal(deviceQueryRequest);
        if(type == 1 && totals != null){
            //如果查询全部类型则union all结果累加
            total = totals.get(0) + totals.get(1);
        }else{
            total = totals.get(0);
        }
        resultMap.put("list", list);
        resultMap.put("total", total);
        return resultMap;
    }

    @Override
    public int addCustomer(CustomerAddRequest customerAddRequest) {
        return customerWorkOrderDao.addCustomer(customerAddRequest);
    }

    /**
     * 根据用户手机号寻找用户标识
     *
     * @param phone@return
     */
    @Override
    public String queryChargeUserIdByPhone(String phone) {
        return customerWorkOrderDao.queryChargeUserIdByPhone(phone);
    }

    @Override
    public int updateCustomer(CustomerAddRequest customerAddRequest) {
        return  customerWorkOrderDao.updateCustomer(customerAddRequest);
    }

    @Override
    public int deleteCustomer(List<String> idList) {
        return customerWorkOrderDao.deleteCustomer(idList);
    }

    @Override
    public CustomerQueryResponse queryCustomerDetails(String csworkorderId) {
        CustomerQueryResponse response = customerWorkOrderDao.queryCustomerDetails(csworkorderId);
        String csCheckinInfo = response.getCsCheckinInfo();
        Map map = JsonConvertUtils.convertFromString(csCheckinInfo, Map.class);
        if (map != null) {
            response.setCallTime(ObjectUtils.toStringDefaultEmpty(map.get("callTime")));
            response.setPhoneNo(ObjectUtils.toStringDefaultEmpty(map.get("phoneNo")));
            response.setPlugSn(ObjectUtils.toStringDefaultEmpty(map.get("plugSn")));
            response.setChargePayMode(ObjectUtils.toStringDefaultEmpty(map.get("chargePayMode")));
            response.setRemark(ObjectUtils.toStringDefaultEmpty(map.get("remark")));
            response.setChargestationNameInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargestationName")));
            response.setChargedeviceNoInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargedeviceNo")));
        }
        return response;
    }

    @Override
    @Transactional
    public int updateAndInsertCustomer(CustomerHisAddRequest customerHisAddRequest) {
        customerWorkOrderDao.updateCustomerOnFile(customerHisAddRequest);

        return customerWorkOrderDao.addCustomerHis(customerHisAddRequest);
    }

    @Override
    public List<BpCodeResponse> queryCode(BpCodeResponse bpCodeResponse) {
        return customerWorkOrderDao.queryCode(bpCodeResponse);
    }
}
