package com.ebike.openservices.cscmgmt.serviceImpl;


import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.ebike.openservices.cscmgmt.dao.FilingWorkOrderDao;
import com.ebike.openservices.cscmgmt.request.CustomerHisAddRequest;
import com.ebike.openservices.cscmgmt.response.CustomerQueryResponse;
import com.ebike.openservices.cscmgmt.service.FilingWorkOrderService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class FilingWorkOrderImpl implements FilingWorkOrderService {
    @Resource
    private FilingWorkOrderDao filingWorkOrderDao;
    @Override
    public Map<String, Object> queryFilingList(CustomerHisAddRequest FilingRequest) {
        Map<String ,Object> resultMap = new HashMap<>();
        List<CustomerQueryResponse> list = filingWorkOrderDao.queryFilingList(FilingRequest);
        list.forEach(response->{
                String csCheckinInfo = response.getCsCheckinInfo();
                Map map = JsonConvertUtils.convertFromString(csCheckinInfo, Map.class);
                if (map != null) {
                    response.setCallTime(ObjectUtils.toStringDefaultEmpty(map.get("callTime")));
                    response.setPhoneNo(ObjectUtils.toStringDefaultEmpty(map.get("phoneNo")));
                    response.setPlugSn(ObjectUtils.toStringDefaultEmpty(map.get("plugSn")));
                    response.setChargePayMode(ObjectUtils.toStringDefaultEmpty(map.get("chargePayMode")));
                    response.setRemark(ObjectUtils.toStringDefaultEmpty(map.get("remark")));
                    response.setChargestationNameInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargestationName")));
                    response.setChargedeviceNoInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargedeviceNo")));
                }
        });
        int total = filingWorkOrderDao.queryFilingListTotal(FilingRequest);
        resultMap.put("list", list);
        resultMap.put("total", total);
        return resultMap;
    }

    @Override
    public CustomerQueryResponse queryFilingDetails(String csworkorderId) {
            CustomerQueryResponse response = filingWorkOrderDao.queryFilingDetails(csworkorderId);
            String csCheckinInfo = response.getCsCheckinInfo();
            Map map = JsonConvertUtils.convertFromString(csCheckinInfo, Map.class);
            if (map != null) {
                response.setCallTime(ObjectUtils.toStringDefaultEmpty(map.get("callTime")));
                response.setPhoneNo(ObjectUtils.toStringDefaultEmpty(map.get("phoneNo")));
                response.setPlugSn(ObjectUtils.toStringDefaultEmpty(map.get("plugSn")));
                response.setChargePayMode(ObjectUtils.toStringDefaultEmpty(map.get("chargePayMode")));
                response.setRemark(ObjectUtils.toStringDefaultEmpty(map.get("remark")));
                response.setChargestationNameInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargestationName")));
                response.setChargedeviceNoInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargedeviceNo")));
            }
            return response;
        }
    }
