package com.ebike.openservices.cscmgmt.serviceImpl;


import cn.hutool.core.convert.Convert;
import com.ebike.openservices.cscmgmt.dao.JudgeWorkOrderDao;
import com.ebike.openservices.cscmgmt.request.JudgeAddRequest;
import com.ebike.openservices.cscmgmt.request.TkSuggestionRequest;
import com.ebike.openservices.cscmgmt.response.AfterSaleResponse;
import com.ebike.openservices.cscmgmt.response.JudgeMessageResponse;
import com.ebike.openservices.cscmgmt.service.JudgeWorkOrderService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class
JudgeWorkOrderImpl implements JudgeWorkOrderService {
    @Resource
    private JudgeWorkOrderDao judgeWorkOrderDao;

    /**
     * 研判操作
     *
     * @param judgeAddRequest
     * @return
     */
    @Override
    public int updateJudge(JudgeAddRequest judgeAddRequest) {
        int result = judgeWorkOrderDao.updateJudge(judgeAddRequest);
        return result;
    }


    @Override
    public List<AfterSaleResponse> quearyAfterSale() {
        List<AfterSaleResponse> result = judgeWorkOrderDao.quearyAfterSale();
        return result;
    }

    @Override
    public int updateStatus(JudgeAddRequest judgeAddRequest) {
        int result = judgeWorkOrderDao.updateStatus(judgeAddRequest);
        return result;
    }

    /**
     * 退费处理
     *
     * @return
     */
    @Override
    public int tkSuggestion(TkSuggestionRequest tkSuggestionRequest) {
        int numNoNo = judgeWorkOrderDao.queryHandleSn(tkSuggestionRequest);
        if (numNoNo == 0) {
            numNoNo = 1;
        } else {
            numNoNo = numNoNo + 1;
        }
        tkSuggestionRequest.setHandleSn(Convert.toStr(numNoNo));
        int result = judgeWorkOrderDao.tkSuggestion(tkSuggestionRequest);
        return result;
    }

    @Override
    public JudgeMessageResponse selectUserIdByPhone(JudgeAddRequest judgeAddRequest) {
        JudgeMessageResponse result = judgeWorkOrderDao.queryUserIdByPhone(judgeAddRequest);
        return result;

    }

    @Override
    public JudgeMessageResponse selectDeviceId(JudgeAddRequest judgeAddRequest) {
        JudgeMessageResponse result = judgeWorkOrderDao.queryDeviceId(judgeAddRequest);
        return result;
    }

    @Override
    public JudgeMessageResponse selectPlugId(JudgeAddRequest judgeAddRequest) {
        JudgeMessageResponse result = judgeWorkOrderDao.queryPlugId(judgeAddRequest);
        return result;
    }

    /**
     * 查询记录
     *
     * @param judgeAddRequest
     * @return
     */
    @Override
    public Map<String, Object> queryMessage(JudgeAddRequest judgeAddRequest) {
        Map<String, Object> resultMap = new HashMap<>();
        List<JudgeMessageResponse> list = judgeWorkOrderDao.queryMessage(judgeAddRequest);
        int total = judgeWorkOrderDao.queryMessageTotal(judgeAddRequest);
        resultMap.put("list", list);
        resultMap.put("total", total);
        return resultMap;
    }


}
