/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.cscmgmt.jdbcdao.Impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.cscmgmt.jdbcdao.ChargeRepairsDao;
import com.ebike.openservices.cscmgmt.util.EbikeCommonUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ChargeRepairsDaoImpl
extends AbstractEbikeBaseJdbcDao
implements ChargeRepairsDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public ChargeRepairsDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public Map<String, Object> getRepairsDetailById(String id, final String flag) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if ("0".equals(flag)) {
                sql.append(" select a.csworkorderType,a.commitTime,a.csworkorderDesc,a.chargedeviceNo,a.relaObjectType,a.chargeplugNo,a.chargeRecordId,a.csworkorderNode, ");
                sql.append(" a.chargestationNo,a.orgName,a.oppersonName,a.csworkorderAttach,h.chargeUserName,h.chargeUserMobile  from ebike.csc_workorder a  ");
                sql.append("  left join ebike.ebike_chargeuser h on a.chargeUserId=h.chargeUserId  where 1=1 ");
            } else {
                sql.append(" select a.csworkorderType,a.commitTime,a.csworkorderDesc,a.chargedeviceNo,a.relaObjectType,a.chargeplugNo,a.chargeRecordId, ");
                sql.append(" a.chargestationNo,a.orgName,a.oppersonName,a.csworkorderAttach,h.chargeUserName,h.chargeUserMobile  from ebike.csc_workorder_his a  ");
                sql.append("  left join ebike.ebike_chargeuser h on a.chargeUserId=h.chargeUserId  where 1=1 ");
            }
            sql.append(" and a.csworkorderId = ? ", (Object)id);
            this.logger.debug("++++++++++++++++++++getRepairsDetailById++++++++++++++++++++++++++" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("chargeUserName", rs.getString("chargeUserName"));
                    map.put("commitTime", DateConvertUtils.convertToString((Date)rs.getTimestamp("commitTime"), (String)"yyyy.MM.dd HH:mm:ss"));
                    map.put("csworkorderType", rs.getString("csworkorderType"));
                    map.put("csworkorderDesc", rs.getString("csworkorderDesc"));
                    map.put("chargedeviceNo", rs.getString("chargedeviceNo"));
                    map.put("chargeRecordId", rs.getString("chargeRecordId"));
                    map.put("chargestationNo", rs.getString("chargestationNo"));
                    map.put("orgName", rs.getString("orgName"));
                    map.put("oppersonName", rs.getString("oppersonName"));
                    map.put("chargeplugNo", rs.getString("chargeplugNo"));
                    map.put("relaObjectType", rs.getString("relaObjectType"));
                    map.put("csworkorderAttach", rs.getString("csworkorderAttach"));
                    if (flag.equals("0")) {
                        map.put("csworkorderNode", rs.getString("csworkorderNode"));
                    }
                    map.put("chargeUserMobile", rs.getString("chargeUserMobile"));
                    ChargeRepairsDaoImpl.this.logger.debug("++++++++++++++++getRepairsDetailById++++++++++++++++++++++" + rs.getString("csworkorderAttach"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list != null && list.size() > 0) {
            return (Map)list.get(0);
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getRepairsInfo(final Map<String, String> maps, int start) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String uptoDate = maps.get("UptoDate");
        final String flag = maps.get("flag");
        String csworkorderClass = maps.get("csworkorderClass");
        String startDay = maps.get("startDay");
        String endDay = maps.get("endDay");
        if (uptoDate.equals("30")) {
            uptoDate = "20";
        }
        try {
            if (maps.get("flag").equals("0")) {
                sql.append(" select a.csworkorderClass,a.chargedeviceNo,a.csworkorderId,a.commitTime,a.csworkorderType,a.chargeRecordId,a.chargeUserId,b.handler,b.handleTime,c.chargeUserName,a.chargedeviceNo,a.orgName as 'carrieroperator',h.ORG_NAME as 'RenewingUnit'  ");
                sql.append(" ,a.csworkorderStatus,a.csworkorderNode,a.relaObjectType,a.chargeRecordId,c.chargeUserMobile ");
                sql.append(" FROM ebike.csc_workorder a left join ebike.csc_workorder_handledetail b on a.csworkorderId=b.csworkorderId ");
                sql.append(" left join ebike.ebike_chargeuser c on a.chargeUserId=c.chargeUserId ");
                sql.append(" left join ebike.ebike_chargerecord_his e on a.chargeRecordId=e.chargeRecordId ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice d on e.chargedeviceId=d.ID");
                sql.append(" left join cisp_dev.dev_powersystemresource f on d.ID=f.ID");
                sql.append(" left join cisp_sys.bp_user k on b.handler=k.USER_NAME ");
                sql.append(" left join cisp_sys.bp_org h on k.user_org_no=h.ORG_NO where 1=1");
                sql.append("  and not exists (select * from ebike.csc_workorder_handledetail");
                sql.append("  where csworkorderId=b.csworkorderId and handleTime>b.handleTime)");
            } else {
                sql.append(" select a.csworkorderClass,a.chargedeviceNo,a.csworkorderId,a.commitTime,a.chargeUserId,a.csworkorderType,a.chargeRecordId,h.ORG_NAME as 'RenewingUnit', ");
                sql.append(" a.csworkorderStatus,c.chargeUserMobile, ");
                sql.append(" a.archiver,a.archiveTime,c.chargeUserName,a.chargedeviceNo,a.orgName as 'carrieroperator' FROM ");
                sql.append(" ebike.csc_workorder_his a ");
                sql.append(" left join ebike.ebike_chargeuser c on a.chargeUserId=c.chargeUserId ");
                sql.append(" left join ebike.ebike_chargerecord_his e on a.chargeRecordId=e.chargeRecordId ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice d on e.chargedeviceId=d.ID");
                sql.append(" left join cisp_dev.dev_powersystemresource f on d.ID=f.ID");
                sql.append(" left join cisp_sys.bp_user k on a.archiver=k.USER_NAME ");
                sql.append(" left join cisp_sys.bp_org h on k.user_org_no=h.ORG_NO where 1=1");
            }
            if ("1".equals(csworkorderClass)) {
                sql.append(" and a.csworkorderClass = 1 ");
            }
            if ("2".equals(csworkorderClass)) {
                sql.append(" and a.csworkorderClass = 2 ");
            }
            if (!"".equals(startDay)) {
                sql.append(" and a.commitTime >= ?", (Object)DateConvertUtils.convertFromString((String)maps.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            }
            if (!"".equals(endDay)) {
                sql.append(" and a.commitTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)maps.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            }
            sql.append(" and a.csworkorderType in (10,20) ");
            sql.append(" and a.csworkorderType =? ", (Object)maps.get("gdlx"));
            sql.append(" and a.csworkorderStatus=? ", (Object)uptoDate);
            sql.append(" and a.chargedeviceNo like ? ", (Object)("%" + maps.get("devNo") + "%"));
            sql.append(" and c.chargeUserName like ? ", (Object)("%" + maps.get("repairsM") + "%"));
            sql.append(" and c.chargeUserMobile like ? ", (Object)("%" + maps.get("phone") + "%"));
            sql.append("  order by a.commitTime desc ");
            if (start == 1) {
                sql.append(" limit 0,10 ");
            } else {
                int starts = (start - 1) * 10;
                int end = start * 10;
                sql.append(" limit ? ", (Object)starts);
                sql.append(" , 10 ");
            }
            this.logger.debug("++++++++++++++++++++++++ChargeRepairsDaoImpl+++++++++++" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("csworkorderClass", rs.getString("csworkorderClass"));
                    map.put("chargedeviceNo", rs.getString("chargedeviceNo"));
                    map.put("chargeUserId", rs.getString("chargeUserId"));
                    map.put("csworkorderId", rs.getString("csworkorderId"));
                    map.put("commitTime", rs.getTimestamp("commitTime"));
                    map.put("chargeUserName", rs.getString("chargeUserName"));
                    map.put("csworkorderType", rs.getString("csworkorderType"));
                    map.put("chargeRecordId", rs.getString("chargeRecordId"));
                    ChargeRepairsDaoImpl.this.logger.debug(">>>>><csworkorderType<<<<<<<<<" + map.get("csworkorderType"));
                    map.put("chargedeviceNo", rs.getString("chargedeviceNo"));
                    map.put("carrieroperator", rs.getString("carrieroperator"));
                    map.put("csworkorderStatus", rs.getString("csworkorderStatus"));
                    if (((String)maps.get("flag")).equals("0")) {
                        map.put("csworkorderNode", rs.getString("csworkorderNode"));
                    }
                    if ("0".equals(flag)) {
                        map.put("handler", rs.getString("handler"));
                        map.put("handleTime", rs.getTimestamp("handleTime"));
                    } else {
                        map.put("archiver", rs.getString("archiver"));
                        map.put("archiveTime", rs.getTimestamp("archiveTime"));
                    }
                    map.put("chargeUserMobile", rs.getString("chargeUserMobile"));
                    map.put("RenewingUnit", rs.getString("RenewingUnit"));
                    return map;
                }
            });
            this.logger.debug("++++++++++++++++++++++++ChargeRepairsDaoImpl+++++++++++" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getRepairsInfoCount(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String uptoDate = map.get("UptoDate");
        String csworkorderClass = map.get("csworkorderClass");
        String startDay = map.get("startDay");
        String endDay = map.get("endDay");
        if (uptoDate.equals("30")) {
            uptoDate = "20";
        }
        try {
            if (map.get("flag").equals("0")) {
                sql.append(" select count(1) from ebike.csc_workorder a left join ebike.csc_workorder_handledetail b on a.csworkorderId=b.csworkorderId ");
                sql.append(" left join ebike.ebike_chargeuser c on a.chargeUserId=c.chargeUserId ");
                sql.append(" left join ebike.ebike_chargerecord_his e on a.chargeRecordId=e.chargeRecordId ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice d on e.chargedeviceId=d.ID");
                sql.append(" left join cisp_dev.dev_powersystemresource f on d.ID=f.ID");
                sql.append(" left join cisp_sys.bp_user k on b.handler=k.USER_NAME ");
                sql.append(" left join cisp_sys.bp_org h on k.user_org_no=h.ORG_NO where 1=1");
                sql.append(" and  not exists (select * from ebike.csc_workorder_handledetail where ");
                sql.append(" csworkorderId=b.csworkorderId and handleTime>b.handleTime) ");
            } else {
                sql.append(" select count(1) from ebike.csc_workorder_his a ");
                sql.append(" left join ebike.ebike_chargeuser c on a.chargeUserId=c.chargeUserId ");
                sql.append(" left join ebike.ebike_chargerecord_his e on a.chargeRecordId=e.chargeRecordId ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice d on e.chargedeviceId=d.ID");
                sql.append(" left join cisp_dev.dev_powersystemresource f on d.ID=f.ID");
                sql.append(" left join cisp_sys.bp_user k on a.archiver=k.USER_NAME ");
                sql.append(" left join cisp_sys.bp_org h on k.user_org_no=h.ORG_NO where 1=1");
            }
            if ("1".equals(csworkorderClass)) {
                sql.append(" and a.csworkorderClass = 1 ");
            }
            if ("2".equals(csworkorderClass)) {
                sql.append(" and a.csworkorderClass = 2 ");
            }
            if (!"".equals(startDay)) {
                sql.append(" and a.commitTime >= ?", (Object)DateConvertUtils.convertFromString((String)map.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            }
            if (!"".equals(endDay)) {
                sql.append(" and a.commitTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)map.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            }
            sql.append(" and a.csworkorderType in (10,20) ");
            sql.append(" and a.csworkorderType =? ", (Object)map.get("gdlx"));
            sql.append(" and a.csworkorderStatus=? ", (Object)uptoDate);
            sql.append(" and a.chargedeviceNo like ? ", (Object)("%" + map.get("devNo") + "%"));
            sql.append(" and c.chargeUserName like ? ", (Object)("%" + map.get("repairsM") + "%"));
            sql.append(" and c.chargeUserMobile like ? ", (Object)("%" + map.get("phone") + "%"));
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> getChargeRecordById(Map<String, String> map, int start) {
        String type = map.get("type");
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            if ("1".equals(type)) {
                sql.append(" select a.chargeTime, a.chargeMoney,a.chargeRecordId,a.isReturn,a.chargeOpenTime,a.chargeFinishTime,a.finishReason,a.chargeAmount,a.usageAmount,c.`NAME`,b.STATIONADDR,a.maxPower*1000  as 'maxPower',d.CHARGEDEVICENO,f.chargeUserMobile ");
                sql.append(" from ebike.ebike_chargerecord_his a  inner join cisp_dev.dev_ebikechargestation b  on a.chargestationId=b.ID ");
                sql.append("  left join cisp_dev.dev_powersystemresource c on b.ID=c.ID  ");
                sql.append(" left join ebike.ebike_chargeuser f  on a.chargeUserId=f.chargeUserId ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice d on a.chargedeviceId=d.ID where 1=1  ");
                sql.append(" and a.chargeUserId=?  ", (Object)map.get("userId"));
                sql.append(" and d.CHARGEDEVICENO like ? ", (Object)("%" + map.get("deviceNo") + "%"));
                sql.append(" and b.STATIONADDR like ? ", (Object)("%" + map.get("stationAddr") + "%"));
                if (map.get("startDay") != null && !"".equals(map.get("startDay"))) {
                    sql.append(" and a.chargeOpenTime >= ?", (Object)DateConvertUtils.convertFromString((String)map.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
                }
                if (map.get("endDay") != null && !"".equals(map.get("endDay"))) {
                    sql.append(" and a.chargeFinishTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)map.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
                }
                sql.append(" order by a.chargeTime desc ");
            }
            if ("2".equals(type)) {
                sql.append(" select a.chargeTime, a.chargeMoney,a.chargeRecordId,a.isReturn,a.chargeOpenTime, ");
                sql.append(" a.chargeFinishTime,a.finishReason,a.chargeAmount,a.usageAmount,b.charging_station_name as name,");
                sql.append(" b.charging_station_addr as STATIONADDR,a.maxPower * 1000 AS 'maxPower', ");
                sql.append(" d.charging_pile_no as CHARGEDEVICENO,f.chargeUserMobile  ");
                sql.append(" from ebike.ebike_chargerecord_his a ");
                sql.append(" inner join ebike.oper_ev_charging_station b on a.chargestationId = b.id ");
                sql.append(" left join ebike.ebike_chargeuser f on a.chargeUserId = f.chargeUserId ");
                sql.append(" left join ebike.dev_ev_charging_pile d on a.chargedeviceId = d.id ");
                sql.append(" where true ");
                sql.append(" and a.chargeUserId=?  ", (Object)map.get("userId"));
                sql.append(" and d.charging_pile_no like ? ", (Object)("%" + map.get("deviceNo") + "%"));
                sql.append(" and b.charging_station_addr like ? ", (Object)("%" + map.get("stationAddr") + "%"));
                if (map.get("startDay") != null && !"".equals(map.get("startDay"))) {
                    sql.append(" and a.chargeOpenTime >= ?", (Object)DateConvertUtils.convertFromString((String)map.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
                }
                if (map.get("endDay") != null && !"".equals(map.get("endDay"))) {
                    sql.append(" and a.chargeFinishTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)map.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
                }
                sql.append(" order by a.chargeTime desc ");
            }
            if (start == 1) {
                sql.append(" limit 0,10 ");
            } else {
                int starts = (start - 1) * 10;
                int end = start * 10;
                sql.append(" limit ? ", (Object)starts);
                sql.append(" , 10 ");
            }
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("chargeMoney", rs.getDouble("chargeMoney"));
                    if (rs.getString("isReturn").equals("Y")) {
                        map.put("isReturn", "\u9884\u4ed8\u53ef\u9000");
                    } else {
                        map.put("isReturn", "\u9884\u4ed8\u4e0d\u9000");
                    }
                    map.put("chargeOpenTime", rs.getTimestamp("chargeOpenTime"));
                    map.put("chargeFinishTime", rs.getTimestamp("chargeFinishTime"));
                    if (rs.getString("finishReason").equals("0")) {
                        map.put("finishReason", "\u7535\u91cf\u7528\u5b8c\u505c\u6b62\u5145\u7535");
                    } else if (rs.getString("finishReason").equals("1")) {
                        map.put("finishReason", "\u6d6e\u5145\u65f6\u95f4\u5b8c\u6210\u505c\u6b62\u5145\u7535");
                    } else if (rs.getString("finishReason").equals("2")) {
                        map.put("finishReason", "\u63d2\u5934\u62d4\u6389\u505c\u6b62\u5145\u7535");
                    } else if (rs.getString("finishReason").equals("3")) {
                        map.put("finishReason", "\u529f\u7387\u8d85\u9650\u505c\u6b62\u5145\u7535");
                    } else if (rs.getString("finishReason").equals("4")) {
                        map.put("finishReason", "\u8ba1\u65f6\u65f6\u95f4\u5230\u505c\u6b62\u5145\u7535");
                    } else if (rs.getString("finishReason").equals("5")) {
                        map.put("finishReason", "\u8f93\u51fa\u5f02\u5e38\uff08\u7aef\u5b50\u5931\u7535\uff09");
                    } else if (rs.getString("finishReason").equals("-1")) {
                        map.put("finishReason", "\u8bbe\u5907\u603b\u4f53\u5df2\u7ecf\u8d85\u8fc7\u6700\u5927\u529f\u7387");
                    } else if (rs.getString("finishReason").equals("-97")) {
                        map.put("finishReason", "\u5269\u4f59\u5145\u7535\u7535\u91cf\uff08\u6216\u5269\u4f59\u5145\u7535\u65f6\u95f4\uff09\u4e3a\u96f6\uff0c\u4f46\u7ed3\u675f\u547d\u4ee4\u672a\u6536\u5230");
                    } else if (rs.getString("finishReason").equals("-98")) {
                        map.put("finishReason", "\u5145\u7535\u7ed3\u675f\u7b49\u5f85\u8d85\u65f6");
                    } else {
                        map.put("finishReason", "\u5145\u7535\u5f00\u542f\u7b49\u5f85\u8d85\u65f6");
                    }
                    map.put("chargeRecordId", rs.getString("chargeRecordId"));
                    map.put("chargeAmount", rs.getDouble("chargeAmount"));
                    map.put("usageAmount", rs.getDouble("usageAmount"));
                    map.put("maxPower", rs.getDouble("maxPower"));
                    map.put("NAME", rs.getString("NAME"));
                    map.put("stationAddr", rs.getString("STATIONADDR"));
                    map.put("chargedeviceNo", rs.getString("CHARGEDEVICENO"));
                    map.put("chargeUserMobile", rs.getString("chargeUserMobile"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public Map<String, Object> getRecordDetailById(String orderId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> maps = new HashMap<String, Object>();
        try {
            sql.append(" select  a.chargeMoney,a.isReturn,a.chargeOpenTime,a.chargeFinishTime,a.finishReason,a.chargeAmount,a.usageAmount, ");
            sql.append(" a.maxPower*1000  as 'maxPower',a.schemeId,a.surplusAmount,b.schemeName ");
            sql.append("  from ebike.ebike_chargerecord_his a  left join ebike.ebike_billingscheme b on a.schemeId=b.schemeId ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice d on a.chargedeviceId=d.DEVICEID where 1=1  ");
            sql.append(" and a.chargeRecordId=?  ", (Object)orderId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("chargeMoney", rs.getDouble("chargeMoney"));
                    if (rs.getString("isReturn").equals("Y")) {
                        map.put("isReturn", "\u9884\u4ed8\u53ef\u9000");
                    } else {
                        map.put("isReturn", "\u9884\u4ed8\u4e0d\u9000");
                    }
                    map.put("chargeOpenTime", DateConvertUtils.convertToString((Date)rs.getTimestamp("chargeOpenTime"), (String)"yyyy.MM.dd HH:mm:ss"));
                    map.put("chargeFinishTime", DateConvertUtils.convertToString((Date)rs.getTimestamp("chargeFinishTime"), (String)"yyyy.MM.dd HH:mm:ss"));
                    if (rs.getString("finishReason").equals("0")) {
                        map.put("finishReason", "\u7535\u91cf\u7528\u5b8c\u505c\u6b62\u5145\u7535");
                    } else if (rs.getString("finishReason").equals("1")) {
                        map.put("finishReason", "\u6d6e\u5145\u65f6\u95f4\u5b8c\u6210\u505c\u6b62\u5145\u7535");
                    } else if (rs.getString("finishReason").equals("2")) {
                        map.put("finishReason", "\u63d2\u5934\u62d4\u6389\u505c\u6b62\u5145\u7535");
                    } else if (rs.getString("finishReason").equals("3")) {
                        map.put("finishReason", "\u529f\u7387\u8d85\u9650\u505c\u6b62\u5145\u7535");
                    } else if (rs.getString("finishReason").equals("4")) {
                        map.put("finishReason", "\u8ba1\u65f6\u65f6\u95f4\u5230\u505c\u6b62\u5145\u7535");
                    } else if (rs.getString("finishReason").equals("5")) {
                        map.put("finishReason", "\u8f93\u51fa\u5f02\u5e38\uff08\u7aef\u5b50\u5931\u7535\uff09");
                    } else if (rs.getString("finishReason").equals("-1")) {
                        map.put("finishReason", "\u8bbe\u5907\u603b\u4f53\u5df2\u7ecf\u8d85\u8fc7\u6700\u5927\u529f\u7387");
                    } else if (rs.getString("finishReason").equals("-97")) {
                        map.put("finishReason", "\u5269\u4f59\u5145\u7535\u7535\u91cf\uff08\u6216\u5269\u4f59\u5145\u7535\u65f6\u95f4\uff09\u4e3a\u96f6\uff0c\u4f46\u7ed3\u675f\u547d\u4ee4\u672a\u6536\u5230");
                    } else if (rs.getString("finishReason").equals("-98")) {
                        map.put("finishReason", "\u5145\u7535\u7ed3\u675f\u7b49\u5f85\u8d85\u65f6");
                    } else {
                        map.put("finishReason", "\u5145\u7535\u5f00\u542f\u7b49\u5f85\u8d85\u65f6");
                    }
                    map.put("surplusAmount", rs.getDouble("surplusAmount"));
                    map.put("chargeAmount", rs.getDouble("chargeAmount"));
                    map.put("usageAmount", rs.getDouble("usageAmount"));
                    map.put("maxPower", rs.getDouble("maxPower"));
                    map.put("schemeName", rs.getString("schemeName"));
                    map.put("schemeId", rs.getString("schemeId"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return maps;
    }

    @Override
    public int getRecordByIdCount(Map<String, String> map) {
        String type = map.get("type");
        SqlParamsBuilder sql1 = new SqlParamsBuilder();
        SqlParamsBuilder sql2 = new SqlParamsBuilder();
        try {
            sql1.append(" select count(a.chargeRecordId) ");
            sql1.append(" from ebike.ebike_chargerecord_his a  inner join cisp_dev.dev_ebikechargestation b  on a.chargestationId=b.ID ");
            sql1.append("  left join cisp_dev.dev_powersystemresource c on b.ID=c.ID  ");
            sql1.append(" left join ebike.ebike_chargeuser f  on a.chargeUserId=f.chargeUserId ");
            sql1.append(" left join cisp_dev.dev_ebikechargedevice d on a.chargedeviceId=d.ID where 1=1  ");
            sql1.append(" and a.chargeUserId=?  ", (Object)map.get("userId"));
            sql1.append(" and d.CHARGEDEVICENO like ? ", (Object)("%" + map.get("deviceNo") + "%"));
            sql1.append(" and b.STATIONADDR like ? ", (Object)("%" + map.get("stationAddr") + "%"));
            if (map.get("startDay") != null && !"".equals(map.get("startDay"))) {
                sql1.append(" and a.chargeOpenTime >= ?", (Object)DateConvertUtils.convertFromString((String)map.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            }
            if (map.get("endDay") != null && !"".equals(map.get("endDay"))) {
                sql1.append(" and a.chargeFinishTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)map.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            }
            sql2.append(" select count(a.chargeRecordId) ");
            sql2.append(" from ebike.ebike_chargerecord_his a ");
            sql2.append(" inner join ebike.oper_ev_charging_station b on a.chargestationId = b.id ");
            sql2.append(" left join ebike.ebike_chargeuser f on a.chargeUserId = f.chargeUserId ");
            sql2.append(" left join ebike.dev_ev_charging_pile d on a.chargedeviceId = d.id ");
            sql2.append(" where true ");
            sql2.append(" and a.chargeUserId=?  ", (Object)map.get("userId"));
            sql2.append(" and d.charging_pile_no like ? ", (Object)("%" + map.get("deviceNo") + "%"));
            sql2.append(" and b.charging_station_addr like ? ", (Object)("%" + map.get("stationAddr") + "%"));
            if (map.get("startDay") != null && !"".equals(map.get("startDay"))) {
                sql2.append(" and a.chargeOpenTime >= ?", (Object)DateConvertUtils.convertFromString((String)map.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            }
            if (map.get("endDay") != null && !"".equals(map.get("endDay"))) {
                sql2.append(" and a.chargeFinishTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)map.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            }
            if ("1".equals(type)) {
                return (Integer)this.ebikeJdbcTemplate.queryForObject(sql1.getSql(), sql1.getParams(), Integer.class);
            }
            if ("2".equals(type)) {
                return (Integer)this.ebikeJdbcTemplate.queryForObject(sql2.getSql(), sql2.getParams(), Integer.class);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    @Override
    public List<Map<String, Object>> getFeedbackInfoById(String id, String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.handleNode,a.handleTime,a.handler,a.handleDesc from ebike.csc_workorder_handledetail a where 1=1 ");
            sql.append(" and a.csworkorderId = ?", (Object)id);
            sql.append(" order by a.handleTime asc");
            this.logger.debug("++++++++++++++++getFeedbackInfoById++++++++++++++++++++++++++" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int numrow) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("handleNode", rs.getString("handleNode"));
                    if (rs.getString("handleNode").equals("30")) {
                        map.put("handleDesc", "\u7531 " + rs.getString("handler") + "\u5904\u7406\u56de\u590d ;" + rs.getString("handleDesc"));
                    } else {
                        map.put("handleDesc", rs.getString("handleDesc"));
                    }
                    map.put("handler", rs.getString("handler"));
                    map.put("handleTime", DateConvertUtils.convertToString((Date)rs.getTimestamp("handleTime"), (String)"yyyy.MM.dd HH:mm:ss"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getArchiveInfoById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select archiveTime,archiver,archiveDesc from ebike.csc_workorder_his where 1=1 ");
            sql.append(" and csworkorderId = ?", (Object)id);
            this.logger.debug("+++++++++++++++getArchiveInfoById+++++++++++++++++++++" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("archiveTime", DateConvertUtils.convertToString((Date)rs.getTimestamp("archiveTime"), (String)"yyyy.MM.dd HH:mm:ss"));
                    map.put("archiver", rs.getString("archiver"));
                    map.put("archiveDesc", rs.getString("archiveDesc"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, String>> getYysList() {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            sql.append(" select DISTINCT a.SUBBURO ,b.ORG_NAME from cisp_dev.dev_powersystemresource a left join cisp_sys.bp_org b on a.SUBBURO=b.ORG_NO ");
            sql.append(" where 1=1 and  a.CLASSNAME='EBikeChargeStation' ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("SUBBURO", rs.getString("SUBBURO"));
                    map.put("ORG_NAME", rs.getString("ORG_NAME"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public boolean updateWOById(String carrier, String relationType, String relationNo, String dispatchInfo, String id, String csworkorderType, String subburo, String loginname) {
        int result = 0;
        int results = 0;
        String handleNode = "30";
        String orgName = this.getOrgName(subburo);
        this.logger.debug(">>>>>>>>>>orgName1<<<<<<<<<" + orgName);
        this.logger.debug(">>>>>>>>>>subburo_no1<<<<<<<<<" + subburo);
        String yysname = this.getOrgName(carrier);
        StringBuilder sb = new StringBuilder();
        sb.append("\u7531    ").append(orgName).append("   \u6d3e\u5355\u7ed9     ").append(yysname).append("\u5904\u7406").append(";  ").append(dispatchInfo);
        try {
            SqlParamsBuilder sql1 = new SqlParamsBuilder();
            sql1.append(" select IFNULL(MAX(handleSn),0) as handleSn  from ebike.csc_workorder_handledetail where 1=1 ");
            sql1.append(" and csworkorderId = ?", (Object)id);
            this.logger.debug("+++++++updateWOById+sql1++++++" + sql1.toString());
            int no = (Integer)this.ebikeJdbcTemplate.queryForObject(sql1.getSql(), sql1.getParams(), Integer.class);
            no = no == 0 ? 1 : ++no;
            SqlParamsBuilder sql = new SqlParamsBuilder();
            sql.append(" insert into ebike.csc_workorder_handledetail ");
            sql.append(" (csworkorderId,handleSn,handleNode,nodeSubburo,handler,handleTime,handleDesc )");
            sql.append(" values(?,?,?,?,?,?,?)");
            this.logger.debug("+++++++updateWOById+sql++++++" + sql.toString());
            result = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{id, no, 20, subburo, orgName, new Date(), sb.toString()});
            SqlParamsBuilder sql2 = new SqlParamsBuilder();
            sql2.append(" update ebike.csc_workorder set ");
            sql2.append(" csworkorderStatus = ?", (Object)"20");
            sql2.append(" ,csworkorderNode = ?", (Object)handleNode);
            sql2.append(" ,nodeSubburo = ?", (Object)carrier);
            sql2.append(" ,relaObjectType = ?", (Object)relationType);
            if (!"".equals(relationType)) {
                this.logger.debug(">>>>>>>>>>><<dasdasdsad<<<<<<<" + relationType);
                if ("10".equals(relationType)) {
                    sql2.append(" ,chargeRecordId = ?", (Object)relationNo);
                    sql2.append(" ,needReturn = 'Y' ");
                } else if ("20".equals(relationType)) {
                    sql2.append(" ,chargedeviceNo = ?", (Object)relationNo);
                    sql2.append(" ,needReturn = 'N' ");
                } else {
                    sql2.append(" ,chargeplugNo = ?", (Object)relationNo);
                    sql2.append(" ,needReturn = 'N' ");
                }
            }
            sql2.append(" where 1=1 ");
            sql2.append(" and csworkorderId=? ", (Object)id);
            this.logger.debug("+++++++updateWOById+sql2++++++" + sql2.toString());
            results = this.ebikeJdbcTemplate.update(sql2.getSql(), sql2.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0 && results > 0;
    }

    @Override
    public Map<String, Object> getWorkOrderById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            sql.append(" select * from ebike.csc_workorder where 1=1 ");
            sql.append(" and csworkorderId = ?", (Object)id);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list != null || list.size() > 0) {
            return (Map)list.get(0);
        }
        return map;
    }

    @Override
    public boolean updateWorkorder_his(Map<String, Object> map, String info, String subbro, String name, String sftf) {
        int results = 0;
        try {
            SqlParamsBuilder sql1 = new SqlParamsBuilder();
            sql1.append(" insert into ebike.csc_workorder_his ");
            sql1.append(" (csworkorderId,csworkorderType,csworkorderStatus,chargeUserId,commitTime,csworkorderDesc,csworkorderAttach,archiver");
            sql1.append(" ,archiveTime,archiveDesc,needReturn,returnHandleResult,relaObjectType,chargeRecordId,chargedeviceNo,chargeplugNo, ");
            sql1.append(" chargestationNo,chargestationName,chargestationAddr,orgNo,orgName,oppersonName,oppersonMobile )");
            sql1.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql1.getSql(), new Object[]{map.get("csworkorderId"), map.get("csworkorderType"), 40, map.get("chargeUserId"), map.get("commitTime"), map.get("csworkorderDesc"), map.get("csworkorderAttach"), name, new Date(), info, map.get("needReturn"), sftf, map.get("relaObjectType"), map.get("chargeRecordId"), map.get("chargedeviceNo"), map.get("chargeplugNo"), map.get("chargestationNo"), map.get("chargestationName"), map.get("chargestationAddr"), map.get("orgNo"), map.get("orgName"), map.get("oppersonName"), map.get("oppersonMobile")});
            SqlParamsBuilder sql = new SqlParamsBuilder();
            sql.append(" delete from ebike.csc_workorder where 1=1 ");
            sql.append(" and csworkorderId= ?", (Object)map.get("csworkorderId").toString());
            int result = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            this.logger.debug(">>>>>>>>>>>>updateWorkorder_his<<<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    public String getOrgName(String org_no) {
        String yysName = "";
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" select  ORG_NAME  from cisp_sys.bp_org   where 1=1 ");
        sql.append(" and ORG_NO = ? ", (Object)org_no);
        this.logger.debug("+++++++++++++getOrgName+++++++++++++++++" + sql.toString());
        yysName = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        return yysName;
    }

    @Override
    public String getMoneyByOrder(String orderNo) throws EmptyResultDataAccessException {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String money = "";
        try {
            sql.append(" select (chargeMoney-totalReturnMoney)  as money from ebike.ebike_chargerecord_his where 1=1 ");
            sql.append(" and chargeRecordId = ?", (Object)orderNo);
            this.logger.debug("+++++++++++++getMoneyByOrder+++++++++++++++++" + sql.toString());
            double money1 = (Double)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Object.class);
            money = String.valueOf(money1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return money;
        }
        return money;
    }

    @Override
    public boolean handlingSuggestion(String id, String R_apply, String subburo, String returnHandleResult) {
        int results = 0;
        int result = 0;
        StringBuilder sb = new StringBuilder();
        try {
            String yysname = this.getOrgName(subburo);
            this.logger.debug(">>>>>>>>>>orgName2<<<<<<<<<" + yysname);
            this.logger.debug(">>>>>>>>>>subburo_no2<<<<<<<<<" + subburo);
            SqlParamsBuilder sql1 = new SqlParamsBuilder();
            sql1.append(" select IFNULL(MAX(handleSn),0) as handleSn  from ebike.csc_workorder_handledetail where 1=1 ");
            sql1.append(" and csworkorderId = ?", (Object)id);
            this.logger.debug("+++++++++++++handlingSuggestion+sql1++++++++++++++++" + sql1.toString());
            int No = (Integer)this.ebikeJdbcTemplate.queryForObject(sql1.getSql(), sql1.getParams(), Integer.class);
            No = No == 0 ? 1 : ++No;
            SqlParamsBuilder sql = new SqlParamsBuilder();
            String reply = "\u7531\u5e73\u53f0\u5904\u7406\u56de\u590d;" + R_apply;
            sb.append(reply);
            sql.append(" insert into ebike.csc_workorder_handledetail ");
            sql.append(" (csworkorderId,handleSn,handleNode,nodeSubburo,handler,handleTime,handleDesc )");
            sql.append(" values(?,?,?,?,?,?,?)");
            this.logger.debug("+++++++++++++handlingSuggestion+sql++++++++++++++++" + sql.toString());
            result = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{id, No, 20, subburo, yysname, new Date(), sb.toString()});
            SqlParamsBuilder sql2 = new SqlParamsBuilder();
            sql2.append(" update ebike.csc_workorder set ");
            sql2.append(" csworkorderNode='10' ");
            sql2.append(" ,csworkorderStatus='20' ");
            sql2.append(" ,returnHandleResult=? ", (Object)returnHandleResult);
            sql2.append(" where 1=1 ");
            sql2.append(" and csworkorderId = ?", (Object)id);
            this.logger.debug("+++++++++++++handlingSuggestion+sql2++++++++++++++++" + sql2.toString());
            results = this.ebikeJdbcTemplate.update(sql2.getSql(), sql2.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0;
    }

    @Override
    public boolean tkSuggestion(String id, String R_apply, String R_sftf, String subburo, String org_name, String R_money) {
        int result = 0;
        boolean flag = false;
        StringBuilder sb = new StringBuilder();
        try {
            String yysname = this.getOrgName(subburo);
            SqlParamsBuilder sql1 = new SqlParamsBuilder();
            sql1.append(" select IFNULL(MAX(handleSn),0) as handleSn  from ebike.csc_workorder_handledetail where 1=1 ");
            sql1.append(" and csworkorderId = ?", (Object)id);
            this.logger.debug("+++++++++++++tkSuggestion+sql1++++++++++++++++" + sql1.toString());
            int No = (Integer)this.ebikeJdbcTemplate.queryForObject(sql1.getSql(), sql1.getParams(), Integer.class);
            No = No == 0 ? 1 : ++No;
            SqlParamsBuilder sql = new SqlParamsBuilder();
            if (R_sftf.equals("Y")) {
                sb.append(" \u7531\u5e73\u53f0\u5904\u7406\u56de\u590d ;").append("\u9000\u8d39").append(R_money).append("\u5143").append("; ").append(R_apply);
            } else {
                sb.append(" \u7531\u5e73\u53f0\u5904\u7406\u56de\u590d ;").append(R_apply);
            }
            sql.append(" insert into ebike.csc_workorder_handledetail ");
            sql.append(" (csworkorderId,handleSn,handleNode,nodeSubburo,handler,handleTime,handleDesc )");
            sql.append(" values(?,?,?,?,?,?,?)");
            this.logger.debug("+++++++++++++tkSuggestion+sql++++++++++++++++" + sql.toString());
            result = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{id, No, 20, subburo, yysname, new Date(), sb.toString()});
            Map<String, Object> map = this.getWorkOrderById(id);
            this.logger.debug(">>>>>>>>>needReturn<<<<<<<<<<<<" + map.get("needReturn"));
            String archiveInfo = " \u7531\u5e73\u53f0\u5f52\u6863; " + R_apply;
            flag = this.updateWorkorder_his(map, archiveInfo, subburo, org_name, R_sftf);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0 && flag;
    }

    @Override
    public String getWoNodeById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String csworkorderNode = "";
        try {
            sql.append(" select csworkorderNode from ebike.csc_workorder where 1=1 ");
            sql.append(" and csworkorderId= ?", (Object)id);
            this.logger.debug("+++++++++++++++getWoNodeById++++++++++++++++++++" + sql.toString());
            csworkorderNode = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            return csworkorderNode;
        }
        return csworkorderNode;
    }

    @Override
    public String getButtonFlag(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String flag = "";
        try {
            sql.append(" select IFNULL(max(handler),'1') from ebike.csc_workorder_handledetail where 1=1  ");
            sql.append(" and csworkorderId= ?", (Object)id);
            this.logger.debug("+++++++++++++++getWoNodeById++++++++++++++++++++" + sql.toString());
            flag = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            return flag;
        }
        return flag;
    }

    public String getHandler(String loginname) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String handler = "";
        try {
            sql.append(" select user_name from  cisp_sys.bp_user where 1=1 ");
            sql.append(" and user_no=?", (Object)loginname);
            this.logger.debug(">>>>>>>>>>>>>>getHandler<<<<<<<<<<<<<" + sql.toString());
            handler = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return handler;
        }
        return handler;
    }
}

