/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.cscmgmt.serviceImpl;

import com.easesource.data.id.generator.IdGenerator;
import com.ebike.openservices.cscmgmt.constant.CarServiceConstant;
import com.ebike.openservices.cscmgmt.dao.CarDao;
import com.ebike.openservices.cscmgmt.service.CarCustomerService;
import com.ebike.openservices.cscmgmt.vo.CarExcelTemplate;
import com.ebike.openservices.cscmgmt.vo.CarServiceOrgVo;
import com.ebike.openservices.cscmgmt.vo.CustomerCarInfoVo;
import com.ebike.openservices.cscmgmt.vo.CustomerInfoVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CarCustomerServiceImpl
implements CarCustomerService {
    @Resource(name="idGenerator")
    protected IdGenerator idGenerator;
    @Resource
    private CarDao carDao;

    public Map<Integer, String> getCustomerTypes() {
        return new HashMap<Integer, String>(CarServiceConstant.CUSTOMER_TYPE);
    }

    public List<CarServiceOrgVo> getOrgs() {
        return this.carDao.selectOrgs();
    }

    public List<CustomerInfoVo> searchCustomer(String orgNo, String name, String phone, String type, String card, String vin, int current, int size) {
        current = (current - 1) * size;
        List<CustomerInfoVo> data = null;
        data = "10".equals(orgNo) ? this.carDao.searchCustomerAll(name, phone, type, card, vin, current, size) : this.carDao.searchCustomer(orgNo, name, phone, type, card, vin, current, size);
        if (data == null) {
            return null;
        }
        data.forEach(bean -> {
            bean.setCustomerTypeStr(CarServiceConstant.CUSTOMER_TYPE.get(bean.getCustomerType()));
            List<CarExcelTemplate> cars = this.carDao.selectCars(orgNo, String.valueOf(bean.getId()));
            if (cars == null || cars.size() == 0) {
                bean.setExistCar(Integer.valueOf(0));
            } else {
                bean.setExistCar(Integer.valueOf(1));
            }
        });
        return data;
    }

    public void addCustomer(CustomerInfoVo bean) {
        this.carDao.insertCustomer(bean);
    }

    public String queryCustomerById(String orgNo, String id) {
        return this.carDao.selectCustomerById(orgNo, id);
    }

    public String queryCustomerByCustomerNo(String orgNo, String customerNo) {
        return this.carDao.selectCustomerByCustomerNo(orgNo, customerNo);
    }

    public String queryCurrentOrderByCustomerId(String orgNo, String customerId) {
        return this.carDao.selectCurrentOrderByCustomerId(orgNo, customerId);
    }

    public String queryHistoryOrderByCustomerId(String orgNo, String customerId) {
        return this.carDao.selectHistoryOrderByCustomerId(orgNo, customerId);
    }

    public void logicalDeleteCustomerById(String orgNo, String userNo, String id) {
        this.carDao.logicalDeleteCustomerById(orgNo, userNo, id);
    }

    public void delCustomerByOrgno(String orgNo) {
        this.carDao.delCustomerByOrgno(orgNo);
    }

    public void updateCustomerById(String orgNo, String id, String name, String account, String phone, String type) {
        this.carDao.updateCustomerById(orgNo, id, name, account, phone, type);
    }

    public Map<String, Object> searchCar(String orgNo, String customerId, String card, String vin, int current, int size) {
        current = (current - 1) * size;
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if ("10".equals(orgNo)) {
            orgNo = null;
        }
        int total = this.carDao.carCount(orgNo, customerId, card, vin);
        result.put("total", total);
        List<CustomerCarInfoVo> data = this.carDao.searchCar(orgNo, customerId, card, vin, current, size);
        result.put("record", data);
        return result;
    }

    public void addCar(CustomerCarInfoVo car) {
        this.carDao.insertCar(car);
    }

    public String queryCarByCustomerId(String orgNo, String customerId) {
        return this.carDao.selectCarByCustomerId(orgNo, customerId);
    }

    public List<CarExcelTemplate> queryCars(String orgNo, String customerId) {
        return this.carDao.selectCars(orgNo, customerId);
    }

    public int queryCarCount(String orgNo, String customerId, String card, String vin) {
        return this.carDao.carCount(orgNo, customerId, card, vin);
    }

    public void updateCarById(String orgNo, String id, String card, String vin) {
        this.carDao.updateCarById(orgNo, id, card, vin);
    }

    public void delCarByCustomerId(String orgNo, String customerId) {
        this.carDao.delCarByCustomerId(orgNo, customerId);
    }

    public void delCarById(String orgNo, String id) {
        this.carDao.delCarById(orgNo, id);
    }

    public int customerCountAll(String name, String phone, String type, String card, String vin) {
        return this.carDao.customerCountAll(name, phone, type, card, vin);
    }

    public int customerCount(String orgNo, String name, String phone, String type, String card, String vin) {
        return this.carDao.customerCount(orgNo, name, phone, type, card, vin);
    }
}

