/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.cscmgmt.serviceImpl;

import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.cscmgmt.dao.CustomerWorkOrderDao;
import com.ebike.openservices.cscmgmt.request.CustomerAddRequest;
import com.ebike.openservices.cscmgmt.request.CustomerHisAddRequest;
import com.ebike.openservices.cscmgmt.request.CustomerRequest;
import com.ebike.openservices.cscmgmt.request.DeviceQueryRequest;
import com.ebike.openservices.cscmgmt.response.BpCodeResponse;
import com.ebike.openservices.cscmgmt.response.CustomerQueryResponse;
import com.ebike.openservices.cscmgmt.response.DeviceQueryResponse;
import com.ebike.openservices.cscmgmt.service.CustomerWorkOrderService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerWorkOrderImpl
extends AbstractEbikeBaseService
implements CustomerWorkOrderService {
    @Resource
    private CustomerWorkOrderDao customerWorkOrderDao;

    public Map<String, Object> queryCustomerList(CustomerRequest customerRequest) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List<CustomerQueryResponse> list = this.customerWorkOrderDao.queryCustomerList(customerRequest);
        list.forEach(response -> {
            String csCheckinInfo = response.getCsCheckinInfo();
            Map map = (Map)JsonConvertUtils.convertFromString((String)csCheckinInfo, Map.class);
            if (map != null) {
                response.setCallTime(ObjectUtils.toStringDefaultEmpty(map.get("callTime")));
                response.setPhoneNo(ObjectUtils.toStringDefaultEmpty(map.get("phoneNo")));
                response.setPlugSn(ObjectUtils.toStringDefaultEmpty(map.get("plugSn")));
                response.setChargePayMode(ObjectUtils.toStringDefaultEmpty(map.get("chargePayMode")));
                response.setRemark(ObjectUtils.toStringDefaultEmpty(map.get("remark")));
                response.setChargestationNameInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargestationName")));
                response.setChargedeviceNoInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargedeviceNo")));
            }
        });
        int total = this.customerWorkOrderDao.queryCustomerListTotal(customerRequest);
        resultMap.put("list", list);
        resultMap.put("total", total);
        return resultMap;
    }

    public Map<String, Object> queryDeviceList(DeviceQueryRequest deviceQueryRequest) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List<DeviceQueryResponse> list = this.customerWorkOrderDao.queryDeviceList(deviceQueryRequest);
        Integer type = deviceQueryRequest.getType();
        Integer total = 0;
        List<Integer> totals = this.customerWorkOrderDao.queryDeviceListTotal(deviceQueryRequest);
        total = type == 1 && totals != null ? Integer.valueOf(totals.get(0) + totals.get(1)) : totals.get(0);
        resultMap.put("list", list);
        resultMap.put("total", total);
        return resultMap;
    }

    public int addCustomer(CustomerAddRequest customerAddRequest) {
        return this.customerWorkOrderDao.addCustomer(customerAddRequest);
    }

    public String queryChargeUserIdByPhone(String phone) {
        return this.customerWorkOrderDao.queryChargeUserIdByPhone(phone);
    }

    public int updateCustomer(CustomerAddRequest customerAddRequest) {
        return this.customerWorkOrderDao.updateCustomer(customerAddRequest);
    }

    public int deleteCustomer(List<String> idList) {
        return this.customerWorkOrderDao.deleteCustomer(idList);
    }

    public CustomerQueryResponse queryCustomerDetails(String csworkorderId) {
        CustomerQueryResponse response = this.customerWorkOrderDao.queryCustomerDetails(csworkorderId);
        String csCheckinInfo = response.getCsCheckinInfo();
        Map map = (Map)JsonConvertUtils.convertFromString((String)csCheckinInfo, Map.class);
        if (map != null) {
            response.setCallTime(ObjectUtils.toStringDefaultEmpty(map.get("callTime")));
            response.setPhoneNo(ObjectUtils.toStringDefaultEmpty(map.get("phoneNo")));
            response.setPlugSn(ObjectUtils.toStringDefaultEmpty(map.get("plugSn")));
            response.setChargePayMode(ObjectUtils.toStringDefaultEmpty(map.get("chargePayMode")));
            response.setRemark(ObjectUtils.toStringDefaultEmpty(map.get("remark")));
            response.setChargestationNameInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargestationName")));
            response.setChargedeviceNoInfo(ObjectUtils.toStringDefaultEmpty(map.get("chargedeviceNo")));
        }
        return response;
    }

    @Transactional
    public int updateAndInsertCustomer(CustomerHisAddRequest customerHisAddRequest) {
        this.customerWorkOrderDao.updateCustomerOnFile(customerHisAddRequest);
        return this.customerWorkOrderDao.addCustomerHis(customerHisAddRequest);
    }

    public List<BpCodeResponse> queryCode(BpCodeResponse bpCodeResponse) {
        return this.customerWorkOrderDao.queryCode(bpCodeResponse);
    }
}

