package com.ebike.openservices.dbmigration.entity;

import java.util.Date;

import lombok.Data;

import java.io.Serializable;

/**
 * (EbikeChargeplugOpsDbDo)实体类
 *
 * @author ghl
 * @since 2020-05-13 11:10:25
 */
@Data
public class EbikeChargeplugOpsDbDo implements Serializable {
    private static final long serialVersionUID = -47012673778840626L;
    /**
     * 充电插座标识
     */
    private Long chargeplugId;
    /**
     * 运行状态：0 - 空闲；1 - 正在使用；2 - 已被预订；9 – 不可用（设备离线）；
     */
    private String opStatus;
    /**
     * 运行状态更新时间
     */
    private Date opStatusTime;
    /**
     * 首次充电结束时间
     */
    private Date firstChargeFinishTime;
    /**
     * 首次充电时长，单位：分钟
     */
    private Double firstChargeTtlDur;
    /**
     * 最近一次充电结束时间
     */
    private Date latestChargeFinishTime;
    /**
     * 最近一次充电时长，单位：分钟
     */
    private Double latestChargeTtlDur;
    /**
     * 当前日期
     */
    private Date currentDate;
    /**
     * 当日累计充电次数
     */
    private Integer currDayCumCrgCnt;
    /**
     * 当月累计充电次数
     */
    private Integer currMonthCumCrgCnt;
    /**
     * 当年累计充电次数
     */
    private Integer currYearCumCrgCnt;
    /**
     * 累计充电次数
     */
    private Integer cumCrgCnt;


}
