package com.ebike.openservices.dbmigration.entity;

import java.util.Date;

import lombok.Data;

import java.io.Serializable;

/**
 * 当前充电记录，每15分更新充电量、使用量、剩余量、使用电量等；(EbikeChargerecordDbDo)实体类
 *
 * @author ghl
 * @since 2020-05-13 10:07:41
 */
@Data
public class EbikeChargerecordDbDo implements Serializable {
    private static final long serialVersionUID = 651063642468163079L;
    /**
     * 充电记录标识，UUID
     */
    private String chargeRecordId;
    /**
     * 充电插座标识
     */
    private Long chargeplugId;
    /**
     * 充电设备标识
     */
    private Long chargedeviceId;
    /**
     * 充电站标识
     */
    private Long chargestationId;
    /**
     * 充电用户标识
     */
    private String chargeUserId;
    /**
     * 充电时间
     */
    private Date chargeTime;
    /**
     * 充电支付方式：
     * 1 – 扫码支付（微信/支付宝）；
     * 2 – 投币支付；
     * 3 – 刷卡支付；
     */
    private Integer chargePayMode;
    /**
     * 充电金额，单位：元
     */
    private Double chargeMoney;
    /**
     * 投币金额，单位：元
     */
    private Double coinMoney;
    /**
     * 刷卡卡号
     */
    private String cardId;
    /**
     * 充电交易订单ID
     */
    private String chargeTradeOrderId;
    /**
     * 入账账户类型
     */
    private String enterUserType;
    /**
     * 入账账户标识
     */
    private String enterUserId;
    /**
     * 服务费率，单位：%
     */
    private Double serviceRate;
    /**
     * 计费方案标识
     */
    private String schemeId;
    /**
     * 计费方案类型：01 - 计时间；02 - 计电量；
     */
    private String schemeType;
    /**
     * 计费单价1
     */
    private Double unitPrice1;
    /**
     * 计费单价2
     */
    private Double unitPrice2;
    /**
     * 计费单价3
     */
    private Double unitPrice3;
    /**
     * 计费单价4
     */
    private Double unitPrice4;
    /**
     * 计费单价5
     */
    private Double unitPrice5;
    /**
     * 功率阶梯数，最大为5个阶梯
     */
    private Integer stepCount;
    /**
     * 阶梯功率1，单位为W
     */
    private Integer stepPower1;
    /**
     * 阶梯功率2，单位为W
     */
    private Integer stepPower2;
    /**
     * 阶梯功率3，单位为W
     */
    private Integer stepPower3;
    /**
     * 阶梯功率4，单位为W
     */
    private Integer stepPower4;
    /**
     * 最低消费金额：单位为元
     */
    private Double minCharge;
    /**
     * 是否退费：Y是 N否
     */
    private String isReturn;
    /**
     * 计费结算周期，单位为分钟
     */
    private Integer closingPeriod;
    /**
     * 电费成本方案标识
     */
    private String costSchemeId;
    /**
     * 电费成本单价：单位为元/kWh
     */
    private Double costUnitPrice;
    /**
     * 充电开启标志：
     * 为1表示充电等待中（等待主站回应）；
     * 为0表示充电开启成功；
     * 为负表示充电开启失败；
     * -1表示设备总体已经超过最大功率；
     */
    private Integer chargeOpenFlag;
    /**
     * 充电开启时间
     */
    private Date chargeOpenTime;
    /**
     * 重新开启标记：Y / N / L
     */
    private String reopeningFlag;
    /**
     * 重新开启次数
     */
    private Integer reopens;
    /**
     * 初始计费单价标记：1 – unitPrice1；2 – unitPrice2；3 – unitPrice3；4 – unitPrice4；5 – unitPrice5；
     */
    private Integer firstUnitPriceFlag;
    /**
     * 初次充电量
     */
    private Double firstChargeAmount;
    /**
     * 当前计费单价标记：1 – unitPrice1；2 – unitPrice2；3 – unitPrice3；4 – unitPrice4；5 – unitPrice5；
     */
    private Integer currUnitPriceFlag;
    /**
     * 充电量
     */
    private Double chargeAmount;
    /**
     * 使用量
     */
    private Double usageAmount;
    /**
     * 剩余量
     */
    private Double surplusAmount;
    /**
     * 使用电量：单位为kWh
     */
    private Double usageElecCons;
    /**
     * 剩余充电电量：单位为kWh
     */
    private Double remainElecCons;
    /**
     * 剩余充电时间：单位为分钟
     */
    private Double remainTime;
    /**
     * 当前功率：单位为kW
     */
    private Double curPower;
    /**
     * 最大功率：单位为kW
     */
    private Double maxPower;
    /**
     * 最大功率发生时间
     */
    private Date maxPowerTime;
    /**
     * 最小功率：单位为kW
     */
    private Double minPower;
    /**
     * 最小功率发生时间
     */
    private Date minPowerTime;
    /**
     * 平均功率：单位为kW
     */
    private Double avgPower;
    /**
     * 统计功率点数
     */
    private Integer statPowerCount;
    /**
     * 更新时间
     */
    private Date updateTime;


}
