package com.ebike.openservices.dbmigration.entity;

import java.util.Date;

import lombok.Data;

import java.io.Serializable;

/**
 * 历史充电记录(EbikeChargerecordHisDbDo)实体类
 *
 * @author ghl
 * @since 2020-05-13 10:19:17
 */
@Data
public class EbikeChargerecordHisDbDo implements Serializable {
    private static final long serialVersionUID = -31308454713666342L;
    /**
     * 充电记录标识，UUID
     */
    private String chargeRecordId;
    /**
     * 充电插座标识
     */
    private Long chargeplugId;
    /**
     * 充电设备标识
     */
    private Long chargedeviceId;
    /**
     * 充电站标识
     */
    private Long chargestationId;
    /**
     * 充电用户标识
     */
    private String chargeUserId;
    /**
     * 充电时间
     */
    private Date chargeTime;
    /**
     * 充电支付方式：
     * 1 – 扫码支付（微信/支付宝）；
     * 2 – 投币支付；
     * 3 – 刷卡支付；
     */
    private Integer chargePayMode;
    /**
     * 充电金额，单位：元
     */
    private Double chargeMoney;
    /**
     * 投币金额，单位：元
     */
    private Double coinMoney;
    /**
     * 刷卡卡号
     */
    private String cardId;
    /**
     * 充电交易订单ID
     */
    private String chargeTradeOrderId;
    /**
     * 入账账户类型
     */
    private String enterUserType;
    /**
     * 入账账户标识
     */
    private String enterUserId;
    /**
     * 服务费率，单位：%
     */
    private Double serviceRate;
    /**
     * 计费方案标识
     */
    private String schemeId;
    /**
     * 计费方案类型：01 - 计时间；02 - 计电量；
     */
    private String schemeType;
    /**
     * 计费单价1
     */
    private Double unitPrice1;
    /**
     * 计费单价2
     */
    private Double unitPrice2;
    /**
     * 计费单价3
     */
    private Double unitPrice3;
    /**
     * 计费单价4
     */
    private Double unitPrice4;
    /**
     * 计费单价5
     */
    private Double unitPrice5;
    /**
     * 功率阶梯数，最大为5个阶梯
     */
    private Integer stepCount;
    /**
     * 阶梯功率1，单位为W
     */
    private Integer stepPower1;
    /**
     * 阶梯功率2，单位为W
     */
    private Integer stepPower2;
    /**
     * 阶梯功率3，单位为W
     */
    private Integer stepPower3;
    /**
     * 阶梯功率4，单位为W
     */
    private Integer stepPower4;
    /**
     * 最低消费金额，单位为元
     */
    private Double minCharge;
    /**
     * 是否退费：Y是 N否
     */
    private String isReturn;
    /**
     * 计费结算周期，单位为分钟
     */
    private Integer closingPeriod;
    /**
     * 电费成本方案标识
     */
    private String costSchemeId;
    /**
     * 电费成本单价：单位为元/kWh
     */
    private Double costUnitPrice;
    /**
     * 充电开启标志：
     * 为0表示充电开启成功；
     * 为负表示充电开启失败；
     * -1表示设备总体已经超过最大功率；
     */
    private Integer chargeOpenFlag;
    /**
     * 充电开启时间
     */
    private Date chargeOpenTime;
    /**
     * 重新开启标记：Y / N / L
     */
    private String reopeningFlag;
    /**
     * 重新开启次数
     */
    private Integer reopens;
    /**
     * 充电结束时间
     */
    private Date chargeFinishTime;
    /**
     * 充电结束原因：0 - 电量用完停止充电；1 - 浮充时间完成停止充电；2 - 插头拔掉停止充电；3 - 功率超限停止充电；4 - 计时时间到停止充电；
     */
    private String finishReason;
    /**
     * 充电结束功率：单位为kW
     */
    private Double finishPower;
    /**
     * 初始计费单价标记：1 – unitPrice1；2 – unitPrice2；3 – unitPrice3；4 – unitPrice4；5 – unitPrice5；
     */
    private Integer firstUnitPriceFlag;
    /**
     * 初次充电量
     */
    private Double firstChargeAmount;
    /**
     * 当前计费单价标记：1 – unitPrice1；2 – unitPrice2；3 – unitPrice3；4 – unitPrice4；5 – unitPrice5；
     */
    private Integer currUnitPriceFlag;
    /**
     * 充电量
     */
    private Double chargeAmount;
    /**
     * 使用量
     */
    private Double usageAmount;
    /**
     * 剩余量
     */
    private Double surplusAmount;
    /**
     * 使用电量：单位为kWh
     */
    private Double usageElecCons;
    /**
     * 剩余充电电量：单位为kWh
     */
    private Double remainElecCons;
    /**
     * 剩余充电时间：单位为分钟
     */
    private Double remainTime;
    /**
     * 最大功率：单位为kW
     */
    private Double maxPower;
    /**
     * 最大功率发生时间
     */
    private Date maxPowerTime;
    /**
     * 最小功率：单位为kW
     */
    private Double minPower;
    /**
     * 最小功率发生时间
     */
    private Date minPowerTime;
    /**
     * 平均功率：单位为kW
     */
    private Double avgPower;
    /**
     * 统计功率点数
     */
    private Integer statPowerCount;
    /**
     * 结算标记：Y已结算 N未结算
     */
    private String closingFlag;
    /**
     * 结算金额
     */
    private Double closingMoney;
    /**
     * 结算时间
     */
    private Date closingTime;
    /**
     * 退费标记：Y已退费 N未退费
     */
    private String returnFlag;
    /**
     * 退费金额
     */
    private Double returnMoney;
    /**
     * 退费时间
     */
    private Date returnTime;
    /**
     * 退费说明
     */
    private String returnDesc;
    /**
     * 退费交易订单ID
     */
    private String returnTradeOrderId;
    /**
     * 退费成功时间
     */
    private Date returnSuccessTime;
    /**
     * 收入：单位为元
     */
    private Double income;
    /**
     * 成本：单位为元
     */
    private Double cost;
    /**
     * 利润：单位为元
     */
    private Double profit;
    /**
     * 服务费：单位为元
     */
    private Double serviceMoney;
    /**
     * 收入（除去服务费）：单位为元
     */
    private Double incomeExService;
    /**
     * 利润（除去服务费）：单位为元
     */
    private Double profitExService;
    /**
     * 服务费收取标记：S收取成功 F收取失败
     */
    private String serviceFlag;
    /**
     * 服务费收取时间
     */
    private Date serviceTime;
    /**
     * 服务费收取说明
     */
    private String serviceDesc;
    /**
     * 服务费交易订单ID
     */
    private String serviceTradeOrderId;
    /**
     * 服务费收取成功时间
     */
    private Date serviceSuccessTime;
    /**
     * 备注
     */
    private String remark;
    /**
     * 是否申请退款
     */
    private String isCsRefund;
    /**
     * 退款申请客服工单标识
     */
    private String csworkorderId;
    /**
     * 退款申请处理结果
     */
    private String csrefundResult;
    /**
     * 退款申请处理金额
     */
    private Double csrefundMoney;
    /**
     * 退款申请处理时间
     */
    private Date csrefundTime;
    /**
     * 退款申请交易订单ID
     */
    private String csrefundTradeOrderId;
    /**
     * 总退款金额
     */
    private Double totalReturnMoney;


}
