package com.ebike.openservices.dbmigration.entity;

import java.util.Date;

import lombok.Data;

import java.io.Serializable;

/**
 * 历史充电记录收入分配明细(EbikeChargerecordIncomedetailDbDo)实体类
 *
 * @author ghl
 * @since 2020-05-13 10:31:27
 */
@Data
public class EbikeChargerecordIncomedetailDbDo implements Serializable {
    private static final long serialVersionUID = -49372765397946600L;
    /**
     * 充电记录标识
     */
    private String chargeRecordId;
    /**
     * 分配序号
     */
    private Integer distSn;
    /**
     * 分配账户类型
     */
    private String distUserType;
    /**
     * 分配账户标识
     */
    private String distUserId;
    /**
     * 分配比例，单位：%
     */
    private Double distRatio;
    /**
     * 分配金额，单位：元
     */
    private Double distMoney;
    /**
     * 分配时间
     */
    private Date distTime;
    /**
     * 分配说明
     */
    private String distDesc;
    /**
     * 分配标记，S 分配成功；F 分配失败；
     */
    private String distFlag;
    /**
     * 分配交易订单ID
     */
    private String distTradeOrderId;
    /**
     * 分配成功时间
     */
    private Date distSuccessTime;
    /**
     * 退款申请处理结果，S 退款成功；F 退款失败；
     */
    private String csrefundResult;
    /**
     * 退款申请处理金额，单位：元
     */
    private Double csrefundMoney;
    /**
     * 退款申请处理时间
     */
    private Date csrefundTime;
    /**
     * 退款申请交易订单ID
     */
    private String csrefundTradeOrderId;
    /**
     * 退款成功时间
     */
    private Date csrefundSuccessTime;


}
