package com.ebike.openservices.dbmigration.entity;

import java.util.Date;

import lombok.Data;

import java.io.Serializable;

/**
 * (EbikeChargeuserDbDo)实体类
 *
 * @author ghl
 * @since 2020-05-13 11:15:30
 */
@Data
public class EbikeChargeuserDbDo implements Serializable {
    private static final long serialVersionUID = -75698396786249967L;
    /**
     * 充电用户标识，UUID
     */
    private String chargeUserId;
    /**
     * 充电用户名：
     * 如为“微信用户“，则充电用户名为微信标识；
     * 如为“卡用户“，则充电用户名为卡号；
     */
    private String chargeUserNo;
    /**
     * 微信token，访问微信接口需要此token，需要时更新
     */
    private String chargeUserToken;
    /**
     * 充电用户类型：10 - 微信用户；20 - 支付宝；90 - 投币用户；
     */
    private String chargeUserType;
    /**
     * 充电用户名称
     */
    private String chargeUserName;
    /**
     * 充电用户密码
     */
    private String chargeUserPasswd;
    /**
     * 充电用户手机号码
     */
    private String chargeUserMobile;
    /**
     * 是否有效，T - 是；F - 否
     */
    private String valid;
    /**
     * 注册时间
     */
    private Date regTime;
    /**
     * 生效时间
     */
    private Date effTime;
    /**
     * 所属商户号，sy - 数元；yz - 原智；zfb - 原智支付宝；
     */
    private String merchantNo;

    private String unionId;


}
