package com.ebike.openservices.dbmigration.service.impl;

import com.ebike.openservices.dbmigration.ebikedbsrc.dao.EbikeebikedbsrcDao;
import com.ebike.openservices.dbmigration.ebikedbtgt.dao.EbikeebikedbtgtDao;
import com.ebike.openservices.dbmigration.entity.*;
import com.ebike.openservices.dbmigration.service.EbikeDbDService;
import com.ebike.openservices.dbmigration.util.DateUti;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author ghl
 */
@Service
public class EbikeDbDServiceImpl implements EbikeDbDService {


    /**
     * 数据查询接口
     */
    @Resource
    private EbikeebikedbsrcDao ebikeebikedbsrcDao;

    /**
     * 数据插入接口
     */
    @Resource
    private EbikeebikedbtgtDao ebikeebikedbtgtDao;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * 数据同步方法
     *
     * @param dateTime
     * @return
     */
    @Override
    public void startDbMigrate(String dateTime) {


        try {
            EbikeDbVo vo = new EbikeDbVo();
            vo.setDateTime(dateTime);
            selectEbikeChargedeviceOpsDbDoList(vo);
        } catch (Exception e) {
            logger.error("selectEbikeChargedeviceOpsDbDoList error:{}", e.getMessage());
        }

        try {
            EbikeDbVo vo = new EbikeDbVo();
            vo.setDateTime(dateTime);
            selectEbikeChargeplugOpsDbDoList(vo);
        } catch (Exception e) {
            logger.error("selectEbikeChargeplugOpsDbDoList error:{}", e.getMessage());
        }

        try {
            EbikeDbVo vo = new EbikeDbVo();
            vo.setDateTime(dateTime);
            selectEbikeChargerecordDbDoList(vo);
        } catch (Exception e) {
            logger.error("selectEbikeChargerecordDbDoList error:{}", e.getMessage());
        }

        try {
            EbikeDbVo vo = new EbikeDbVo();
            vo.setDateTime(dateTime);
            selectEbikeChargerecordHisDbDoList(vo);
        } catch (Exception e) {
            logger.error("selectEbikeChargerecordHisDbDoList error:{}", e.getMessage());
        }

        try {
            EbikeDbVo vo = new EbikeDbVo();
            vo.setDateTime(dateTime);
            selectEbikeChargerecordIncomedetailDbDoList(vo);
        } catch (Exception e) {
            logger.error("selectEbikeChargerecordIncomedetailDbDoList error:{}", e.getMessage());
        }

        System.out.println("-------");
    }

    /**
     * 15.1	充电设备当前工况
     *
     * @param vo
     * @return
     */
    private void selectEbikeChargedeviceOpsDbDoList(EbikeDbVo vo) {
        String dateTime = vo.getDateTime();
        // 获取前8分钟的时间 latestCommTime firstChargeFinishTime latestChargeFinishTime
        String beforeTime = DateUti.durationMinutes(dateTime, -8);
        vo.setLatestChargeFinishTime(beforeTime);
        vo.setFirstChargeFinishTime(beforeTime);
        vo.setLatestCommTime(beforeTime);
        List<EbikeChargedeviceOpsDbDo> list = ebikeebikedbsrcDao.selectEbikeChargedeviceOpsDbDoList(vo);
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            insertOrUpdateEbikeChargedeviceOpsDbDoList(list);
        }
    }

    /**
     * 15.1	充电设备当前工况
     *
     * @param list
     * @return
     */
    private void insertOrUpdateEbikeChargedeviceOpsDbDoList(List<EbikeChargedeviceOpsDbDo> list) {

        if (list != null && list.size() > 0) {
            ebikeebikedbtgtDao.insertOrUpdateEbikeChargedeviceOpsDbDoList(list);
        }
    }

    /**
     * 15.2	充电插座当前工况
     *
     * @param vo
     * @return
     */
    private void selectEbikeChargeplugOpsDbDoList(EbikeDbVo vo) {

        String dateTime = vo.getDateTime();
        // 获取前8分钟的时间
        String beforeTime = DateUti.durationMinutes(dateTime, -8);
        vo.setOpStatusTime(beforeTime);
        List<EbikeChargeplugOpsDbDo> list = ebikeebikedbsrcDao.selectEbikeChargeplugOpsDbDoList(vo);
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            insertOrUpdateEbikeChargeplugOpsDbDoList(list);
        }
    }

    /**
     * 批量插入
     *
     * @param list
     * @return
     */
    private void insertOrUpdateEbikeChargeplugOpsDbDoList(List<EbikeChargeplugOpsDbDo> list) {
        if (list != null && list.size() > 0) {
            ebikeebikedbtgtDao.insertOrUpdateEbikeChargeplugOpsDbDoList(list);
        }
    }

    /**
     * 15.6	当前充电记录
     *
     * @param vo
     * @return
     */
    private void selectEbikeChargerecordDbDoList(EbikeDbVo vo) {

        String dateTime = vo.getDateTime();
        // 获取前8分钟的时间
        String beforeTime = DateUti.durationMinutes(dateTime, -8);
        vo.setChargeTime(beforeTime);
        vo.setUpdateTime(beforeTime);

        List<EbikeChargerecordDbDo> list = ebikeebikedbsrcDao.selectEbikeChargerecordDbDoList(vo);
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);

            insertOrUpdateEbikeChargerecordDbDoList(list);

            // 根据充电用户标识查询充电用户档案信息
            List<String> strings = list.stream().map(dbDo -> dbDo.getChargeUserId()).collect(Collectors.toList());
            vo.setUserIds(strings);

            List<EbikeChargeuserDbDo> userList = selectEbikeChargeuserDbDoList(vo);

            if (userList != null && userList.size() > 0) {
                userList.removeIf(Objects::isNull);

                insertOrUpdateEbikeChargeuserDbDoList(userList);
            }
        }

    }

    /**
     * 批量插入
     *
     * @param list
     * @return
     */
    private void insertOrUpdateEbikeChargerecordDbDoList(List<EbikeChargerecordDbDo> list) {

        if (list != null && list.size() > 0) {
            ebikeebikedbtgtDao.insertOrUpdateEbikeChargerecordDbDoList(list);
        }
    }

    /**
     * 15.7	历史充电记录
     *
     * @param vo
     * @return
     */
    private void selectEbikeChargerecordHisDbDoList(EbikeDbVo vo) {
        String dateTime = vo.getDateTime();
        // 获取前8分钟的时间 chargeFinishTime chargeTime closingTime
        String beforeTime = DateUti.durationMinutes(dateTime, -8);
        vo.setChargeFinishTime(beforeTime);
        vo.setChargeTime(beforeTime);
        vo.setClosingTime(beforeTime);
        List<EbikeChargerecordHisDbDo> list = ebikeebikedbsrcDao.selectEbikeChargerecordHisDbDoList(vo);
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            insertOrUpdateEbikeChargerecordHisDbDoList(list);
        }
    }

    /**
     * 批量插入
     *
     * @param list
     */
    private void insertOrUpdateEbikeChargerecordHisDbDoList(List<EbikeChargerecordHisDbDo> list) {
        if (list != null && list.size() > 0) {
            ebikeebikedbtgtDao.insertOrUpdateEbikeChargerecordHisDbDoList(list);
        }
    }

    /**
     * 15.8	历史充电记录收入分配明细
     *
     * @param vo
     * @return
     */
    private void selectEbikeChargerecordIncomedetailDbDoList(EbikeDbVo vo) {
        String dateTime = vo.getDateTime();
        // 获取前8分钟的时间 distTime distSuccessTime csrefundSuccessTime
        String beforeTime = DateUti.durationMinutes(dateTime, -8);
        vo.setDistTime(beforeTime);
        vo.setDistSuccessTime(beforeTime);
        vo.setCsrefundSuccessTime(beforeTime);
        List<EbikeChargerecordIncomedetailDbDo> list = ebikeebikedbsrcDao.selectEbikeChargerecordIncomedetailDbDoList(vo);
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            insertOrUpdateEbikeChargerecordIncomedetailDbDoList(list);
        }
    }

    /**
     * 批量插入
     *
     * @param list
     */
    private void insertOrUpdateEbikeChargerecordIncomedetailDbDoList(List<EbikeChargerecordIncomedetailDbDo> list) {
        if (list != null && list.size() > 0) {
            ebikeebikedbtgtDao.insertOrUpdateEbikeChargerecordIncomedetailDbDoList(list);
        }
    }

    /**
     * 查询列表
     *
     * @param vo
     * @return
     */
    private List<EbikeChargeuserDbDo> selectEbikeChargeuserDbDoList(EbikeDbVo vo) {
        return ebikeebikedbsrcDao.selectEbikeChargeuserDbDoList(vo);
    }

    /**
     * 批量插入
     *
     * @param list
     */
    private void insertOrUpdateEbikeChargeuserDbDoList(List<EbikeChargeuserDbDo> list) {
        if (list != null && list.size() > 0) {
            ebikeebikedbtgtDao.insertOrUpdateEbikeChargeuserDbDoList(list);
        }
    }
}
