/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.dbmigration.service.impl;

import com.ebike.openservices.dbmigration.ebikedbsrc.dao.EbikeebikedbsrcDao;
import com.ebike.openservices.dbmigration.ebikedbtgt.dao.EbikeebikedbtgtDao;
import com.ebike.openservices.dbmigration.entity.EbikeChargedeviceOpsDbDo;
import com.ebike.openservices.dbmigration.entity.EbikeChargeplugOpsDbDo;
import com.ebike.openservices.dbmigration.entity.EbikeChargerecordDbDo;
import com.ebike.openservices.dbmigration.entity.EbikeChargerecordHisDbDo;
import com.ebike.openservices.dbmigration.entity.EbikeChargerecordIncomedetailDbDo;
import com.ebike.openservices.dbmigration.entity.EbikeChargeuserDbDo;
import com.ebike.openservices.dbmigration.entity.EbikeDbVo;
import com.ebike.openservices.dbmigration.service.EbikeDbDService;
import com.ebike.openservices.dbmigration.util.DateUti;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EbikeDbDServiceImpl
implements EbikeDbDService {
    @Resource
    private EbikeebikedbsrcDao ebikeebikedbsrcDao;
    @Resource
    private EbikeebikedbtgtDao ebikeebikedbtgtDao;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void startDbMigrate(String dateTime) {
        EbikeDbVo vo;
        try {
            vo = new EbikeDbVo();
            vo.setDateTime(dateTime);
            this.selectEbikeChargedeviceOpsDbDoList(vo);
        }
        catch (Exception e) {
            this.logger.error("selectEbikeChargedeviceOpsDbDoList error:{}", (Object)e.getMessage());
        }
        try {
            vo = new EbikeDbVo();
            vo.setDateTime(dateTime);
            this.selectEbikeChargeplugOpsDbDoList(vo);
        }
        catch (Exception e) {
            this.logger.error("selectEbikeChargeplugOpsDbDoList error:{}", (Object)e.getMessage());
        }
        try {
            vo = new EbikeDbVo();
            vo.setDateTime(dateTime);
            this.selectEbikeChargerecordDbDoList(vo);
        }
        catch (Exception e) {
            this.logger.error("selectEbikeChargerecordDbDoList error:{}", (Object)e.getMessage());
        }
        try {
            vo = new EbikeDbVo();
            vo.setDateTime(dateTime);
            this.selectEbikeChargerecordHisDbDoList(vo);
        }
        catch (Exception e) {
            this.logger.error("selectEbikeChargerecordHisDbDoList error:{}", (Object)e.getMessage());
        }
        try {
            vo = new EbikeDbVo();
            vo.setDateTime(dateTime);
            this.selectEbikeChargerecordIncomedetailDbDoList(vo);
        }
        catch (Exception e) {
            this.logger.error("selectEbikeChargerecordIncomedetailDbDoList error:{}", (Object)e.getMessage());
        }
        System.out.println("-------");
    }

    private void selectEbikeChargedeviceOpsDbDoList(EbikeDbVo vo) {
        String dateTime = vo.getDateTime();
        String beforeTime = DateUti.durationMinutes(dateTime, -8);
        vo.setLatestChargeFinishTime(beforeTime);
        vo.setFirstChargeFinishTime(beforeTime);
        vo.setLatestCommTime(beforeTime);
        List<EbikeChargedeviceOpsDbDo> list = this.ebikeebikedbsrcDao.selectEbikeChargedeviceOpsDbDoList(vo);
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            this.insertOrUpdateEbikeChargedeviceOpsDbDoList(list);
        }
    }

    private void insertOrUpdateEbikeChargedeviceOpsDbDoList(List<EbikeChargedeviceOpsDbDo> list) {
        if (list != null && list.size() > 0) {
            this.ebikeebikedbtgtDao.insertOrUpdateEbikeChargedeviceOpsDbDoList(list);
        }
    }

    private void selectEbikeChargeplugOpsDbDoList(EbikeDbVo vo) {
        String dateTime = vo.getDateTime();
        String beforeTime = DateUti.durationMinutes(dateTime, -8);
        vo.setOpStatusTime(beforeTime);
        List<EbikeChargeplugOpsDbDo> list = this.ebikeebikedbsrcDao.selectEbikeChargeplugOpsDbDoList(vo);
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            this.insertOrUpdateEbikeChargeplugOpsDbDoList(list);
        }
    }

    private void insertOrUpdateEbikeChargeplugOpsDbDoList(List<EbikeChargeplugOpsDbDo> list) {
        if (list != null && list.size() > 0) {
            this.ebikeebikedbtgtDao.insertOrUpdateEbikeChargeplugOpsDbDoList(list);
        }
    }

    private void selectEbikeChargerecordDbDoList(EbikeDbVo vo) {
        String dateTime = vo.getDateTime();
        String beforeTime = DateUti.durationMinutes(dateTime, -8);
        vo.setChargeTime(beforeTime);
        vo.setUpdateTime(beforeTime);
        List<EbikeChargerecordDbDo> list = this.ebikeebikedbsrcDao.selectEbikeChargerecordDbDoList(vo);
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            this.insertOrUpdateEbikeChargerecordDbDoList(list);
            List strings = list.stream().map(dbDo -> dbDo.getChargeUserId()).collect(Collectors.toList());
            vo.setUserIds(strings);
            List<EbikeChargeuserDbDo> userList = this.selectEbikeChargeuserDbDoList(vo);
            if (userList != null && userList.size() > 0) {
                userList.removeIf(Objects::isNull);
                this.insertOrUpdateEbikeChargeuserDbDoList(userList);
            }
        }
    }

    private void insertOrUpdateEbikeChargerecordDbDoList(List<EbikeChargerecordDbDo> list) {
        if (list != null && list.size() > 0) {
            this.ebikeebikedbtgtDao.insertOrUpdateEbikeChargerecordDbDoList(list);
        }
    }

    private void selectEbikeChargerecordHisDbDoList(EbikeDbVo vo) {
        String dateTime = vo.getDateTime();
        String beforeTime = DateUti.durationMinutes(dateTime, -8);
        vo.setChargeFinishTime(beforeTime);
        vo.setChargeTime(beforeTime);
        vo.setClosingTime(beforeTime);
        List<EbikeChargerecordHisDbDo> list = this.ebikeebikedbsrcDao.selectEbikeChargerecordHisDbDoList(vo);
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            this.insertOrUpdateEbikeChargerecordHisDbDoList(list);
        }
    }

    private void insertOrUpdateEbikeChargerecordHisDbDoList(List<EbikeChargerecordHisDbDo> list) {
        if (list != null && list.size() > 0) {
            this.ebikeebikedbtgtDao.insertOrUpdateEbikeChargerecordHisDbDoList(list);
        }
    }

    private void selectEbikeChargerecordIncomedetailDbDoList(EbikeDbVo vo) {
        String dateTime = vo.getDateTime();
        String beforeTime = DateUti.durationMinutes(dateTime, -8);
        vo.setDistTime(beforeTime);
        vo.setDistSuccessTime(beforeTime);
        vo.setCsrefundSuccessTime(beforeTime);
        List<EbikeChargerecordIncomedetailDbDo> list = this.ebikeebikedbsrcDao.selectEbikeChargerecordIncomedetailDbDoList(vo);
        if (list != null && list.size() > 0) {
            list.removeIf(Objects::isNull);
            this.insertOrUpdateEbikeChargerecordIncomedetailDbDoList(list);
        }
    }

    private void insertOrUpdateEbikeChargerecordIncomedetailDbDoList(List<EbikeChargerecordIncomedetailDbDo> list) {
        if (list != null && list.size() > 0) {
            this.ebikeebikedbtgtDao.insertOrUpdateEbikeChargerecordIncomedetailDbDoList(list);
        }
    }

    private List<EbikeChargeuserDbDo> selectEbikeChargeuserDbDoList(EbikeDbVo vo) {
        return this.ebikeebikedbsrcDao.selectEbikeChargeuserDbDoList(vo);
    }

    private void insertOrUpdateEbikeChargeuserDbDoList(List<EbikeChargeuserDbDo> list) {
        if (list != null && list.size() > 0) {
            this.ebikeebikedbtgtDao.insertOrUpdateEbikeChargeuserDbDoList(list);
        }
    }
}

