package com.ebike.openservices.devmgmt.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 安装驿吧充电设备请求
 *
 * @author Nick Zhang
 * @date 2019-04-10
 */
@Data
public class EbikeChargedeviceInstallRequest implements Serializable {

    private static final long serialVersionUID = 6995166344441080848L;

    /**
     * 充电设备标识
     */
    private Long chargedeviceId;

    /**
     * 充电设备编号
     */
    private String chargedeviceNo;

    /**
     * 充电设备名称
     */
    private String chargedeviceName;

    /**
     * 设备通讯标识
     */
    private String deviceId;

    /**
     * 设备通讯标识
     */
    private String protocolType;

    /**
     * 设备通讯标识
     */
    private String protocolVersion;

    /**
     * 设备参数，JSON格式字符串
     */
    private String deviceParams;

    /**
     * 插座个数
     */
    private Integer plugCount;

    /**
     * 生产厂家
     */
    private String mfrCode;

    /**
     * 设备型号
     */
    private String modelCode;

    /**
     * 安装人
     */
    private String installer;

    /**
     * 安装备注
     */
    private String installRemark;

    /**
     * 安装类型：
     *   newinstall - 新装（库存 --> 已装）
     *   reinstall  - 重装（拆除 --> 已装）；
     */
    private String installType;

    /**
     * 运营商编号
     */
    private String orgNo;

    /**
     * 运营商编号
     */
    private Long chargestationId;

}
