package com.ebike.openservices.devmgmt.request;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 计量设备装接请求
 */
@Data
public class MeterDeviceInstallRequest implements Serializable {

    private static final long serialVersionUID = -7762096469581483053L;
    private String operator;                    // 操作员（必填）
    private String meterdeviceNo;               // 计量设备编号（必填）
    private String meterdeviceType;             // 计量设备类型（必填）：10 – 电能表
    private String commAddress;                 // 通信地址（选填）
    private String commProtocol;                // 通信协议（选填）：dlt645 - DL/T 645
    private String commProtocolVersion;         // 通信协议版本（选填）：1997；2007
    private Long chargestationId;               // 充电站标识（必填）
    private Long chargedeviceId;                // 采集充电设备标识（必填）
    private String acqCommMode;                 // 采集通信方式（选填）：01 – RS485
    private Map<String, Object> acqCommParams;  // 采集通信参数（选填）：例如：{"baudrate":"2400","parity":"2"}
    private Map<String, Object> measdatas;      // 计量设备量测数据（选填）：例如：{"cum_pos_active_total":0.00}

}
