package com.ebike.openservices.devmgmt.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.ebike.openservices.devmgmt.entity.DevEbikeChargedeviceDo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-10
 */
public interface DevEbikeChargedeviceDao extends CrudMapper<DevEbikeChargedeviceDo, Long> {

    /**
     * 通过充电站标识获取充电设备个数
     * @param chargestationId
     *          充电站标识
     * @return  充电设备个数
     */
    int getCountByChargestationId(@Param("chargestationId") Long chargestationId);

    /**
     * 通过充电站标识获取充电设备列表
     * @param chargestationId
     *          充电站标识
     * @return  充电设备列表
     */
    List<DevEbikeChargedeviceDo> getListByChargestationId(@Param("chargestationId") Long chargestationId);

}
