package com.ebike.openservices.devmgmt.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.ebike.openservices.devmgmt.entity.DevEbikeChargeplugDo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-10
 */
public interface DevEbikeChargeplugDao extends CrudMapper<DevEbikeChargeplugDo, Long> {

    /**
     * 通过充电设备标识和插座序号获取充电插座实体类
     * @param chargedeviceId
     *          充电设备标识
     * @param plugSn
     *          插座序号
     * @return  充电插座实体类
     */
    DevEbikeChargeplugDo getByChargedeviceIdAndPlugSn(@Param("chargedeviceId") Long chargedeviceId, @Param("plugSn") Integer plugSn);

    /**
     * 通过充电设备标识获取充电插座个数
     * @param chargedeviceId
     *          充电设备标识
     * @return  充电插座个数
     */
    int getCountByChargedeviceId(@Param("chargedeviceId") Long chargedeviceId);

    /**
     * 通过充电设备标识获取充电插座列表
     * @param chargedeviceId
     *          充电设备标识
     * @return  充电插座列表
     */
    List<DevEbikeChargeplugDo> getListByChargedeviceId(@Param("chargedeviceId") Long chargedeviceId);

}
