package com.ebike.openservices.devmgmt.jdbcdao.impl;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.devmgmt.jdbcdao.EbikeDemoJdbcDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-10
 */
@Repository
public class EbikeDemoJdbcDaoImpl extends AbstractEbikeBaseJdbcDao implements EbikeDemoJdbcDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Qualifier("ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public EbikeDemoJdbcDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, Object>> getList(Map<String, Object> params, Sorter sorter, Pager pager) {
        SqlParamsBuilder sqlParamsBuilder = new SqlParamsBuilder();
        sqlParamsBuilder.append("SELECT ecs.ID AS chargestation_id\n" +
                "        , ecs.STATIONNO AS chargestation_no\n" +
                "        , psr.NAME AS chargestation_name\n" +
                "        , ecs.STATIONADDR AS chargestation_addr\n" +
                "        , psr.STATUS AS run_status\n" +
                "        , psr.SUBBURO AS orgopr_no\n" +
                "        , ecs.LONGITUDE AS longitude\n" +
                "        , ecs.LATITUDE AS latitude\n" +
                "        , ecs.ADCODE AS adcode\n" +
                "        , ecs.CITYCODE AS citycode\n" +
                "        FROM cisp_dev.dev_ebikechargestation ecs\n" +
                "        INNER JOIN cisp_dev.dev_powersystemresource psr ON psr.CLASSNAME = 'EBikeChargeStation' AND psr.ID = ecs.ID\n");
        sqlParamsBuilder.append("WHERE 1 = 1");
        sqlParamsBuilder.append(" AND psr.SUBBURO = ? ", "88000242");
        return ebikeJdbcTemplate.query(sqlParamsBuilder.getSql(), sqlParamsBuilder.getParams(), mapRowMapper);
    }

}
