package com.ebike.openservices.devmgmt.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.devmgmt.dao.DevEbikeChargedeviceDao;
import com.ebike.openservices.devmgmt.dao.DevEbikeChargeplugDao;
import com.ebike.openservices.devmgmt.dao.DevEbikeChargestationDao;
import com.ebike.openservices.devmgmt.dao.DevPowerSystemResourceDao;
import com.ebike.openservices.devmgmt.entity.DevEbikeChargedeviceDo;
import com.ebike.openservices.devmgmt.entity.DevEbikeChargeplugDo;
import com.ebike.openservices.devmgmt.entity.DevPowerSystemResourceDo;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceArchiveRequest;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceDismantleRequest;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceGotorunRequest;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceInstallRequest;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceArchiveResponse;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceDismantleResponse;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceGotorunResponse;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceInstallResponse;
import com.ebike.openservices.devmgmt.service.EbikeChargedeviceMgmtService;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-10
 */
@Service
@Primary
public class EbikeChargedeviceMgmtServiceImpl extends AbstractEbikeBaseService implements EbikeChargedeviceMgmtService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String NEWINSTALL = "newinstall";
    private static final String REINSTALL = "reinstall";
    private static final String EBIKECHARGESTATION = "EBikeChargeStation";
    private static final String EBIKECHARGEDEVICE = "EBikeChargeDevice";
    private static final String EBIKECHARGEPLUG = "EBikeChargePlug";

    @Resource
    private DevPowerSystemResourceDao devPowerSystemResourceDao;

    @Resource
    private DevEbikeChargestationDao devEbikeChargestationDao;

    @Resource
    private DevEbikeChargedeviceDao devEbikeChargedeviceDao;

    @Resource
    private DevEbikeChargeplugDao devEbikeChargeplugDao;

    @Override
    public EbikeChargedeviceInstallResponse installEbikeChargedevice(EbikeChargedeviceInstallRequest ebikeChargedeviceInstallRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start installEbikeChargedevice >>>>>> ");
            logger.debug(" EbikeChargedeviceInstallRequest      : " + ebikeChargedeviceInstallRequest);
        }

        EbikeChargedeviceInstallResponse response = new EbikeChargedeviceInstallResponse();
        response.setReturnCode("FAILURE");
        if(ebikeChargedeviceInstallRequest != null && StringUtils.equals(ebikeChargedeviceInstallRequest.getInstallType(), NEWINSTALL)) {
            DevPowerSystemResourceDo devPowerSystemResourceChargestation = devPowerSystemResourceDao.get(ebikeChargedeviceInstallRequest.getChargestationId());
            // 新装（库存 --> 已装）
            Long chargedeviceId = idGenerator.nextId();
            DevPowerSystemResourceDo devPowerSystemResourceChargedevice = new DevPowerSystemResourceDo();
            devPowerSystemResourceChargedevice.setId(chargedeviceId);
            devPowerSystemResourceChargedevice.setClassName(EBIKECHARGEDEVICE);
            devPowerSystemResourceChargedevice.setName(StringUtils.defaultIfBlank(ebikeChargedeviceInstallRequest.getChargedeviceName(), ebikeChargedeviceInstallRequest.getChargedeviceNo()));
            devPowerSystemResourceChargedevice.setStatus("20");
            devPowerSystemResourceChargedevice.setVoltageLevelId("60");
            devPowerSystemResourceChargedevice.setBuro(ebikeChargedeviceInstallRequest.getOrgNo());
            devPowerSystemResourceChargedevice.setSubburo(ebikeChargedeviceInstallRequest.getOrgNo());
            devPowerSystemResourceChargedevice.setXh(ebikeChargedeviceInstallRequest.getModelCode());
            devPowerSystemResourceChargedevice.setSccj(ebikeChargedeviceInstallRequest.getMfrCode());
            devPowerSystemResourceChargedevice.setCcbh(ebikeChargedeviceInstallRequest.getChargedeviceNo());
            devPowerSystemResourceChargedevice.setRunDate(new Date());
            devPowerSystemResourceChargedevice.setInstallDate(new Date());
            devPowerSystemResourceChargedevice.setCreatorId(ebikeChargedeviceInstallRequest.getInstaller());
            devPowerSystemResourceChargedevice.setCreateDate(new Date());
            devPowerSystemResourceChargedevice.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
            devPowerSystemResourceChargedevice.setLastUpdateDate(new Date());
            logger.info("devPowerSystemResourceChargedevice : " + JsonConvertUtils.convertToString(devPowerSystemResourceChargedevice));
            int insertResultPsrChargedevice = devPowerSystemResourceDao.insert(devPowerSystemResourceChargedevice);
            if(insertResultPsrChargedevice > 0) {
                DevEbikeChargedeviceDo devEbikeChargedevice = new DevEbikeChargedeviceDo();
                devEbikeChargedevice.setId(chargedeviceId);
                devEbikeChargedevice.setChargedeviceNo(ebikeChargedeviceInstallRequest.getChargedeviceNo());
                devEbikeChargedevice.setChargestationId(ebikeChargedeviceInstallRequest.getChargestationId());
                devEbikeChargedevice.setDeviceId(ebikeChargedeviceInstallRequest.getDeviceId());
                devEbikeChargedevice.setProtocolType(ebikeChargedeviceInstallRequest.getProtocolType());
                devEbikeChargedevice.setProtocolVersion(ebikeChargedeviceInstallRequest.getProtocolVersion());
                devEbikeChargedevice.setDeviceParams(ebikeChargedeviceInstallRequest.getDeviceParams());
                devEbikeChargedevice.setPlugCount(ebikeChargedeviceInstallRequest.getPlugCount());
                devEbikeChargedevice.setInstaller(ebikeChargedeviceInstallRequest.getInstaller());
                devEbikeChargedevice.setInstallRemark(ebikeChargedeviceInstallRequest.getInstallRemark());
                logger.info("devEbikeChargedevice           : " + JsonConvertUtils.convertToString(devEbikeChargedevice));
                int insertResultEcd = devEbikeChargedeviceDao.insert(devEbikeChargedevice);
                if(insertResultEcd > 0) {
                    // 更新充电站状态
                    devPowerSystemResourceChargestation.setStatus("20");
                    devPowerSystemResourceChargestation.setRunDate(new Date());
                    devPowerSystemResourceChargestation.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
                    devPowerSystemResourceChargestation.setLastUpdateDate(new Date());
                    devPowerSystemResourceDao.update(devPowerSystemResourceChargestation);
                    // 新增充电插座
                    Integer plugCount = devEbikeChargedevice.getPlugCount();
                    List<DevEbikeChargeplugDo> devEbikeChargeplugList = Lists.newArrayList();
                    for(int i = 1; i <= plugCount; i++) {
                        Long chargeplugId = idGenerator.nextId();
                        String chargeplugNo = ebikeChargedeviceInstallRequest.getChargedeviceNo() + String.format("%02d", i);
                        Integer plugSn = i;
                        DevPowerSystemResourceDo devPowerSystemResourceChargeplug = new DevPowerSystemResourceDo();
                        devPowerSystemResourceChargeplug.setId(chargeplugId);
                        devPowerSystemResourceChargeplug.setClassName(EBIKECHARGEPLUG);
                        devPowerSystemResourceChargeplug.setName(chargeplugNo);
                        devPowerSystemResourceChargeplug.setStatus("20");
                        devPowerSystemResourceChargeplug.setVoltageLevelId("60");
                        devPowerSystemResourceChargeplug.setBuro(ebikeChargedeviceInstallRequest.getOrgNo());
                        devPowerSystemResourceChargeplug.setSubburo(ebikeChargedeviceInstallRequest.getOrgNo());
                        devPowerSystemResourceChargeplug.setCreatorId(ebikeChargedeviceInstallRequest.getInstaller());
                        devPowerSystemResourceChargeplug.setCreateDate(new Date());
                        devPowerSystemResourceChargeplug.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
                        devPowerSystemResourceChargeplug.setLastUpdateDate(new Date());
                        logger.info("devPowerSystemResourceChargeplug   : " + JsonConvertUtils.convertToString(devPowerSystemResourceChargeplug));
                        int insertResultPsrChargeplug = devPowerSystemResourceDao.insert(devPowerSystemResourceChargeplug);
                        if(insertResultPsrChargeplug > 0) {
                            DevEbikeChargeplugDo devEbikeChargeplug = new DevEbikeChargeplugDo();
                            devEbikeChargeplug.setId(chargeplugId);
                            devEbikeChargeplug.setChargeplugNo(chargeplugNo);
                            devEbikeChargeplug.setChargedeviceId(chargedeviceId);
                            devEbikeChargeplug.setPlugSn(plugSn);
                            devEbikeChargeplug.setPlugId(String.valueOf(plugSn));
                            logger.info("devEbikeChargeplug             : " + JsonConvertUtils.convertToString(devEbikeChargeplug));
                            int insertResultEcp = devEbikeChargeplugDao.insert(devEbikeChargeplug);
                            if(insertResultEcp > 0) {
                                devEbikeChargeplugList.add(devEbikeChargeplug);
                            }
                        }
                    }
                    response.setReturnCode("SUCCESS");
                    response.setDevEbikeChargedevice(devEbikeChargedevice);
                    response.setDevEbikeChargeplugList(devEbikeChargeplugList);
                }
            }
        }
        else if(ebikeChargedeviceInstallRequest != null && StringUtils.equals(ebikeChargedeviceInstallRequest.getInstallType(), REINSTALL)) {
            // 重装（拆除 --> 已装）
            Long chargedeviceId = ebikeChargedeviceInstallRequest.getChargedeviceId();
            if(chargedeviceId != null && chargedeviceId > 0L) {
                DevPowerSystemResourceDo devPowerSystemResourceChargestation = devPowerSystemResourceDao.get(ebikeChargedeviceInstallRequest.getChargestationId());
                DevPowerSystemResourceDo devPowerSystemResourceChargedevice = devPowerSystemResourceDao.get(chargedeviceId);
                DevEbikeChargedeviceDo devEbikeChargedevice = devEbikeChargedeviceDao.get(chargedeviceId);
                // 更新充电设备状态
                devPowerSystemResourceChargedevice.setStatus("20");
                devPowerSystemResourceChargedevice.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
                devPowerSystemResourceChargedevice.setLastUpdateDate(new Date());
                int updateResultPsrChargedevice = devPowerSystemResourceDao.update(devPowerSystemResourceChargedevice);
                if(updateResultPsrChargedevice > 0) {
                    devEbikeChargedevice.setChargestationId(ebikeChargedeviceInstallRequest.getChargestationId());
                    devEbikeChargedevice.setInstaller(ebikeChargedeviceInstallRequest.getInstaller());
                    devEbikeChargedevice.setInstallRemark(ebikeChargedeviceInstallRequest.getInstallRemark());
                    devEbikeChargedevice.setDismantler("");
                    devEbikeChargedevice.setDismantleRemark("");
                    int updateResultEcd = devEbikeChargedeviceDao.update(devEbikeChargedevice);
                    if(updateResultEcd > 0) {
                        // 更新充电站状态
                        devPowerSystemResourceChargestation.setStatus("20");
                        devPowerSystemResourceChargestation.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
                        devPowerSystemResourceChargestation.setLastUpdateDate(new Date());
                        devPowerSystemResourceDao.update(devPowerSystemResourceChargestation);
                        // 更新充电插座状态
                        Integer plugCount = devEbikeChargedevice.getPlugCount();
                        List<DevEbikeChargeplugDo> devEbikeChargeplugList = Lists.newArrayList();
                        for(int i = 1; i <= plugCount; i++) {
                            DevEbikeChargeplugDo devEbikeChargeplug = devEbikeChargeplugDao.getByChargedeviceIdAndPlugSn(chargedeviceId, i);
                            if(devEbikeChargeplug != null && devEbikeChargeplug.getId() != null && devEbikeChargeplug.getId() > 0L) {
                                Long chargeplugId = devEbikeChargeplug.getId();
                                DevPowerSystemResourceDo devPowerSystemResourceChargeplug = devPowerSystemResourceDao.get(chargeplugId);
                                devPowerSystemResourceChargeplug.setStatus("20");
                                devPowerSystemResourceChargeplug.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
                                devPowerSystemResourceChargeplug.setLastUpdateDate(new Date());
                                int updateResultPsrChargeplug = devPowerSystemResourceDao.update(devPowerSystemResourceChargeplug);
                                if(updateResultPsrChargeplug > 0) {
                                    devEbikeChargeplugList.add(devEbikeChargeplug);
                                }
                            }
                        }
                        response.setReturnCode("SUCCESS");
                        response.setDevEbikeChargedevice(devEbikeChargedevice);
                        response.setDevEbikeChargeplugList(devEbikeChargeplugList);
                    }
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" EbikeChargedeviceInstallResponse     : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end installEbikeChargedevice <<<<<<<< ");
        }
        return response;
    }

    @Override
    public EbikeChargedeviceGotorunResponse gotorunEbikeChargedevice(EbikeChargedeviceGotorunRequest ebikeChargedeviceGotorunRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start gotorunEbikeChargedevice >>>>>> ");
            logger.debug(" EbikeChargedeviceGotorunRequest      : " + ebikeChargedeviceGotorunRequest);
        }

        EbikeChargedeviceGotorunResponse response = new EbikeChargedeviceGotorunResponse();

        if(logger.isDebugEnabled()) {
            logger.debug(" EbikeChargedeviceGotorunResponse     : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end gotorunEbikeChargedevice <<<<<<<< ");
        }
        return response;
    }

    @Override
    public EbikeChargedeviceDismantleResponse dismantleEbikeChargedevice(EbikeChargedeviceDismantleRequest ebikeChargedeviceDismantleRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start dismantleEbikeChargedevice >>>>>> ");
            logger.debug(" EbikeChargedeviceDismantleRequest    : " + ebikeChargedeviceDismantleRequest);
        }

        EbikeChargedeviceDismantleResponse response = new EbikeChargedeviceDismantleResponse();
        response.setReturnCode("FAILURE");
        if(ebikeChargedeviceDismantleRequest != null) {
            Long chargedeviceId = ebikeChargedeviceDismantleRequest.getChargedeviceId();
            DevPowerSystemResourceDo devPowerSystemResourceChargedevice = devPowerSystemResourceDao.get(chargedeviceId);
            DevEbikeChargedeviceDo devEbikeChargedevice = devEbikeChargedeviceDao.get(chargedeviceId);
            if(devEbikeChargedevice != null && devEbikeChargedevice.getChargestationId() != null && devEbikeChargedevice.getChargestationId() > 0L) {
                Long chargestationId = devEbikeChargedevice.getChargestationId();
                // 更新充电设备状态
                devPowerSystemResourceChargedevice.setStatus("40");
                devPowerSystemResourceChargedevice.setStopDate(new Date());
                devPowerSystemResourceChargedevice.setLastUpdateId(ebikeChargedeviceDismantleRequest.getDismantler());
                devPowerSystemResourceChargedevice.setLastUpdateDate(new Date());
                int updateResultPsrChargedevice = devPowerSystemResourceDao.update(devPowerSystemResourceChargedevice);
                if(updateResultPsrChargedevice > 0) {
                    devEbikeChargedevice.setChargestationId(0L);
                    devEbikeChargedevice.setDismantler(ebikeChargedeviceDismantleRequest.getDismantler());
                    devEbikeChargedevice.setDismantleRemark(ebikeChargedeviceDismantleRequest.getDismantleRemark());
                    int updateResultEcd = devEbikeChargedeviceDao.update(devEbikeChargedevice);
                    if(updateResultEcd > 0) {
                        // 判断是否更新充电站状态
                        int cnt = devEbikeChargedeviceDao.getCountByChargestationId(chargestationId);
                        if(cnt == 0) {
                            DevPowerSystemResourceDo devPowerSystemResourceChargestation = devPowerSystemResourceDao.get(chargestationId);
                            devPowerSystemResourceChargestation.setStatus("40");
                            devPowerSystemResourceChargestation.setStopDate(new Date());
                            devPowerSystemResourceChargestation.setLastUpdateId(ebikeChargedeviceDismantleRequest.getDismantler());
                            devPowerSystemResourceChargestation.setLastUpdateDate(new Date());
                            devPowerSystemResourceDao.update(devPowerSystemResourceChargestation);
                        }
                        List<DevEbikeChargeplugDo> devEbikeChargeplugList = devEbikeChargeplugDao.getListByChargedeviceId(chargedeviceId);
                        response.setReturnCode("SUCCESS");
                        response.setDevEbikeChargedevice(devEbikeChargedevice);
                        response.setDevEbikeChargeplugList(devEbikeChargeplugList);
                    }
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" EbikeChargedeviceDismantleResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end dismantleEbikeChargedevice <<<<<<<< ");
        }
        return response;
    }

    @Override
    public EbikeChargedeviceArchiveResponse archiveEbikeChargedevice(EbikeChargedeviceArchiveRequest ebikeChargedeviceArchiveRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start archiveEbikeChargedevice >>>>>> ");
            logger.debug(" EbikeChargedeviceArchiveRequest      : " + ebikeChargedeviceArchiveRequest);
        }

        EbikeChargedeviceArchiveResponse response = new EbikeChargedeviceArchiveResponse();

        if(logger.isDebugEnabled()) {
            logger.debug(" EbikeChargedeviceArchiveResponse     : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end archiveEbikeChargedevice <<<<<<<< ");
        }
        return response;
    }

}
