package com.ebike.openservices.devmgmt.service.impl;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.devmgmt.dao.EbikeChargestationQueryDao;
import com.ebike.openservices.devmgmt.entity.EbikeChargestationVo;
import com.ebike.openservices.devmgmt.service.EbikeChargestationQueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-10
 */
@Service
@Primary
public class EbikeChargestationQueryServiceImpl extends AbstractEbikeBaseService implements EbikeChargestationQueryService {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final EbikeChargestationQueryDao ebikeChargestationQueryDao;

    @Autowired
    public EbikeChargestationQueryServiceImpl(EbikeChargestationQueryDao ebikeChargestationQueryDao) {
        this.ebikeChargestationQueryDao = ebikeChargestationQueryDao;
    }


    @Override
    public int getCount(Map<String, Object> params) {
        return ebikeChargestationQueryDao.getCount(params);
    }

    @Override
    public List<EbikeChargestationVo> getList(Map<String, Object> params, Sorter sorter, Pager pager) {
        return ebikeChargestationQueryDao.getList(params, sorter, pager);
    }

}
