package com.ebike.openservices.devmgmt.service.impl;

import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.devmgmt.dao.*;
import com.ebike.openservices.devmgmt.entity.*;
import com.ebike.openservices.devmgmt.request.MeterDeviceInstallRequest;
import com.ebike.openservices.devmgmt.request.MeterDeviceUninstallRequest;
import com.ebike.openservices.devmgmt.response.MeterDeviceInstallResponse;
import com.ebike.openservices.devmgmt.response.MeterDeviceUninstallResponse;
import com.ebike.openservices.devmgmt.service.MeterDeviceMgmtService;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-10
 */
@Service
@Primary
public class MeterDeviceMgmtServiceImpl extends AbstractEbikeBaseService implements MeterDeviceMgmtService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private EbikeAssetsMeterdeviceDao ebikeAssetsMeterdeviceDao;

    @Resource
    private EbikeCsMtrdevRelaDao ebikeCsMtrdevRelaDao;

    @Resource
    private EbikeCsMtrdevRelaHisDao ebikeCsMtrdevRelaHisDao;

    @Resource
    private EbikeMeaspointMeterdeviceDao ebikeMeaspointMeterdeviceDao;

    @Resource
    private EbikeMeaspointMeterdeviceHisDao ebikeMeaspointMeterdeviceHisDao;

    @Resource
    private LogLifestateMeterdeviceDao logLifestateMeterdeviceDao;

    @Resource
    private EbikeChargestationQueryDao ebikeChargestationQueryDao;

    @Override
    public MeterDeviceInstallResponse installMeterDevice(MeterDeviceInstallRequest meterDeviceInstallRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start installMeterDevice >>>>>> ");
            logger.debug(" MeterDeviceInstallRequest    : " + meterDeviceInstallRequest);
        }
        MeterDeviceInstallResponse meterDeviceInstallResponse = new MeterDeviceInstallResponse();
        if(meterDeviceInstallRequest != null) {
            String operator = meterDeviceInstallRequest.getOperator();
            String meterdeviceNo = meterDeviceInstallRequest.getMeterdeviceNo();
            String meterdeviceType = meterDeviceInstallRequest.getMeterdeviceType();
            String commAddress = meterDeviceInstallRequest.getCommAddress();
            String commProtocol = meterDeviceInstallRequest.getCommProtocol();
            String commProtocolVersion = meterDeviceInstallRequest.getCommProtocolVersion();
            Long chargestationId = meterDeviceInstallRequest.getChargestationId();
            Long chargedeviceId = meterDeviceInstallRequest.getChargedeviceId();
            String acqCommMode = meterDeviceInstallRequest.getAcqCommMode();
            Map<String, Object> acqCommParams = meterDeviceInstallRequest.getAcqCommParams();
            Map<String, Object> measdatas = meterDeviceInstallRequest.getMeasdatas();
            // 检查请求参数
            if(StringUtils.isBlank(operator)) {
                // 操作员为空
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("请求参数错误（操作员为空）");
                return meterDeviceInstallResponse;
            }
            if(StringUtils.isBlank(meterdeviceNo)) {
                // 计量设备编号为空
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("请求参数错误（计量设备编号为空）");
                return meterDeviceInstallResponse;
            }
            if(StringUtils.isBlank(meterdeviceType)) {
                // 计量设备类型为空
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("请求参数错误（计量设备类型为空）");
                return meterDeviceInstallResponse;
            }
            if(ObjectUtils.isNull(chargestationId)) {
                // 充电站标识为空
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("请求参数错误（充电站标识为空）");
                return meterDeviceInstallResponse;
            }
            if(ObjectUtils.isNull(chargedeviceId)) {
                // 采集充电设备标识为空
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("请求参数错误（采集充电设备标识为空）");
                return meterDeviceInstallResponse;
            }
            //
            EbikeAssetsMeterdeviceDo ebikeAssetsMeterdevice = ebikeAssetsMeterdeviceDao.getByMeterdeviceNo(meterdeviceNo);
            if(ObjectUtils.isNotNull(ebikeAssetsMeterdevice) && StringUtils.isNotBlank(ebikeAssetsMeterdevice.getMeterdeviceId())) {
                String lifeState = ebikeAssetsMeterdevice.getLifeState();
                if(StringUtils.equalsAny(lifeState, "00", "07")) {
                    // 生命状态为：00 库存 或 07 拆除
                    // 可以装接

                }
                else if(StringUtils.equalsAny(lifeState, "02", "03")) {
                    // 生命状态为：02 已装 或 03 运行
                    // 不可以装接
                    meterDeviceInstallResponse.setReturnCode("FAILURE");
                    meterDeviceInstallResponse.setReturnMsg("计量设备已装接");
                    return meterDeviceInstallResponse;
                }
                else {
                    // 不可以装接
                    meterDeviceInstallResponse.setReturnCode("FAILURE");
                    meterDeviceInstallResponse.setReturnMsg("计量设备状态错误（" + lifeState + "）");
                    return meterDeviceInstallResponse;
                }
            }
            else {
                // 可以装接
                EbikeChargestationVo ebikeChargestationVo = ebikeChargestationQueryDao.get(chargestationId);
                if(ebikeChargestationVo != null && ebikeChargestationVo.getChargestationId() > 0L
                        && StringUtils.equalsAny(ebikeChargestationVo.getRunStatus(), "20")) {
                    ebikeAssetsMeterdevice = new EbikeAssetsMeterdeviceDo();
                    ebikeAssetsMeterdevice.setMeterdeviceId(UuidUtils.generateUuidString());
                    ebikeAssetsMeterdevice.setMeterdeviceNo(meterdeviceNo);
                    ebikeAssetsMeterdevice.setOrgoprNo(ebikeChargestationVo.getOrgoprNo());
                    ebikeAssetsMeterdevice.setMeterdeviceType(meterdeviceType);
                    ebikeAssetsMeterdevice.setCommAddress(StringUtils.defaultIfBlank(commAddress, meterdeviceNo));
                    ebikeAssetsMeterdevice.setCommProtocol(StringUtils.defaultIfBlank(commProtocol, "dlt645"));
                    ebikeAssetsMeterdevice.setCommProtocolVersion(StringUtils.defaultIfBlank(commProtocolVersion, "2007"));
                    ebikeAssetsMeterdevice.setLifeState("02");
                    ebikeAssetsMeterdevice.setRunStatus("20");
                    ebikeAssetsMeterdevice.setMfgFactory("holley");
                    ebikeAssetsMeterdevice.setCreateTime(new Date());
                    ebikeAssetsMeterdevice.setUpdateTime(new Date());
                    if(logger.isDebugEnabled()) {
                        logger.debug(" 装接前 ebikeAssetsMeterdevice ： " + JsonConvertUtils.convertToString(ebikeAssetsMeterdevice));
                    }
                    int insertFlag = ebikeAssetsMeterdeviceDao.insert(ebikeAssetsMeterdevice);
                    if(logger.isDebugEnabled()) {
                        logger.debug(" 装接后 insertFlag             ： " + insertFlag);
                        logger.debug(" 装接后 ebikeAssetsMeterdevice ： " + JsonConvertUtils.convertToString(ebikeAssetsMeterdevice));
                    }
                    if(insertFlag > 0) {
                        EbikeCsMtrdevRelaDo ebikeCsMtrdevRelaDo = new EbikeCsMtrdevRelaDo();
                        ebikeCsMtrdevRelaDo.setRelaId(UuidUtils.generateUuidString());
                        ebikeCsMtrdevRelaDo.setChargestationId(chargestationId);
                        ebikeCsMtrdevRelaDo.setMeterdeviceId(ebikeAssetsMeterdevice.getMeterdeviceId());
                        ebikeCsMtrdevRelaDo.setCreateTime(new Date());
                        int relaInsertFlag = ebikeCsMtrdevRelaDao.insert(ebikeCsMtrdevRelaDo);
                        EbikeCsMtrdevRelaHisDo ebikeCsMtrdevRelaHisDo = new EbikeCsMtrdevRelaHisDo();
                        ebikeCsMtrdevRelaHisDo.setIsVaild(true);
                        try {
                            BeanUtils.copyProperties(ebikeCsMtrdevRelaHisDo, ebikeCsMtrdevRelaDo);
                        }
                        catch(IllegalAccessException | InvocationTargetException e) {
                            logger.error(e.getMessage(), e.fillInStackTrace());
                        }
                        int relaHisInsertFlag = ebikeCsMtrdevRelaHisDao.insert(ebikeCsMtrdevRelaHisDo);
                        //
                        Map<String, Object> defAcqCommParams = Maps.newHashMap();
                        defAcqCommParams.put("baudrate", "2400");
                        defAcqCommParams.put("parity", "2");
                        EbikeMeaspointMeterdeviceDo ebikeMeaspointMeterdeviceDo = new EbikeMeaspointMeterdeviceDo();
                        ebikeMeaspointMeterdeviceDo.setMeaspointId(UuidUtils.generateUuidString());
                        ebikeMeaspointMeterdeviceDo.setMeterdeviceId(ebikeAssetsMeterdevice.getMeterdeviceId());
                        ebikeMeaspointMeterdeviceDo.setChargestationId(chargestationId);
                        ebikeMeaspointMeterdeviceDo.setChargedeviceId(chargedeviceId);
                        ebikeMeaspointMeterdeviceDo.setAcqCommMode(StringUtils.defaultIfBlank(acqCommMode, "01"));
                        ebikeMeaspointMeterdeviceDo.setAcqCommParams(ObjectUtils.defaultIfNull(acqCommParams, defAcqCommParams));
                        ebikeMeaspointMeterdeviceDo.setCreateTime(new Date());
                        ebikeMeaspointMeterdeviceDo.setUpdateTime(new Date());
                        int measpointInsertFlag = ebikeMeaspointMeterdeviceDao.insert(ebikeMeaspointMeterdeviceDo);
                        EbikeMeaspointMeterdeviceHisDo ebikeMeaspointMeterdeviceHisDo = new EbikeMeaspointMeterdeviceHisDo();
                        try {
                            BeanUtils.copyProperties(ebikeMeaspointMeterdeviceHisDo, ebikeMeaspointMeterdeviceDo);
                        }
                        catch(IllegalAccessException | InvocationTargetException e) {
                            logger.error(e.getMessage(), e.fillInStackTrace());
                        }
                        ebikeMeaspointMeterdeviceHisDo.setIsVaild(true);
                        int measpointInsertHisFlag = ebikeMeaspointMeterdeviceHisDao.insert(ebikeMeaspointMeterdeviceHisDo);
                    }
                }
                else {
                    if(ebikeChargestationVo == null || ebikeChargestationVo.getChargestationId() == 0L) {
                        meterDeviceInstallResponse.setReturnCode("FAILURE");
                        meterDeviceInstallResponse.setReturnMsg("充电站为空");
                    }
                    else if(StringUtils.equalsAny(ebikeChargestationVo.getRunStatus(), "10", "40")) {
                        meterDeviceInstallResponse.setReturnCode("FAILURE");
                        meterDeviceInstallResponse.setReturnMsg("充电站状态为未投运或退运");
                    }
                    else {
                        meterDeviceInstallResponse.setReturnCode("FAILURE");
                        meterDeviceInstallResponse.setReturnMsg("充电站信息有误（" + ebikeChargestationVo.getChargestationId() + "）");
                    }
                    return meterDeviceInstallResponse;
                }
            }
        }
        else {
            meterDeviceInstallResponse.setReturnCode("FAILURE");
            meterDeviceInstallResponse.setReturnMsg("请求参数非法");
            return meterDeviceInstallResponse;
        }
        return meterDeviceInstallResponse;
    }

    @Override
    public MeterDeviceUninstallResponse uninstallMeterDevice(MeterDeviceUninstallRequest meterDeviceUninstallRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start uninstallMeterDevice >>>>>> ");
            logger.debug(" MeterDeviceUninstallRequest  : " + meterDeviceUninstallRequest);
        }
        MeterDeviceUninstallResponse meterDeviceUninstallResponse = new MeterDeviceUninstallResponse();
        return meterDeviceUninstallResponse;
    }

}
