package com.ebike.openservices.devmgmt.service.impl;

import com.easesource.commons.util.UuidUtils;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.devmgmt.request.MeterDeviceRemoteReadingResultRequest;
import com.ebike.openservices.devmgmt.request.MeterDeviceRemoteReadingTaskRequest;
import com.ebike.openservices.devmgmt.response.MeterDeviceRemoteReadingResultResponse;
import com.ebike.openservices.devmgmt.response.MeterDeviceRemoteReadingTaskResponse;
import com.ebike.openservices.devmgmt.service.MeterDeviceRemoteReadingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-10
 */
@Service
@Primary
public class MeterDeviceRemoteReadingServiceImpl extends AbstractEbikeBaseService implements MeterDeviceRemoteReadingService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public MeterDeviceRemoteReadingTaskResponse sendTask(MeterDeviceRemoteReadingTaskRequest meterDeviceRemoteReadingTaskRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start sendTask >>>>>> ");
            logger.debug(" MeterDeviceRemoteReadingTaskRequest      : " + meterDeviceRemoteReadingTaskRequest);
        }
        MeterDeviceRemoteReadingTaskResponse meterDeviceRemoteReadingTaskResponse = new MeterDeviceRemoteReadingTaskResponse();
        if(meterDeviceRemoteReadingTaskRequest != null) {
            String operator = meterDeviceRemoteReadingTaskRequest.getOperator();
            String chargedeviceNo = meterDeviceRemoteReadingTaskRequest.getChargedeviceNo();
            String deviceId = meterDeviceRemoteReadingTaskRequest.getDeviceId();
            String meterdeviceNo = meterDeviceRemoteReadingTaskRequest.getMeterdeviceNo();
            String commAddress = meterDeviceRemoteReadingTaskRequest.getCommAddress();
            String acqCommMode = meterDeviceRemoteReadingTaskRequest.getAcqCommMode();
            Map<String, Object> acqCommParams = meterDeviceRemoteReadingTaskRequest.getAcqCommParams();
            String taskId = UuidUtils.generateUuidString();
            meterDeviceRemoteReadingTaskResponse.setTaskId(taskId);
            meterDeviceRemoteReadingTaskResponse.setReturnCode("SUCCESS");
        }
        else {
            meterDeviceRemoteReadingTaskResponse.setReturnCode("FAILURE");
            meterDeviceRemoteReadingTaskResponse.setReturnMsg("请求参数非法");
        }
        return meterDeviceRemoteReadingTaskResponse;
    }

    @Override
    public MeterDeviceRemoteReadingResultResponse getResult(MeterDeviceRemoteReadingResultRequest meterDeviceRemoteReadingResultRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getResult >>>>>> ");
            logger.debug(" MeterDeviceRemoteReadingResultRequest    : " + meterDeviceRemoteReadingResultRequest);
        }
        MeterDeviceRemoteReadingResultResponse meterDeviceRemoteReadingResultResponse = new MeterDeviceRemoteReadingResultResponse();
        if(meterDeviceRemoteReadingResultRequest != null) {
            String operator = meterDeviceRemoteReadingResultRequest.getOperator();
            String taskId = meterDeviceRemoteReadingResultRequest.getTaskId();
            String chargedeviceNo = meterDeviceRemoteReadingResultRequest.getChargedeviceNo();
            String deviceId = meterDeviceRemoteReadingResultRequest.getDeviceId();
            String meterdeviceNo = meterDeviceRemoteReadingResultRequest.getMeterdeviceNo();
            String commAddress = meterDeviceRemoteReadingResultRequest.getCommAddress();
        }
        else {
            meterDeviceRemoteReadingResultResponse.setReturnCode("FAILURE");
            meterDeviceRemoteReadingResultResponse.setReturnMsg("请求参数非法");
        }
        return meterDeviceRemoteReadingResultResponse;
    }

}
