/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.devmgmt.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.devmgmt.dao.DevEbikeChargedeviceDao;
import com.ebike.openservices.devmgmt.dao.DevEbikeChargeplugDao;
import com.ebike.openservices.devmgmt.dao.DevEbikeChargestationDao;
import com.ebike.openservices.devmgmt.dao.DevPowerSystemResourceDao;
import com.ebike.openservices.devmgmt.entity.DevEbikeChargedeviceDo;
import com.ebike.openservices.devmgmt.entity.DevEbikeChargeplugDo;
import com.ebike.openservices.devmgmt.entity.DevPowerSystemResourceDo;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceArchiveRequest;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceDismantleRequest;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceGotorunRequest;
import com.ebike.openservices.devmgmt.request.EbikeChargedeviceInstallRequest;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceArchiveResponse;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceDismantleResponse;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceGotorunResponse;
import com.ebike.openservices.devmgmt.response.EbikeChargedeviceInstallResponse;
import com.ebike.openservices.devmgmt.service.EbikeChargedeviceMgmtService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class EbikeChargedeviceMgmtServiceImpl
extends AbstractEbikeBaseService
implements EbikeChargedeviceMgmtService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String NEWINSTALL = "newinstall";
    private static final String REINSTALL = "reinstall";
    private static final String EBIKECHARGESTATION = "EBikeChargeStation";
    private static final String EBIKECHARGEDEVICE = "EBikeChargeDevice";
    private static final String EBIKECHARGEPLUG = "EBikeChargePlug";
    @Resource
    private DevPowerSystemResourceDao devPowerSystemResourceDao;
    @Resource
    private DevEbikeChargestationDao devEbikeChargestationDao;
    @Resource
    private DevEbikeChargedeviceDao devEbikeChargedeviceDao;
    @Resource
    private DevEbikeChargeplugDao devEbikeChargeplugDao;

    public EbikeChargedeviceInstallResponse installEbikeChargedevice(EbikeChargedeviceInstallRequest ebikeChargedeviceInstallRequest) {
        Long chargedeviceId;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start installEbikeChargedevice >>>>>> ");
            this.logger.debug(" EbikeChargedeviceInstallRequest      : " + ebikeChargedeviceInstallRequest);
        }
        EbikeChargedeviceInstallResponse response = new EbikeChargedeviceInstallResponse();
        response.setReturnCode("FAILURE");
        if (ebikeChargedeviceInstallRequest != null && StringUtils.equals((CharSequence)ebikeChargedeviceInstallRequest.getInstallType(), (CharSequence)NEWINSTALL)) {
            DevPowerSystemResourceDo devPowerSystemResourceChargestation = (DevPowerSystemResourceDo)this.devPowerSystemResourceDao.get(ebikeChargedeviceInstallRequest.getChargestationId());
            Long chargedeviceId2 = this.idGenerator.nextId();
            DevPowerSystemResourceDo devPowerSystemResourceChargedevice = new DevPowerSystemResourceDo();
            devPowerSystemResourceChargedevice.setId(chargedeviceId2);
            devPowerSystemResourceChargedevice.setClassName(EBIKECHARGEDEVICE);
            devPowerSystemResourceChargedevice.setName((String)StringUtils.defaultIfBlank((CharSequence)ebikeChargedeviceInstallRequest.getChargedeviceName(), (CharSequence)ebikeChargedeviceInstallRequest.getChargedeviceNo()));
            devPowerSystemResourceChargedevice.setStatus("20");
            devPowerSystemResourceChargedevice.setVoltageLevelId("60");
            devPowerSystemResourceChargedevice.setBuro(ebikeChargedeviceInstallRequest.getOrgNo());
            devPowerSystemResourceChargedevice.setSubburo(ebikeChargedeviceInstallRequest.getOrgNo());
            devPowerSystemResourceChargedevice.setXh(ebikeChargedeviceInstallRequest.getModelCode());
            devPowerSystemResourceChargedevice.setSccj(ebikeChargedeviceInstallRequest.getMfrCode());
            devPowerSystemResourceChargedevice.setCcbh(ebikeChargedeviceInstallRequest.getChargedeviceNo());
            devPowerSystemResourceChargedevice.setRunDate(new Date());
            devPowerSystemResourceChargedevice.setInstallDate(new Date());
            devPowerSystemResourceChargedevice.setCreatorId(ebikeChargedeviceInstallRequest.getInstaller());
            devPowerSystemResourceChargedevice.setCreateDate(new Date());
            devPowerSystemResourceChargedevice.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
            devPowerSystemResourceChargedevice.setLastUpdateDate(new Date());
            this.logger.info("devPowerSystemResourceChargedevice : " + JsonConvertUtils.convertToString((Object)devPowerSystemResourceChargedevice));
            int insertResultPsrChargedevice = this.devPowerSystemResourceDao.insert(devPowerSystemResourceChargedevice);
            if (insertResultPsrChargedevice > 0) {
                DevEbikeChargedeviceDo devEbikeChargedevice = new DevEbikeChargedeviceDo();
                devEbikeChargedevice.setId(chargedeviceId2);
                devEbikeChargedevice.setChargedeviceNo(ebikeChargedeviceInstallRequest.getChargedeviceNo());
                devEbikeChargedevice.setChargestationId(ebikeChargedeviceInstallRequest.getChargestationId());
                devEbikeChargedevice.setDeviceId(ebikeChargedeviceInstallRequest.getDeviceId());
                devEbikeChargedevice.setProtocolType(ebikeChargedeviceInstallRequest.getProtocolType());
                devEbikeChargedevice.setProtocolVersion(ebikeChargedeviceInstallRequest.getProtocolVersion());
                devEbikeChargedevice.setDeviceParams(ebikeChargedeviceInstallRequest.getDeviceParams());
                devEbikeChargedevice.setPlugCount(ebikeChargedeviceInstallRequest.getPlugCount());
                devEbikeChargedevice.setInstaller(ebikeChargedeviceInstallRequest.getInstaller());
                devEbikeChargedevice.setInstallRemark(ebikeChargedeviceInstallRequest.getInstallRemark());
                this.logger.info("devEbikeChargedevice           : " + JsonConvertUtils.convertToString((Object)devEbikeChargedevice));
                int insertResultEcd = this.devEbikeChargedeviceDao.insert(devEbikeChargedevice);
                if (insertResultEcd > 0) {
                    devPowerSystemResourceChargestation.setStatus("20");
                    devPowerSystemResourceChargestation.setRunDate(new Date());
                    devPowerSystemResourceChargestation.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
                    devPowerSystemResourceChargestation.setLastUpdateDate(new Date());
                    this.devPowerSystemResourceDao.update(devPowerSystemResourceChargestation);
                    Integer plugCount = devEbikeChargedevice.getPlugCount();
                    ArrayList devEbikeChargeplugList = Lists.newArrayList();
                    for (int i = 1; i <= plugCount; ++i) {
                        Long chargeplugId = this.idGenerator.nextId();
                        String chargeplugNo = ebikeChargedeviceInstallRequest.getChargedeviceNo() + String.format("%02d", i);
                        Integer plugSn = i;
                        DevPowerSystemResourceDo devPowerSystemResourceChargeplug = new DevPowerSystemResourceDo();
                        devPowerSystemResourceChargeplug.setId(chargeplugId);
                        devPowerSystemResourceChargeplug.setClassName(EBIKECHARGEPLUG);
                        devPowerSystemResourceChargeplug.setName(chargeplugNo);
                        devPowerSystemResourceChargeplug.setStatus("20");
                        devPowerSystemResourceChargeplug.setVoltageLevelId("60");
                        devPowerSystemResourceChargeplug.setBuro(ebikeChargedeviceInstallRequest.getOrgNo());
                        devPowerSystemResourceChargeplug.setSubburo(ebikeChargedeviceInstallRequest.getOrgNo());
                        devPowerSystemResourceChargeplug.setCreatorId(ebikeChargedeviceInstallRequest.getInstaller());
                        devPowerSystemResourceChargeplug.setCreateDate(new Date());
                        devPowerSystemResourceChargeplug.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
                        devPowerSystemResourceChargeplug.setLastUpdateDate(new Date());
                        this.logger.info("devPowerSystemResourceChargeplug   : " + JsonConvertUtils.convertToString((Object)devPowerSystemResourceChargeplug));
                        int insertResultPsrChargeplug = this.devPowerSystemResourceDao.insert(devPowerSystemResourceChargeplug);
                        if (insertResultPsrChargeplug <= 0) continue;
                        DevEbikeChargeplugDo devEbikeChargeplug = new DevEbikeChargeplugDo();
                        devEbikeChargeplug.setId(chargeplugId);
                        devEbikeChargeplug.setChargeplugNo(chargeplugNo);
                        devEbikeChargeplug.setChargedeviceId(chargedeviceId2);
                        devEbikeChargeplug.setPlugSn(plugSn);
                        devEbikeChargeplug.setPlugId(String.valueOf(plugSn));
                        this.logger.info("devEbikeChargeplug             : " + JsonConvertUtils.convertToString((Object)devEbikeChargeplug));
                        int insertResultEcp = this.devEbikeChargeplugDao.insert(devEbikeChargeplug);
                        if (insertResultEcp <= 0) continue;
                        devEbikeChargeplugList.add(devEbikeChargeplug);
                    }
                    response.setReturnCode("SUCCESS");
                    response.setDevEbikeChargedevice(devEbikeChargedevice);
                    response.setDevEbikeChargeplugList((List)devEbikeChargeplugList);
                }
            }
        } else if (ebikeChargedeviceInstallRequest != null && StringUtils.equals((CharSequence)ebikeChargedeviceInstallRequest.getInstallType(), (CharSequence)REINSTALL) && (chargedeviceId = ebikeChargedeviceInstallRequest.getChargedeviceId()) != null && chargedeviceId > 0L) {
            DevPowerSystemResourceDo devPowerSystemResourceChargestation = (DevPowerSystemResourceDo)this.devPowerSystemResourceDao.get(ebikeChargedeviceInstallRequest.getChargestationId());
            DevPowerSystemResourceDo devPowerSystemResourceChargedevice = (DevPowerSystemResourceDo)this.devPowerSystemResourceDao.get(chargedeviceId);
            DevEbikeChargedeviceDo devEbikeChargedevice = (DevEbikeChargedeviceDo)this.devEbikeChargedeviceDao.get(chargedeviceId);
            devPowerSystemResourceChargedevice.setStatus("20");
            devPowerSystemResourceChargedevice.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
            devPowerSystemResourceChargedevice.setLastUpdateDate(new Date());
            int updateResultPsrChargedevice = this.devPowerSystemResourceDao.update(devPowerSystemResourceChargedevice);
            if (updateResultPsrChargedevice > 0) {
                devEbikeChargedevice.setChargestationId(ebikeChargedeviceInstallRequest.getChargestationId());
                devEbikeChargedevice.setInstaller(ebikeChargedeviceInstallRequest.getInstaller());
                devEbikeChargedevice.setInstallRemark(ebikeChargedeviceInstallRequest.getInstallRemark());
                devEbikeChargedevice.setDismantler("");
                devEbikeChargedevice.setDismantleRemark("");
                int updateResultEcd = this.devEbikeChargedeviceDao.update(devEbikeChargedevice);
                if (updateResultEcd > 0) {
                    devPowerSystemResourceChargestation.setStatus("20");
                    devPowerSystemResourceChargestation.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
                    devPowerSystemResourceChargestation.setLastUpdateDate(new Date());
                    this.devPowerSystemResourceDao.update(devPowerSystemResourceChargestation);
                    Integer plugCount = devEbikeChargedevice.getPlugCount();
                    ArrayList devEbikeChargeplugList = Lists.newArrayList();
                    for (int i = 1; i <= plugCount; ++i) {
                        DevEbikeChargeplugDo devEbikeChargeplug = this.devEbikeChargeplugDao.getByChargedeviceIdAndPlugSn(chargedeviceId, i);
                        if (devEbikeChargeplug == null || devEbikeChargeplug.getId() == null || devEbikeChargeplug.getId() <= 0L) continue;
                        Long chargeplugId = devEbikeChargeplug.getId();
                        DevPowerSystemResourceDo devPowerSystemResourceChargeplug = (DevPowerSystemResourceDo)this.devPowerSystemResourceDao.get(chargeplugId);
                        devPowerSystemResourceChargeplug.setStatus("20");
                        devPowerSystemResourceChargeplug.setLastUpdateId(ebikeChargedeviceInstallRequest.getInstaller());
                        devPowerSystemResourceChargeplug.setLastUpdateDate(new Date());
                        int updateResultPsrChargeplug = this.devPowerSystemResourceDao.update(devPowerSystemResourceChargeplug);
                        if (updateResultPsrChargeplug <= 0) continue;
                        devEbikeChargeplugList.add(devEbikeChargeplug);
                    }
                    response.setReturnCode("SUCCESS");
                    response.setDevEbikeChargedevice(devEbikeChargedevice);
                    response.setDevEbikeChargeplugList((List)devEbikeChargeplugList);
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" EbikeChargedeviceInstallResponse     : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end installEbikeChargedevice <<<<<<<< ");
        }
        return response;
    }

    public EbikeChargedeviceGotorunResponse gotorunEbikeChargedevice(EbikeChargedeviceGotorunRequest ebikeChargedeviceGotorunRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start gotorunEbikeChargedevice >>>>>> ");
            this.logger.debug(" EbikeChargedeviceGotorunRequest      : " + ebikeChargedeviceGotorunRequest);
        }
        EbikeChargedeviceGotorunResponse response = new EbikeChargedeviceGotorunResponse();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" EbikeChargedeviceGotorunResponse     : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end gotorunEbikeChargedevice <<<<<<<< ");
        }
        return response;
    }

    public EbikeChargedeviceDismantleResponse dismantleEbikeChargedevice(EbikeChargedeviceDismantleRequest ebikeChargedeviceDismantleRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start dismantleEbikeChargedevice >>>>>> ");
            this.logger.debug(" EbikeChargedeviceDismantleRequest    : " + ebikeChargedeviceDismantleRequest);
        }
        EbikeChargedeviceDismantleResponse response = new EbikeChargedeviceDismantleResponse();
        response.setReturnCode("FAILURE");
        if (ebikeChargedeviceDismantleRequest != null) {
            Long chargedeviceId = ebikeChargedeviceDismantleRequest.getChargedeviceId();
            DevPowerSystemResourceDo devPowerSystemResourceChargedevice = (DevPowerSystemResourceDo)this.devPowerSystemResourceDao.get(chargedeviceId);
            DevEbikeChargedeviceDo devEbikeChargedevice = (DevEbikeChargedeviceDo)this.devEbikeChargedeviceDao.get(chargedeviceId);
            if (devEbikeChargedevice != null && devEbikeChargedevice.getChargestationId() != null && devEbikeChargedevice.getChargestationId() > 0L) {
                Long chargestationId = devEbikeChargedevice.getChargestationId();
                devPowerSystemResourceChargedevice.setStatus("40");
                devPowerSystemResourceChargedevice.setStopDate(new Date());
                devPowerSystemResourceChargedevice.setLastUpdateId(ebikeChargedeviceDismantleRequest.getDismantler());
                devPowerSystemResourceChargedevice.setLastUpdateDate(new Date());
                int updateResultPsrChargedevice = this.devPowerSystemResourceDao.update(devPowerSystemResourceChargedevice);
                if (updateResultPsrChargedevice > 0) {
                    devEbikeChargedevice.setChargestationId(Long.valueOf(0L));
                    devEbikeChargedevice.setDismantler(ebikeChargedeviceDismantleRequest.getDismantler());
                    devEbikeChargedevice.setDismantleRemark(ebikeChargedeviceDismantleRequest.getDismantleRemark());
                    int updateResultEcd = this.devEbikeChargedeviceDao.update(devEbikeChargedevice);
                    if (updateResultEcd > 0) {
                        int cnt = this.devEbikeChargedeviceDao.getCountByChargestationId(chargestationId);
                        if (cnt == 0) {
                            DevPowerSystemResourceDo devPowerSystemResourceChargestation = (DevPowerSystemResourceDo)this.devPowerSystemResourceDao.get(chargestationId);
                            devPowerSystemResourceChargestation.setStatus("40");
                            devPowerSystemResourceChargestation.setStopDate(new Date());
                            devPowerSystemResourceChargestation.setLastUpdateId(ebikeChargedeviceDismantleRequest.getDismantler());
                            devPowerSystemResourceChargestation.setLastUpdateDate(new Date());
                            this.devPowerSystemResourceDao.update(devPowerSystemResourceChargestation);
                        }
                        List<DevEbikeChargeplugDo> devEbikeChargeplugList = this.devEbikeChargeplugDao.getListByChargedeviceId(chargedeviceId);
                        response.setReturnCode("SUCCESS");
                        response.setDevEbikeChargedevice(devEbikeChargedevice);
                        response.setDevEbikeChargeplugList(devEbikeChargeplugList);
                    }
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" EbikeChargedeviceDismantleResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end dismantleEbikeChargedevice <<<<<<<< ");
        }
        return response;
    }

    public EbikeChargedeviceArchiveResponse archiveEbikeChargedevice(EbikeChargedeviceArchiveRequest ebikeChargedeviceArchiveRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start archiveEbikeChargedevice >>>>>> ");
            this.logger.debug(" EbikeChargedeviceArchiveRequest      : " + ebikeChargedeviceArchiveRequest);
        }
        EbikeChargedeviceArchiveResponse response = new EbikeChargedeviceArchiveResponse();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" EbikeChargedeviceArchiveResponse     : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end archiveEbikeChargedevice <<<<<<<< ");
        }
        return response;
    }
}

