/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.devmgmt.service.impl;

import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.devmgmt.dao.EbikeAssetsMeterdeviceDao;
import com.ebike.openservices.devmgmt.dao.EbikeChargestationQueryDao;
import com.ebike.openservices.devmgmt.dao.EbikeCsMtrdevRelaDao;
import com.ebike.openservices.devmgmt.dao.EbikeCsMtrdevRelaHisDao;
import com.ebike.openservices.devmgmt.dao.EbikeMeaspointMeterdeviceDao;
import com.ebike.openservices.devmgmt.dao.EbikeMeaspointMeterdeviceHisDao;
import com.ebike.openservices.devmgmt.dao.LogLifestateMeterdeviceDao;
import com.ebike.openservices.devmgmt.entity.EbikeAssetsMeterdeviceDo;
import com.ebike.openservices.devmgmt.entity.EbikeChargestationVo;
import com.ebike.openservices.devmgmt.entity.EbikeCsMtrdevRelaDo;
import com.ebike.openservices.devmgmt.entity.EbikeCsMtrdevRelaHisDo;
import com.ebike.openservices.devmgmt.entity.EbikeMeaspointMeterdeviceDo;
import com.ebike.openservices.devmgmt.entity.EbikeMeaspointMeterdeviceHisDo;
import com.ebike.openservices.devmgmt.request.MeterDeviceInstallRequest;
import com.ebike.openservices.devmgmt.request.MeterDeviceUninstallRequest;
import com.ebike.openservices.devmgmt.response.MeterDeviceInstallResponse;
import com.ebike.openservices.devmgmt.response.MeterDeviceUninstallResponse;
import com.ebike.openservices.devmgmt.service.MeterDeviceMgmtService;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class MeterDeviceMgmtServiceImpl
extends AbstractEbikeBaseService
implements MeterDeviceMgmtService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private EbikeAssetsMeterdeviceDao ebikeAssetsMeterdeviceDao;
    @Resource
    private EbikeCsMtrdevRelaDao ebikeCsMtrdevRelaDao;
    @Resource
    private EbikeCsMtrdevRelaHisDao ebikeCsMtrdevRelaHisDao;
    @Resource
    private EbikeMeaspointMeterdeviceDao ebikeMeaspointMeterdeviceDao;
    @Resource
    private EbikeMeaspointMeterdeviceHisDao ebikeMeaspointMeterdeviceHisDao;
    @Resource
    private LogLifestateMeterdeviceDao logLifestateMeterdeviceDao;
    @Resource
    private EbikeChargestationQueryDao ebikeChargestationQueryDao;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MeterDeviceInstallResponse installMeterDevice(MeterDeviceInstallRequest meterDeviceInstallRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start installMeterDevice >>>>>> ");
            this.logger.debug(" MeterDeviceInstallRequest    : " + meterDeviceInstallRequest);
        }
        MeterDeviceInstallResponse meterDeviceInstallResponse = new MeterDeviceInstallResponse();
        if (meterDeviceInstallRequest != null) {
            String operator = meterDeviceInstallRequest.getOperator();
            String meterdeviceNo = meterDeviceInstallRequest.getMeterdeviceNo();
            String meterdeviceType = meterDeviceInstallRequest.getMeterdeviceType();
            String commAddress = meterDeviceInstallRequest.getCommAddress();
            String commProtocol = meterDeviceInstallRequest.getCommProtocol();
            String commProtocolVersion = meterDeviceInstallRequest.getCommProtocolVersion();
            Long chargestationId = meterDeviceInstallRequest.getChargestationId();
            Long chargedeviceId = meterDeviceInstallRequest.getChargedeviceId();
            String acqCommMode = meterDeviceInstallRequest.getAcqCommMode();
            Map acqCommParams = meterDeviceInstallRequest.getAcqCommParams();
            Map measdatas = meterDeviceInstallRequest.getMeasdatas();
            if (StringUtils.isBlank((CharSequence)operator)) {
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff08\u64cd\u4f5c\u5458\u4e3a\u7a7a\uff09");
                return meterDeviceInstallResponse;
            }
            if (StringUtils.isBlank((CharSequence)meterdeviceNo)) {
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff08\u8ba1\u91cf\u8bbe\u5907\u7f16\u53f7\u4e3a\u7a7a\uff09");
                return meterDeviceInstallResponse;
            }
            if (StringUtils.isBlank((CharSequence)meterdeviceType)) {
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff08\u8ba1\u91cf\u8bbe\u5907\u7c7b\u578b\u4e3a\u7a7a\uff09");
                return meterDeviceInstallResponse;
            }
            if (ObjectUtils.isNull((Object)chargestationId)) {
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff08\u5145\u7535\u7ad9\u6807\u8bc6\u4e3a\u7a7a\uff09");
                return meterDeviceInstallResponse;
            }
            if (ObjectUtils.isNull((Object)chargedeviceId)) {
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff08\u91c7\u96c6\u5145\u7535\u8bbe\u5907\u6807\u8bc6\u4e3a\u7a7a\uff09");
                return meterDeviceInstallResponse;
            }
            EbikeAssetsMeterdeviceDo ebikeAssetsMeterdevice = this.ebikeAssetsMeterdeviceDao.getByMeterdeviceNo(meterdeviceNo);
            if (ObjectUtils.isNotNull((Object)ebikeAssetsMeterdevice) && StringUtils.isNotBlank((CharSequence)ebikeAssetsMeterdevice.getMeterdeviceId())) {
                String lifeState = ebikeAssetsMeterdevice.getLifeState();
                if (StringUtils.equalsAny((CharSequence)lifeState, (CharSequence[])new CharSequence[]{"00", "07"})) return meterDeviceInstallResponse;
                if (StringUtils.equalsAny((CharSequence)lifeState, (CharSequence[])new CharSequence[]{"02", "03"})) {
                    meterDeviceInstallResponse.setReturnCode("FAILURE");
                    meterDeviceInstallResponse.setReturnMsg("\u8ba1\u91cf\u8bbe\u5907\u5df2\u88c5\u63a5");
                    return meterDeviceInstallResponse;
                }
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("\u8ba1\u91cf\u8bbe\u5907\u72b6\u6001\u9519\u8bef\uff08" + lifeState + "\uff09");
                return meterDeviceInstallResponse;
            }
            EbikeChargestationVo ebikeChargestationVo = (EbikeChargestationVo)this.ebikeChargestationQueryDao.get(chargestationId);
            if (ebikeChargestationVo != null && ebikeChargestationVo.getChargestationId() > 0L && StringUtils.equalsAny((CharSequence)ebikeChargestationVo.getRunStatus(), (CharSequence[])new CharSequence[]{"20"})) {
                ebikeAssetsMeterdevice = new EbikeAssetsMeterdeviceDo();
                ebikeAssetsMeterdevice.setMeterdeviceId(UuidUtils.generateUuidString());
                ebikeAssetsMeterdevice.setMeterdeviceNo(meterdeviceNo);
                ebikeAssetsMeterdevice.setOrgoprNo(ebikeChargestationVo.getOrgoprNo());
                ebikeAssetsMeterdevice.setMeterdeviceType(meterdeviceType);
                ebikeAssetsMeterdevice.setCommAddress((String)StringUtils.defaultIfBlank((CharSequence)commAddress, (CharSequence)meterdeviceNo));
                ebikeAssetsMeterdevice.setCommProtocol((String)StringUtils.defaultIfBlank((CharSequence)commProtocol, (CharSequence)"dlt645"));
                ebikeAssetsMeterdevice.setCommProtocolVersion((String)StringUtils.defaultIfBlank((CharSequence)commProtocolVersion, (CharSequence)"2007"));
                ebikeAssetsMeterdevice.setLifeState("02");
                ebikeAssetsMeterdevice.setRunStatus("20");
                ebikeAssetsMeterdevice.setMfgFactory("holley");
                ebikeAssetsMeterdevice.setCreateTime(new Date());
                ebikeAssetsMeterdevice.setUpdateTime(new Date());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" \u88c5\u63a5\u524d ebikeAssetsMeterdevice \uff1a " + JsonConvertUtils.convertToString((Object)ebikeAssetsMeterdevice));
                }
                int insertFlag = this.ebikeAssetsMeterdeviceDao.insert(ebikeAssetsMeterdevice);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" \u88c5\u63a5\u540e insertFlag             \uff1a " + insertFlag);
                    this.logger.debug(" \u88c5\u63a5\u540e ebikeAssetsMeterdevice \uff1a " + JsonConvertUtils.convertToString((Object)ebikeAssetsMeterdevice));
                }
                if (insertFlag <= 0) return meterDeviceInstallResponse;
                EbikeCsMtrdevRelaDo ebikeCsMtrdevRelaDo = new EbikeCsMtrdevRelaDo();
                ebikeCsMtrdevRelaDo.setRelaId(UuidUtils.generateUuidString());
                ebikeCsMtrdevRelaDo.setChargestationId(chargestationId);
                ebikeCsMtrdevRelaDo.setMeterdeviceId(ebikeAssetsMeterdevice.getMeterdeviceId());
                ebikeCsMtrdevRelaDo.setCreateTime(new Date());
                int relaInsertFlag = this.ebikeCsMtrdevRelaDao.insert(ebikeCsMtrdevRelaDo);
                EbikeCsMtrdevRelaHisDo ebikeCsMtrdevRelaHisDo = new EbikeCsMtrdevRelaHisDo();
                ebikeCsMtrdevRelaHisDo.setIsVaild(Boolean.valueOf(true));
                try {
                    BeanUtils.copyProperties((Object)ebikeCsMtrdevRelaHisDo, (Object)ebikeCsMtrdevRelaDo);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.logger.error(e.getMessage(), e.fillInStackTrace());
                }
                int relaHisInsertFlag = this.ebikeCsMtrdevRelaHisDao.insert(ebikeCsMtrdevRelaHisDo);
                HashMap defAcqCommParams = Maps.newHashMap();
                defAcqCommParams.put("baudrate", "2400");
                defAcqCommParams.put("parity", "2");
                EbikeMeaspointMeterdeviceDo ebikeMeaspointMeterdeviceDo = new EbikeMeaspointMeterdeviceDo();
                ebikeMeaspointMeterdeviceDo.setMeaspointId(UuidUtils.generateUuidString());
                ebikeMeaspointMeterdeviceDo.setMeterdeviceId(ebikeAssetsMeterdevice.getMeterdeviceId());
                ebikeMeaspointMeterdeviceDo.setChargestationId(chargestationId);
                ebikeMeaspointMeterdeviceDo.setChargedeviceId(chargedeviceId);
                ebikeMeaspointMeterdeviceDo.setAcqCommMode((String)StringUtils.defaultIfBlank((CharSequence)acqCommMode, (CharSequence)"01"));
                ebikeMeaspointMeterdeviceDo.setAcqCommParams((Map)ObjectUtils.defaultIfNull((Object)acqCommParams, (Object)defAcqCommParams));
                ebikeMeaspointMeterdeviceDo.setCreateTime(new Date());
                ebikeMeaspointMeterdeviceDo.setUpdateTime(new Date());
                int measpointInsertFlag = this.ebikeMeaspointMeterdeviceDao.insert(ebikeMeaspointMeterdeviceDo);
                EbikeMeaspointMeterdeviceHisDo ebikeMeaspointMeterdeviceHisDo = new EbikeMeaspointMeterdeviceHisDo();
                try {
                    BeanUtils.copyProperties((Object)ebikeMeaspointMeterdeviceHisDo, (Object)ebikeMeaspointMeterdeviceDo);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.logger.error(e.getMessage(), e.fillInStackTrace());
                }
                ebikeMeaspointMeterdeviceHisDo.setIsVaild(Boolean.valueOf(true));
                int n = this.ebikeMeaspointMeterdeviceHisDao.insert(ebikeMeaspointMeterdeviceHisDo);
                return meterDeviceInstallResponse;
            }
            if (ebikeChargestationVo == null || ebikeChargestationVo.getChargestationId() == 0L) {
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("\u5145\u7535\u7ad9\u4e3a\u7a7a");
                return meterDeviceInstallResponse;
            } else if (StringUtils.equalsAny((CharSequence)ebikeChargestationVo.getRunStatus(), (CharSequence[])new CharSequence[]{"10", "40"})) {
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("\u5145\u7535\u7ad9\u72b6\u6001\u4e3a\u672a\u6295\u8fd0\u6216\u9000\u8fd0");
                return meterDeviceInstallResponse;
            } else {
                meterDeviceInstallResponse.setReturnCode("FAILURE");
                meterDeviceInstallResponse.setReturnMsg("\u5145\u7535\u7ad9\u4fe1\u606f\u6709\u8bef\uff08" + ebikeChargestationVo.getChargestationId() + "\uff09");
            }
            return meterDeviceInstallResponse;
        }
        meterDeviceInstallResponse.setReturnCode("FAILURE");
        meterDeviceInstallResponse.setReturnMsg("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5");
        return meterDeviceInstallResponse;
    }

    public MeterDeviceUninstallResponse uninstallMeterDevice(MeterDeviceUninstallRequest meterDeviceUninstallRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start uninstallMeterDevice >>>>>> ");
            this.logger.debug(" MeterDeviceUninstallRequest  : " + meterDeviceUninstallRequest);
        }
        MeterDeviceUninstallResponse meterDeviceUninstallResponse = new MeterDeviceUninstallResponse();
        return meterDeviceUninstallResponse;
    }
}

