package com.ebike.openservices.finmgmt.entity;

import java.io.Serializable;

public class BankCardEntity implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 6990277267040394839L;

    private String accountName;         // 开户人姓名
    private String bankcardNo;          // 银行卡号
    private String bankName;            // 开户银行

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankcardNo() {
        return bankcardNo;
    }

    public void setBankcardNo(String bankcardNo) {
        this.bankcardNo = bankcardNo;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((accountName == null) ? 0 : accountName.hashCode());
        result = prime * result + ((bankName == null) ? 0 : bankName.hashCode());
        result = prime * result + ((bankcardNo == null) ? 0 : bankcardNo.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null)
            return false;
        if(getClass() != obj.getClass())
            return false;
        BankCardEntity other = (BankCardEntity) obj;
        if(accountName == null) {
            if(other.accountName != null)
                return false;
        }
        else if(!accountName.equals(other.accountName))
            return false;
        if(bankName == null) {
            if(other.bankName != null)
                return false;
        }
        else if(!bankName.equals(other.bankName))
            return false;
        if(bankcardNo == null) {
            if(other.bankcardNo != null)
                return false;
        }
        else if(!bankcardNo.equals(other.bankcardNo))
            return false;
        return true;
    }

    @Override
    public String toString() {
        return "BankCardEntity [accountName=" + accountName + ", bankcardNo=" + bankcardNo + ", bankName=" + bankName
                + "]";
    }

}
