package com.ebike.openservices.finmgmt.entity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author liumu
 * @date 2021-08-10 17:50
 * 用能客户充值缴费请求记录
 */
@Data
public class CustAccoutRechargeRequestVo implements Serializable {

    private static final long serialVersionUID = -5651321651313513611L;

    /**
     * 充值缴费请求标识;SnowflakeId
     */
    private Long id;

    /**
     * 充值缴费请求时间
     */
    private Date rechargeRequestTime;

    /**
     * 充值缴费金额
     */
    private BigDecimal rechargeMoney;

    /**
     * 用能客户标识
     */
    private Long ceCustId;

    /**
     * 支付通道类型;ALIPAY - 支付宝支付；
     WXPAY - 微信支付；
     OFFLINE - 线下支付；
     */
    private String payChannelType;

    /**
     * 支付通道子类;ALIPAY_APPLET - 支付宝小程序；
     WXPAY_APPLET- 微信小程序；
     OFFLINE_CASH - 线下现金支付；
     */
    private String payChannelSubtype;

    /**
     * 支付通道编号;ALIPAY_APPLET_EBIKE - 支付宝小程序（驿吧）
     WXPAY_APPLET_EBIKE - 微信小程序支付（驿吧）
     OFFLINE_CASH_EBIKE - 线下现金支付（驿吧）
     */
    private String payChannelNo;

    /**
     * 备注
     */
    private String remark;

    /**
     * 附件地址
     */
    private String filesUrl;

    /**
     * 支付时间
     */
    private String payTime;

    /**
     * 支付结果;0 - 初始；1 - 支付成功；2 - 支付失败；
     */
    private Integer payResult;

    /**
     * 支付订单标识
     */
    private String payOrderId;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;

    /**
     * 是否已删除;逻辑删除（1 - 已删除；0 - 未删除；）
     */
    private Integer isDeleted;

    /**
     * 删除人;系统用户表用户编号字段（user_no）
     */
    private String deleter;

    /**
     * 删除时间;为0表示为空
     */
    private Long gmtDeleted;

    /**
     * 版本号;用于乐观锁
     */
    private Integer version;
}
