package com.ebike.openservices.finmgmt.request;

import com.easesource.data.bean.Pager;
import lombok.*;

import java.io.Serializable;

/**
 * @author lzx
 * @version 1.0
 * @date 2020/11/24 14:06
 */
@Data
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class UserInformationRequest implements Serializable {
    private String orgNo;
    /**
     * 充电用户标识，UUID
     */
    private String chargeUserId;
    /**
     * 充电用户名：
     * 如为“微信用户“，则充电用户名为微信标识；
     * 如为“卡用户“，则充电用户名为卡号；
     */
    private String chargeUserNo;
    /**
     * 微信token，访问微信接口需要此token，需要时更新
     */
    private String chargeUserToken;
    /**
     * 充电用户类型：10 - 微信用户；20 - 支付宝；90 - 投币用户；
     */
    private String chargeUserType;
    /**
     * 充电用户名称
     */
    private String chargeUserName;
    /**
     * 充电用户密码
     */
    private String chargeUserPasswd;
    /**
     * 充电用户手机号码
     */
    private String chargeUserMobile;
    /**
     * 充电用户地区
     */
    private String chargeUserRegion;
    /**
     * 是否有效，T - 是；F - 否
     */
    private String valid;
    /**
     * 注册时间
     */
    private String regTime;
    /**
     * 生效时间
     */
    private String effTime;
    /**
     * 所属商户号，sy - 数元；yz - 原智；zfb - 原智支付宝；
     */
    private String merchantNo;
    /**
     *
     */
    private String unionId;
    /**
     * 性别  0 未知  1：男 2：女
     */
    private String chargeUserSex;
    /**
     * 序号
     */
    private String key;
    /**
     * 页码
     */
    private Integer current;
    /**
     * 每页多少条数据
     */
    private Integer pageSize = 10;
    /**
     * 分页对象
     */
    private Pager pager;
}
