package com.ebike.openservices.finmgmt.service;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.finmgmt.entity.EbmktCmpnPachageVo;

import java.util.List;
import java.util.Map;

/**
 * @author donghouqiang 2019-06-26
 */
public interface EbmktPackageService {

    /**
     * 查询套餐活动初始化内容
     * @param map
     * @return
     */
    List<EbmktCmpnPachageVo> getPackageInfo(Map<String,Object> map);
    /**
     * 查询套餐活动初始化内容条数
     * @param map
     * @return
     */
    int getPackageInfoCount(Map<String,Object> map);


    /**
     * 查询电站信息
     * @param map
     * @return
     */
    List<EbmktCmpnPachageVo> getRelationStationInfo(Map<String,Object> map,Pager pager);
    /**
     * 查询电站信息条数
     * @param map
     * @return
     */
    int getStationInfoCount(Map<String,Object> map);

    /**
     * 新增套餐活动
     * @param pachageVo
     * @return
     */
    int insertEbmktPackage(EbmktCmpnPachageVo pachageVo);

    /**
     * 检验勾选的套餐活动是否符合规定
     * @param map
     * @return
     */
    int checkPackageExist(Map<String,Object> map);

    /**
     * 套餐编辑
     * @param map
     * @return
     */
    int updatePackage(Map<String, Object> map);

    /**
     * 通过ID查询信息
     * @param cmpnId
     * @return
     */
    EbmktCmpnPachageVo getPackageInfoById(String cmpnId);

    /**
     * 编辑
     * @param pachageVo
     * @return
     */
    int updateEbmktPackage(EbmktCmpnPachageVo pachageVo);

    /**
     * 查询用户的套餐使用情况
     * @param map
     * @return
     */
    List<Map<String,Object>>  getPackageUsage(Map<String,Object> map, Sorter var2,Pager var3);
    /**
     * 查询用户的套餐使用情况
     * @param map
     * @return
     */
    int getPackageUsageCount(Map<String,Object> map);

    /**
     * 获取某个用户的套餐消费流水
     * @param map
     * @return
     */
    List<Map<String,Object>>  getPackageAccountJournalByUserId(Map<String,Object> map);

    /**
     * 获取某个用户的套餐消费流水条数
     * @param map
     * @return
     */
    int  getPackageAccountJournalCountByUserId(Map<String,Object> map);

    /**
     * 获取某个套餐所关联的电站信息
     * @param cmpnId
     * @return
     */
    List<Map<String,String>> getRelationStationInfoByCmpnId(String cmpnId);

    /**
     * 获取某个套餐所关联的电站信息条数
     * @param cmpnId
     * @return
     */
    int getRelationStationCountByCmpnId(String cmpnId);

    /**
     * 获取套餐审核信息
     * @param map
     * @return
     */
    List<EbmktCmpnPachageVo>  getPackageAuditInfo(Map<String,Object> map);

    /**
     * 获取套餐审核条数
     * @param map
     * @return
     */
    int  getPackageAuditCountInfo(Map<String,Object> map);

    /**
     * 套餐审核
     * @param map
     * @return
     */
    int  packageAudit(Map<String,Object> map);
}
