package com.ebike.openservices.finmgmt.service;

import com.ebike.openservices.finmgmt.entity.CustAccountConsumeRecordVo;
import com.ebike.openservices.finmgmt.entity.CustAccoutRechargeRequestVo;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author liumu
 * @date 2021-08-10 17:25
 * 集团客户账务
 */
public interface GroupUserAccountService {

    /**
     * 添加充值记录
     *
     * @param params
     */
    void addRecharge(CustAccoutRechargeRequestVo params);

    /**
     * 获取充值记录
     *
     * @param customerId
     * @param pageSize
     * @param pageNo
     * @return
     */
    List<CustAccoutRechargeRequestVo> queryRechargeRecord(Long customerId,String startTime,String endTime, Integer pageSize, Integer pageNo);

    /**
     * 获取充值记录总数
     *
     * @param customerId
     * @return
     */
    Integer queryRechargeRecordCount(Long customerId,String startTime,String endTime);

    /**
     * 获取消费记录（集团客户下的用户）
     *
     * @param userId
     * @param startTime
     * @param endTime
     * @param vin
     * @param card
     * @param pageSize
     * @param pageNo
     * @return
     */
    List<CustAccountConsumeRecordVo> queryCustAccountConsumeRecord(String userId,
                                                                   String startTime,
                                                                   String endTime,
                                                                   String vin,
                                                                   String card,
                                                                   Integer pageSize,
                                                                   Integer pageNo);

    /**
     * 获取消费记录计数（集团客户下的用户）
     */
    Integer queryCustAccountConsumeRecordCount(String userId,
                                               String startTime,
                                               String endTime,
                                               String vin,
                                               String card);


    /**
     * 获取消费总金额
     * @param userId
     * @return
     */
    String queryCustAccountConsumeTotal(String userId);

}
