/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.finmgmt.jdbcdao.Impl;

import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.finmgmt.entity.EBikeChargeRecordParams;
import com.ebike.openservices.finmgmt.entity.EBikeChargeRecordVO;
import com.ebike.openservices.finmgmt.jdbcdao.EBikeChargeRecordDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository(value="ebikeChargeRecordDao")
public class EBikeChargeRecordDaoImpl
implements EBikeChargeRecordDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RowMapper<EBikeChargeRecordVO> ecrRowMapper = new RowMapper<EBikeChargeRecordVO>(){

        public EBikeChargeRecordVO mapRow(ResultSet rs, int rowNum) throws SQLException {
            EBikeChargeRecordVO ecr = new EBikeChargeRecordVO();
            ecr.setChargeRecordId(rs.getString("chargeRecordId"));
            ecr.setChargeUserId(rs.getString("chargeUserId"));
            ecr.setChargeUserNo(rs.getString("chargeUserNo"));
            ecr.setChargeUserType(rs.getString("chargeUserType"));
            ecr.setDeviceId(rs.getString("deviceId"));
            ecr.setPlugId(rs.getString("plugId"));
            ecr.setOrgNo(rs.getString("subburo"));
            ecr.setChargedeviceNo(rs.getString("chargedeviceNo"));
            ecr.setPlugSn(Integer.valueOf(rs.getInt("plugSn")));
            ecr.setChargeTime((Date)rs.getTimestamp("chargeTime"));
            ecr.setChargeMoney(Double.valueOf(rs.getDouble("chargeMoney")));
            ecr.setChargeTradeOrderId(rs.getString("chargeTradeOrderId"));
            ecr.setSchemeId(rs.getString("schemeId"));
            ecr.setSchemeType(rs.getString("schemeType"));
            ecr.setUnitPrice1(Double.valueOf(rs.getDouble("unitPrice1")));
            ecr.setUnitPrice2(Double.valueOf(rs.getDouble("unitPrice2")));
            ecr.setUnitPrice3(Double.valueOf(rs.getDouble("unitPrice3")));
            ecr.setMinCharge(Double.valueOf(rs.getDouble("minCharge")));
            ecr.setIsReturn(rs.getString("isReturn"));
            ecr.setCostSchemeId(rs.getString("costSchemeId"));
            ecr.setCostUnitPrice(Double.valueOf(rs.getDouble("costUnitPrice")));
            ecr.setChargeOpenFlag(Integer.valueOf(rs.getInt("chargeOpenFlag")));
            ecr.setChargeOpenTime((Date)rs.getTimestamp("chargeOpenTime"));
            ecr.setFirstUnitPriceFlag(Integer.valueOf(rs.getInt("firstUnitPriceFlag")));
            ecr.setFirstChargeAmount(Double.valueOf(rs.getDouble("firstChargeAmount")));
            ecr.setCurrUnitPriceFlag(Integer.valueOf(rs.getInt("currUnitPriceFlag")));
            ecr.setChargeAmount(Double.valueOf(rs.getDouble("chargeAmount")));
            ecr.setUsageAmount(Double.valueOf(rs.getDouble("usageAmount")));
            ecr.setSurplusAmount(Double.valueOf(rs.getDouble("surplusAmount")));
            ecr.setUsageElecCons(Double.valueOf(rs.getDouble("usageElecCons")));
            ecr.setRemainElecCons(Double.valueOf(rs.getDouble("remainElecCons")));
            ecr.setRemainTime(Double.valueOf(rs.getDouble("remainTime")));
            ecr.setMaxPower(Double.valueOf(rs.getDouble("maxPower")));
            ecr.setMinPower(Double.valueOf(rs.getDouble("minPower")));
            ecr.setAvgPower(Double.valueOf(rs.getDouble("avgPower")));
            ecr.setCurrPower(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "currPower") ? Double.valueOf(rs.getDouble("currPower")) : null);
            ecr.setUpdateTime(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "updateTime") ? rs.getTimestamp("updateTime") : null);
            ecr.setChargeFinishTime(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "chargeFinishTime") ? rs.getTimestamp("chargeFinishTime") : null);
            ecr.setFinishReason(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "finishReason") ? rs.getString("finishReason") : null);
            ecr.setFinishPower(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "finishPower") ? Double.valueOf(rs.getDouble("finishPower")) : null);
            ecr.setClosingFlag(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "closingFlag") ? rs.getString("closingFlag") : null);
            ecr.setClosingMoney(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "closingMoney") ? Double.valueOf(rs.getDouble("closingMoney")) : null);
            ecr.setClosingTime(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "closingTime") ? rs.getTimestamp("closingTime") : null);
            ecr.setReturnFlag(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "returnFlag") ? rs.getString("returnFlag") : null);
            ecr.setReturnMoney(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "returnMoney") ? Double.valueOf(rs.getDouble("returnMoney")) : null);
            ecr.setReturnTime(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "returnTime") ? rs.getTimestamp("returnTime") : null);
            ecr.setReturnDesc(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "returnDesc") ? rs.getString("returnDesc") : null);
            ecr.setReturnTradeOrderId(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "returnTradeOrderId") ? rs.getString("returnTradeOrderId") : null);
            ecr.setReturnSuccessTime(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "returnSuccessTime") ? rs.getTimestamp("returnSuccessTime") : null);
            ecr.setIncome(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "income") ? Double.valueOf(rs.getDouble("income")) : null);
            ecr.setCost(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "cost") ? Double.valueOf(rs.getDouble("cost")) : null);
            ecr.setProfit(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "profit") ? Double.valueOf(rs.getDouble("profit")) : null);
            ecr.setRemark(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "remark") ? rs.getString("remark") : null);
            ecr.setDistTradeOrderId(EBikeChargeRecordDaoImpl.this.isExistColumn(rs, "distTradeOrderId") ? rs.getString("distTradeOrderId") : null);
            return ecr;
        }
    };
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    private boolean isExistColumn(ResultSet rs, String columnName) {
        try {
            if (rs.findColumn(columnName) > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    private StringBuilder builderChargeRecordPreSQL(String tableName) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ecd.deviceId, ecp.plugId, pss.buro, pss.subburo, ecd.chargedeviceNo, ecp.plugSn, ecr.chargeUserId, cu.chargeUserNo, cu.chargeUserType, ecr.* ");
        sqlBuilder.append("  FROM ebike.").append((String)StringUtils.defaultIfEmpty((CharSequence)tableName, (CharSequence)"ebike_chargerecord_his")).append(" ecr ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.`id` = ecr.chargeplugId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.`id` = ecr.chargedeviceId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.`id` = ecd.`id` AND pss.className = 'EBikeChargeDevice' ");
        sqlBuilder.append("  LEFT JOIN ebike.ebike_chargeuser cu ON cu.chargeUserId = ecr.chargeUserId ");
        return sqlBuilder;
    }

    private StringBuilder builderChargeRecordIncomeDetailPreSQL() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ecd.deviceId, ecp.plugId, pss.buro, pss.subburo, ecd.chargedeviceNo, ecp.plugSn, ecr.chargeUserId, cu.chargeUserNo, cu.chargeUserType, ecr.*, crid.distTradeOrderId ");
        sqlBuilder.append("  FROM ebike.ebike_chargerecord_his ecr ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargeplug ecp ON ecp.`id` = ecr.chargeplugId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_ebikechargedevice ecd ON ecd.`id` = ecr.chargedeviceId ");
        sqlBuilder.append(" INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.`id` = ecd.`id` AND pss.className = 'EBikeChargeDevice' ");
        sqlBuilder.append("  LEFT JOIN ebike.ebike_chargeuser cu ON cu.chargeUserId = ecr.chargeUserId ");
        sqlBuilder.append(" INNER JOIN ebike.ebike_chargerecord_incomedetail crid ON crid.chargeRecordId = ecr.chargeRecordId ");
        return sqlBuilder;
    }

    @Autowired
    public EBikeChargeRecordDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<EBikeChargeRecordVO> getCurrentChargeRecordList(EBikeChargeRecordParams ebikeChargeRecordParams) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.ebikeJdbcTemplate.getDataSource());
        StringBuilder sqlBuilder = this.builderChargeRecordPreSQL("ebike_chargerecord");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sqlBuilder.append(" WHERE 1 = 1 ");
        if (StringUtils.isNotBlank((CharSequence)ebikeChargeRecordParams.getBuro())) {
            sqlBuilder.append("   AND pss.buro = :buro ");
            paramMap.put("buro", ebikeChargeRecordParams.getBuro());
        }
        if (StringUtils.isNotBlank((CharSequence)ebikeChargeRecordParams.getSubburo())) {
            sqlBuilder.append("   AND pss.subburo = :subburo ");
            paramMap.put("subburo", ebikeChargeRecordParams.getSubburo());
        }
        if (StringUtils.isNotBlank((CharSequence)ebikeChargeRecordParams.getStartTime())) {
            try {
                sqlBuilder.append("   AND ecr.chargeTime >= :startTime ");
                paramMap.put("startTime", DateUtils.addDays((Date)DateUtils.parseDate((String)ebikeChargeRecordParams.getStartTime(), (String[])new String[]{"yyyy-MM-dd hh:mm:ss"}), (int)0));
            }
            catch (ParseException _pe) {
                this.logger.error(_pe.getMessage(), _pe.fillInStackTrace());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)ebikeChargeRecordParams.getEndTime())) {
            try {
                sqlBuilder.append("   AND ecr.chargeTime <= :endTime ");
                paramMap.put("endTime", DateUtils.addDays((Date)DateUtils.parseDate((String)ebikeChargeRecordParams.getEndTime(), (String[])new String[]{"yyyy-MM-dd hh:mm:ss"}), (int)2));
            }
            catch (ParseException _pe) {
                this.logger.error(_pe.getMessage(), _pe.fillInStackTrace());
            }
        }
        if (ebikeChargeRecordParams.getChargeOrderIds() != null && ebikeChargeRecordParams.getChargeOrderIds().size() > 0) {
            sqlBuilder.append("   AND chargeTradeOrderId in (:chargeOrderIds) ");
            paramMap.put("chargeOrderIds", ebikeChargeRecordParams.getChargeOrderIds());
        }
        return namedParameterJdbcTemplate.query(sqlBuilder.toString(), paramMap, this.ecrRowMapper);
    }

    @Override
    public List<EBikeChargeRecordVO> getHistoryChargeRecordList(EBikeChargeRecordParams ebikeChargeRecordParams) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.ebikeJdbcTemplate.getDataSource());
        StringBuilder sqlBuilder = this.builderChargeRecordPreSQL("ebike_chargerecord_his");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sqlBuilder.append(" WHERE 1 = 1 ");
        if (StringUtils.isNotBlank((CharSequence)ebikeChargeRecordParams.getBuro())) {
            sqlBuilder.append("   AND pss.buro = :buro ");
            paramMap.put("buro", ebikeChargeRecordParams.getBuro());
        }
        if (StringUtils.isNotBlank((CharSequence)ebikeChargeRecordParams.getSubburo())) {
            sqlBuilder.append("   AND pss.subburo = :subburo ");
            paramMap.put("subburo", ebikeChargeRecordParams.getSubburo());
        }
        if (StringUtils.isNotBlank((CharSequence)ebikeChargeRecordParams.getStartTime())) {
            try {
                sqlBuilder.append("   AND ecr.chargeTime >= :startTime ");
                paramMap.put("startTime", DateUtils.addDays((Date)DateUtils.parseDate((String)ebikeChargeRecordParams.getStartTime(), (String[])new String[]{"yyyy-MM-dd hh:mm:ss"}), (int)0));
            }
            catch (ParseException _pe) {
                this.logger.error(_pe.getMessage(), _pe.fillInStackTrace());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)ebikeChargeRecordParams.getEndTime())) {
            try {
                sqlBuilder.append("   AND ecr.chargeTime <= :endTime ");
                paramMap.put("endTime", DateUtils.addDays((Date)DateUtils.parseDate((String)ebikeChargeRecordParams.getEndTime(), (String[])new String[]{"yyyy-MM-dd hh:mm:ss"}), (int)2));
            }
            catch (ParseException _pe) {
                this.logger.error(_pe.getMessage(), _pe.fillInStackTrace());
            }
        }
        if (ebikeChargeRecordParams.getChargeOrderIds() != null && ebikeChargeRecordParams.getChargeOrderIds().size() > 0) {
            sqlBuilder.append("   AND chargeTradeOrderId in (:chargeOrderIds) ");
            paramMap.put("chargeOrderIds", ebikeChargeRecordParams.getChargeOrderIds());
        }
        if (ebikeChargeRecordParams.getReturnOrderIds() != null && ebikeChargeRecordParams.getReturnOrderIds().size() > 0) {
            sqlBuilder.append("   AND returnTradeOrderId in (:returnOrderIds) ");
            paramMap.put("returnOrderIds", ebikeChargeRecordParams.getReturnOrderIds());
        }
        return namedParameterJdbcTemplate.query(sqlBuilder.toString(), paramMap, this.ecrRowMapper);
    }

    @Override
    public List<EBikeChargeRecordVO> getHistoryChargeRecordListByIncomeDetail(EBikeChargeRecordParams ebikeChargeRecordParams) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.ebikeJdbcTemplate.getDataSource());
        StringBuilder sqlBuilder = this.builderChargeRecordIncomeDetailPreSQL();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sqlBuilder.append(" WHERE 1 = 1 ");
        if (StringUtils.isNotBlank((CharSequence)ebikeChargeRecordParams.getStartTime())) {
            try {
                sqlBuilder.append("   AND ecr.chargeTime >= :startTime ");
                paramMap.put("startTime", DateUtils.addDays((Date)DateUtils.parseDate((String)ebikeChargeRecordParams.getStartTime(), (String[])new String[]{"yyyy-MM-dd hh:mm:ss"}), (int)0));
            }
            catch (ParseException _pe) {
                this.logger.error(_pe.getMessage(), _pe.fillInStackTrace());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)ebikeChargeRecordParams.getEndTime())) {
            try {
                sqlBuilder.append("   AND ecr.chargeTime <= :endTime ");
                paramMap.put("endTime", DateUtils.addDays((Date)DateUtils.parseDate((String)ebikeChargeRecordParams.getEndTime(), (String[])new String[]{"yyyy-MM-dd hh:mm:ss"}), (int)2));
            }
            catch (ParseException _pe) {
                this.logger.error(_pe.getMessage(), _pe.fillInStackTrace());
            }
        }
        if (ebikeChargeRecordParams.getChargeOrderIds() != null && ebikeChargeRecordParams.getChargeOrderIds().size() > 0) {
            sqlBuilder.append("   AND crid.distUserType = 'platform_org' AND crid.distUserId = :subburo AND crid.distTradeOrderId IN (:chargeOrderIds) ");
            paramMap.put("subburo", ebikeChargeRecordParams.getSubburo());
            paramMap.put("chargeOrderIds", ebikeChargeRecordParams.getChargeOrderIds());
        }
        return namedParameterJdbcTemplate.query(sqlBuilder.toString(), paramMap, this.ecrRowMapper);
    }

    @Override
    public EBikeChargeRecordVO getCurrentChargeRecordDetail(String chargeRecordId) {
        StringBuilder sqlBuilder = this.builderChargeRecordPreSQL("ebike_chargerecord");
        sqlBuilder.append(" WHERE chargeRecordId = ? ");
        EBikeChargeRecordVO ecr = null;
        try {
            ecr = (EBikeChargeRecordVO)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), new Object[]{chargeRecordId}, this.ecrRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            ecr = null;
        }
        return ecr;
    }

    @Override
    public EBikeChargeRecordVO getHistoryChargeRecordDetail(String chargeRecordId) {
        StringBuilder sqlBuilder = this.builderChargeRecordPreSQL("ebike_chargerecord_his");
        sqlBuilder.append(" WHERE chargeRecordId = ? ");
        EBikeChargeRecordVO ecr = null;
        try {
            ecr = (EBikeChargeRecordVO)this.ebikeJdbcTemplate.queryForObject(sqlBuilder.toString(), new Object[]{chargeRecordId}, this.ecrRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            ecr = null;
        }
        return ecr;
    }

    @Override
    public List<Map<String, String>> getBankAccountList(String orgNo) {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" SELECT bankCardNo  FROM ebike.ebike_orgacct_bcbinding  WHERE 1=1 ");
        sql.append(" and subburo= ? ", (Object)orgNo);
        try {
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (rs, rownum) -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rs.getString("bankCardNo"));
                return map;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }
}

