/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.finmgmt.jdbcdao.Impl;

import com.easesource.commons.util.UuidUtils;
import com.ebike.openservices.finmgmt.entity.MjyddzbdParams;
import com.ebike.openservices.finmgmt.entity.MjyddzcxParams;
import com.ebike.openservices.finmgmt.jdbcdao.MjyddzglDao;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository(value="mjyddzglDao")
public class MjyddzglDaoImpl
implements MjyddzglDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public MjyddzglDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public Integer getApplyBindconsCount(MjyddzcxParams params) {
        this.logger.info("getApplyBindconsCount : " + params.toString());
        if (StringUtils.isBlank((CharSequence)params.getOrgNo())) {
            return 0;
        }
        Map<String, Object> map = this.mapApplyBindconsList(params);
        return (Integer)this.ebikeJdbcTemplate.queryForObject((String)map.get("sqlCount"), (Object[])map.get("paramsCount"), Integer.class);
    }

    @Override
    public List<?> getApplyBindconsList(final MjyddzcxParams params) {
        this.logger.info("getApplyBindconsList  : " + params.toString());
        if (StringUtils.isBlank((CharSequence)params.getOrgNo())) {
            return new ArrayList();
        }
        Map<String, Object> map = this.mapApplyBindconsList(params);
        List list = this.ebikeJdbcTemplate.query((String)map.get("sqlGrid"), (Object[])map.get("paramsGrid"), (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int i) throws SQLException {
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put("SN", i + 1 + params.getStart());
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int j = 1; j <= rsmd.getColumnCount(); ++j) {
                    record.put(StringUtils.upperCase((String)rsmd.getColumnLabel(j)), rs.getString(j));
                }
                return record;
            }
        });
        return list;
    }

    @Override
    public Integer getConsBindingCount(MjyddzcxParams params) {
        this.logger.info("getConsBindingCount : " + params.toString());
        if (StringUtils.isBlank((CharSequence)params.getOrgNo())) {
            return 0;
        }
        Map<String, Object> map = this.mapConsBindingList(params);
        return (Integer)this.ebikeJdbcTemplate.queryForObject((String)map.get("sqlCount"), (Object[])map.get("paramsCount"), Integer.class);
    }

    @Override
    public List<?> getConsBindingList(final MjyddzcxParams params) {
        this.logger.info("getConsBindingList  : " + params.toString());
        if (StringUtils.isBlank((CharSequence)params.getOrgNo())) {
            return new ArrayList();
        }
        Map<String, Object> map = this.mapConsBindingList(params);
        List list = this.ebikeJdbcTemplate.query((String)map.get("sqlGrid"), (Object[])map.get("paramsGrid"), (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int i) throws SQLException {
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put("SN", i + 1 + params.getStart());
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int j = 1; j <= rsmd.getColumnCount(); ++j) {
                    record.put(StringUtils.upperCase((String)rsmd.getColumnLabel(j)), rs.getString(j));
                }
                return record;
            }
        });
        return list;
    }

    private Map<String, Object> mapApplyBindconsList(MjyddzcxParams params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String sql_select_count = "SELECT COUNT(DISTINCT eab.APPLY_ID) AS CNT ";
        String sql_select_list = "SELECT eab.APPLY_ID, eb.BUYER_NO, eb.BUYER_NAME, eb.BUYER_MOBILE, DATE_FORMAT(eab.APPLY_TIME,'%Y-%m-%d %H:%i:%s') AS APPLY_TIME , eab.CHECKER, DATE_FORMAT(eab.CHECK_TIME,'%Y-%m-%d %H:%i:%s') AS CHECK_TIME, eab.CHECK_RESULT, eab.CHECK_REMARK , GROUP_CONCAT(cons.ID ORDER BY cons.ID) AS CONSIDS, GROUP_CONCAT(cons.`NAME` ORDER BY cons.ID) AS CONSNAMES ";
        String sql_from = "  FROM zndw.ecs_apply_bindcons eab  INNER JOIN zndw.ecs_applydetail_bindcons eadb ON eadb.APPLY_ID = eab.APPLY_ID  INNER JOIN cisp_dev.dev_consumer cons ON cons.ID = eadb.CONSID  INNER JOIN zndw.ecs_buyer eb ON eb.BUYER_ID = eab.BUYER_ID ";
        String sql_where = " WHERE EXISTS (SELECT 1 FROM cisp_sys.bp_org _org WHERE _org.ORG_NO = cons.SUBBURO AND FIND_IN_SET(_org.ORG_NO, cisp_sys.getChildOrg(?)))  AND eab.APPLY_TIME >= STR_TO_DATE(?, '%Y-%m-%d') AND eab.APPLY_TIME < DATE_ADD(STR_TO_DATE(?, '%Y-%m-%d'), INTERVAL 1 DAY)  AND (cons.`NAME` LIKE ? OR cons.ELECADDR LIKE ?) ";
        String sql_groupby = " GROUP BY eab.APPLY_ID ";
        String sql_orderby = " ORDER BY eab.APPLY_TIME ASC ";
        String sql_limit = " LIMIT ?, ? ";
        StringBuffer sqlGridSb = new StringBuffer();
        StringBuffer sqlCountSb = new StringBuffer();
        ArrayList<Object> paramsGrid = new ArrayList<Object>();
        ArrayList<String> paramsCount = new ArrayList<String>();
        sqlGridSb.append(sql_select_list);
        sqlGridSb.append(sql_from);
        sqlGridSb.append(sql_where);
        paramsGrid.add(params.getOrgNo());
        paramsGrid.add(params.getSdate());
        paramsGrid.add(params.getEdate());
        paramsGrid.add("%" + params.getConsName() + "%");
        paramsGrid.add("%" + params.getConsName() + "%");
        if (StringUtils.isBlank((CharSequence)params.getCheckResult())) {
            sqlGridSb.append(" AND (eab.CHECK_RESULT IS NULL OR eab.CHECK_RESULT = '') ");
        } else if (!StringUtils.equalsIgnoreCase((CharSequence)params.getCheckResult(), (CharSequence)"ALL")) {
            sqlGridSb.append(" AND eab.CHECK_RESULT = ? ");
            paramsGrid.add(params.getCheckResult());
        }
        sqlGridSb.append(sql_groupby);
        sqlGridSb.append(sql_orderby);
        sqlGridSb.append(sql_limit);
        paramsGrid.add(params.getStart());
        paramsGrid.add(params.getLimit());
        sqlCountSb.append(sql_select_count);
        sqlCountSb.append(sql_from);
        sqlCountSb.append(sql_where);
        paramsCount.add(params.getOrgNo());
        paramsCount.add(params.getSdate());
        paramsCount.add(params.getEdate());
        paramsCount.add("%" + params.getConsName() + "%");
        paramsCount.add("%" + params.getConsName() + "%");
        if (StringUtils.isBlank((CharSequence)params.getCheckResult())) {
            sqlCountSb.append(" AND (eab.CHECK_RESULT IS NULL OR eab.CHECK_RESULT = '') ");
        } else if (!StringUtils.equalsIgnoreCase((CharSequence)params.getCheckResult(), (CharSequence)"ALL")) {
            sqlCountSb.append(" AND eab.CHECK_RESULT = ? ");
            paramsCount.add(params.getCheckResult());
        }
        map.put("sqlCount", sqlCountSb.toString());
        map.put("paramsCount", paramsCount.toArray());
        map.put("sqlGrid", sqlGridSb.toString());
        map.put("paramsGrid", paramsGrid.toArray());
        return map;
    }

    private Map<String, Object> mapConsBindingList(MjyddzcxParams params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String sql_select_count = "SELECT COUNT(DISTINCT cons.ID) AS CNT ";
        String sql_select_list = "SELECT cons.ID AS CONSID, cons.CONSNO, cons.`NAME` AS CONSNAME, ecb.CREDIT_LIMITS, DATE_FORMAT(ecb.ZERO_DATE,'%Y-%m-%d') AS ZERO_DATE, ecb.CHECKER, DATE_FORMAT(ecb.CHECK_PASS_TIME,'%Y-%m-%d %H:%i:%s') AS CHECK_PASS_TIME, eb.BUYER_ID, eb.BUYER_NO, eb.BUYER_NAME, eb.BUYER_MOBILE ";
        String sql_from = "  FROM cisp_dev.dev_consumer cons   LEFT JOIN zndw.ecs_cons_binding ecb ON ecb.CONSID = cons.ID   LEFT JOIN zndw.ecs_buyer eb ON eb.BUYER_ID = ecb.BUYER_ID ";
        String sql_where = " WHERE EXISTS (SELECT 1 FROM cisp_sys.bp_org _org WHERE _org.ORG_NO = cons.SUBBURO AND FIND_IN_SET(_org.ORG_NO, cisp_sys.getChildOrg(?)))  AND (cons.`NAME` LIKE ? OR cons.ELECADDR LIKE ?) ";
        String sql_orderby = " ORDER BY cons.CONSNO ";
        String sql_limit = " LIMIT ?, ? ";
        StringBuffer sqlGridSb = new StringBuffer();
        StringBuffer sqlCountSb = new StringBuffer();
        ArrayList<Object> paramsGrid = new ArrayList<Object>();
        ArrayList<String> paramsCount = new ArrayList<String>();
        sqlGridSb.append(sql_select_list);
        sqlGridSb.append(sql_from);
        sqlGridSb.append(sql_where);
        paramsGrid.add(params.getOrgNo());
        paramsGrid.add("%" + params.getConsName() + "%");
        paramsGrid.add("%" + params.getConsName() + "%");
        if (StringUtils.equalsIgnoreCase((CharSequence)params.getBindStatus(), (CharSequence)"01")) {
            sqlGridSb.append(" AND eb.BUYER_ID IS NOT NULL AND eb.BUYER_ID <> '' ");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)params.getBindStatus(), (CharSequence)"02")) {
            sqlGridSb.append(" AND (eb.BUYER_ID IS NULL OR eb.BUYER_ID = '') ");
        }
        sqlGridSb.append(sql_orderby);
        sqlGridSb.append(sql_limit);
        paramsGrid.add(params.getStart());
        paramsGrid.add(params.getLimit());
        sqlCountSb.append(sql_select_count);
        sqlCountSb.append(sql_from);
        sqlCountSb.append(sql_where);
        paramsCount.add(params.getOrgNo());
        paramsCount.add("%" + params.getConsName() + "%");
        paramsCount.add("%" + params.getConsName() + "%");
        if (StringUtils.equalsIgnoreCase((CharSequence)params.getBindStatus(), (CharSequence)"01")) {
            sqlCountSb.append(" AND eb.BUYER_ID IS NOT NULL AND eb.BUYER_ID <> '' ");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)params.getBindStatus(), (CharSequence)"02")) {
            sqlCountSb.append(" AND (eb.BUYER_ID IS NULL OR eb.BUYER_ID = '') ");
        }
        map.put("sqlCount", sqlCountSb.toString());
        map.put("paramsCount", paramsCount.toArray());
        map.put("sqlGrid", sqlGridSb.toString());
        map.put("paramsGrid", paramsGrid.toArray());
        return map;
    }

    @Override
    public Integer getHasBindConsCount(String applyId) {
        StringBuffer sqlCountSb = new StringBuffer();
        ArrayList<String> paramsCount = new ArrayList<String>();
        sqlCountSb.append("SELECT COUNT(DISTINCT c.CONSID) AS CNT ");
        sqlCountSb.append("  FROM zndw.ecs_applydetail_bindcons ad ");
        sqlCountSb.append(" INNER JOIN zndw.ecs_apply_bindcons a ON a.APPLY_ID = ad.APPLY_ID ");
        sqlCountSb.append(" INNER JOIN zndw.ecs_cons_binding c ON c.CONSID = ad.CONSID ");
        sqlCountSb.append(" WHERE a.APPLY_ID = ? ");
        paramsCount.add(applyId);
        return (Integer)this.ebikeJdbcTemplate.queryForObject(sqlCountSb.toString(), paramsCount.toArray(), Integer.class);
    }

    @Override
    public Integer insertConsBinding(MjyddzbdParams params) {
        StringBuffer sbInsert = new StringBuffer();
        ArrayList<String> paramsInsert = new ArrayList<String>();
        sbInsert.append("INSERT INTO zndw.ecs_cons_binding (CONSID, BURO, SUBBURO, BUYER_ID, CREDIT_LIMITS, ZERO_DATE, CHECKER, CHECK_PASS_TIME) ");
        sbInsert.append("SELECT c.ID AS CONSID, c.BURO, c.SUBBURO, a.BUYER_ID, ? AS CREDIT_LIMITS, ? AS ZERO_DATE, ? AS CHECKER, SYSDATE() AS CHECK_PASS_TIME ");
        paramsInsert.add(params.getCreditLimits());
        paramsInsert.add(params.getZeroDate());
        paramsInsert.add(params.getChecker());
        sbInsert.append("  FROM zndw.ecs_applydetail_bindcons ad ");
        sbInsert.append(" INNER JOIN zndw.ecs_apply_bindcons a ON a.APPLY_ID = ad.APPLY_ID ");
        sbInsert.append(" INNER JOIN cisp_dev.dev_consumer c ON c.ID = ad.CONSID ");
        sbInsert.append(" WHERE a.APPLY_ID = ? ");
        paramsInsert.add(params.getApplyId());
        Integer result = 0;
        try {
            result = this.ebikeJdbcTemplate.update(sbInsert.toString(), paramsInsert.toArray());
        }
        catch (DataAccessException _dae) {
            this.logger.error("insertConsBinding error", _dae.fillInStackTrace());
            result = -1;
        }
        return result;
    }

    @Override
    public Integer updateBindApplication(MjyddzbdParams params) {
        StringBuffer sbUpdate = new StringBuffer();
        ArrayList<String> paramsUpdate = new ArrayList<String>();
        sbUpdate.append("UPDATE zndw.ecs_apply_bindcons a ");
        sbUpdate.append("   SET a.CHECKER = ?, a.CHECK_TIME = SYSDATE(), a.CHECK_RESULT = ?, a.CHECK_REMARK = ? ");
        paramsUpdate.add(params.getChecker());
        paramsUpdate.add(params.getCheckResult());
        paramsUpdate.add(params.getCheckRemark());
        sbUpdate.append(" WHERE a.APPLY_ID = ? ");
        paramsUpdate.add(params.getApplyId());
        Integer result = 0;
        try {
            result = this.ebikeJdbcTemplate.update(sbUpdate.toString(), paramsUpdate.toArray());
        }
        catch (DataAccessException _dae) {
            this.logger.error("updateBindApplication error", _dae.fillInStackTrace());
            result = -1;
        }
        return result;
    }

    @Override
    public Integer deleteConsBinding(Long consId, String unbinder) {
        StringBuffer sbInsert = new StringBuffer();
        ArrayList<String> paramsInsert = new ArrayList<String>();
        sbInsert.append("INSERT INTO zndw.ecs_log_cons_unbinding (LOG_ID, CONSID, BURO, SUBBURO, BUYER_ID, CREDIT_LIMITS, ZERO_DATE, CHECKER, CHECK_PASS_TIME, UNBINDER, UNBIND_TIME) ");
        sbInsert.append("SELECT ? AS LOG_ID, CONSID, BURO, SUBBURO, BUYER_ID, CREDIT_LIMITS, ZERO_DATE, CHECKER, CHECK_PASS_TIME, ? AS UNBINDER, SYSDATE() UNBIND_TIME ");
        paramsInsert.add(UuidUtils.generateUuidString());
        paramsInsert.add(unbinder);
        sbInsert.append("  FROM zndw.ecs_cons_binding ");
        sbInsert.append(" WHERE CONSID = ? ");
        paramsInsert.add(String.valueOf(consId));
        Integer ilResult = 0;
        try {
            ilResult = this.ebikeJdbcTemplate.update(sbInsert.toString(), paramsInsert.toArray());
        }
        catch (DataAccessException _dae) {
            this.logger.error("deleteConsBinding insert log error", _dae.fillInStackTrace());
            ilResult = -1;
        }
        if (ilResult > 0) {
            StringBuffer sbDelete = new StringBuffer();
            ArrayList<String> paramsDelete = new ArrayList<String>();
            sbDelete.append("DELETE FROM zndw.ecs_cons_binding ");
            sbDelete.append(" WHERE CONSID = ? ");
            paramsDelete.add(String.valueOf(consId));
            Integer result = 0;
            try {
                result = this.ebikeJdbcTemplate.update(sbDelete.toString(), paramsDelete.toArray());
            }
            catch (DataAccessException _dae) {
                this.logger.error("deleteConsBinding error", _dae.fillInStackTrace());
                result = -1;
            }
            return result;
        }
        return ilResult;
    }
}

