/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.finmgmt.jdbcdao.Impl;

import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.finmgmt.entity.EbmktCmpnVo;
import com.ebike.openservices.finmgmt.jdbcdao.RechargeDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class RechargeDaoImpl
implements RechargeDao {
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public RechargeDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public int getRechargeNo() {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select  MAX(cast(a.cmpn_no as SIGNED INTEGER))  from ebmkt.ebmkt_cmpn  a  ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public boolean checkRechargeExist(String cmpnNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append(" select  count(1)  from ebmkt.ebmkt_cmpn where 1=1   ");
            sql.append(" and cmpn_no=? ", (Object)cmpnNo);
            result = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            return false;
        }
        return result > 0;
    }

    @Override
    public boolean addRecharge(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        String uuid = UuidUtils.generateUuidString();
        try {
            sql.append(" insert into ebmkt.ebmkt_cmpn (cmpn_id,cmpn_no,cmpn_type,cmpn_status,");
            sql.append(" cmpn_name,cmpn_startdate,cmpn_enddate,cmpn_part_limit,valid,creator,create_time) ");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?,?) ");
            result = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, map.get("PromotionNo"), "RECHARGE", "01", map.get("PromotionTitle"), new Date(), map.get("endDay"), map.get("partakeCount"), 0, map.get("orgName"), new Date()});
            this.logger.debug("++++++++++addRecharge+++++++++++" + sql.toString());
            result = this.updateCmpnRecharge(uuid, map);
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("auditResult", "01");
            paramsMap.put("auditInfo", "\u6d3b\u52a8\u65b0\u589e");
            paramsMap.put("orgName", map.get("orgName"));
            this.insertOperationLog(paramsMap, uuid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0;
    }

    public int updateCmpnRecharge(String uuid, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append(" replace into ebmkt.ebmkt_cmpn_recharge (cmpn_id,recharge_money,presend_redpkt_money) ");
            sql.append(" values(?,?,?) ");
            result = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, map.get("RechargeMoney"), map.get("giveMoney")});
            this.logger.debug("++++++++++updateCmpnRecharge+++++++++++" + sql.toString());
        }
        catch (Exception ex) {
            return 0;
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> getReChargeData(Map<String, String> map, int start) {
        this.logger.debug(" startstart " + start);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        boolean result = false;
        try {
            sql.append(" select a.cmpn_id,a.cmpn_name,a.cmpn_no,a.cmpn_enddate,a.cmpn_part_limit,b.presend_redpkt_money,b.recharge_money,  ");
            sql.append("  case WHEN a.cmpn_status='04' then '\u5f85\u5ba1\u6838' when a.cmpn_status='02' then '\u5df2\u53d1\u5e03' when a.cmpn_status='06' then '\u5ba1\u6838\u4e0d\u901a\u8fc7' ");
            sql.append("  when a.cmpn_status='01' then '\u5f85\u63d0\u4ea4' when a.cmpn_status='03' then '\u5df2\u64a4\u4e0b' end cmpn_status ");
            sql.append(" from ebmkt.ebmkt_cmpn a left join ebmkt.ebmkt_cmpn_recharge b on a.cmpn_id=b.cmpn_id where 1=1  and a.cmpn_type='RECHARGE' ");
            sql.append(" and a.cmpn_status=? ", (Object)map.get("ReChargeStatus"));
            sql.append(" and a.cmpn_name like ? ", (Object)("%" + map.get("Titles") + "%"));
            sql.append(" order by field(a.cmpn_status,'02','01','04','06','03') asc , a.create_time desc ");
            if (start == 1) {
                sql.append(" limit 0,10 ");
            } else {
                int starts = (start - 1) * 10;
                int end = start * 10;
                sql.append(" limit ? ", (Object)starts);
                sql.append(" , 10 ");
            }
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("cmpn_id", rs.getString("cmpn_id"));
                    map.put("cmpn_name", rs.getString("cmpn_name"));
                    map.put("cmpn_no", rs.getString("cmpn_no"));
                    map.put("cmpn_status", rs.getString("cmpn_status"));
                    map.put("cmpn_enddate", DateConvertUtils.convertToString((Date)rs.getTimestamp("cmpn_enddate"), (String)"yyyy-MM-dd"));
                    map.put("cmpn_part_limit", rs.getInt("cmpn_part_limit"));
                    map.put("presend_redpkt_money", rs.getDouble("presend_redpkt_money"));
                    map.put("recharge_money", rs.getDouble("recharge_money"));
                    return map;
                }
            });
            this.logger.debug("++++++++++getReChargeData+++++++++++" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getReChargeCount(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebmkt.ebmkt_cmpn a left join ebmkt.ebmkt_cmpn_recharge b on a.cmpn_id=b.cmpn_id where 1=1  and a.cmpn_type='RECHARGE'  ");
            sql.append(" and a.cmpn_status=? ", (Object)map.get("ReChargeStatus"));
            sql.append(" and a.cmpn_name like ? ", (Object)("%" + map.get("Titles") + "%"));
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean modifyOrRelease(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append(" update  ebmkt.ebmkt_cmpn set ");
            sql.append(" cmpn_name=?", (Object)map.get("PromotionTitle"));
            sql.append(" ,cmpn_startdate=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd"));
            sql.append(" ,cmpn_enddate=?", (Object)map.get("endDay"));
            sql.append(" ,cmpn_part_limit=?", (Object)map.get("partakeCount"));
            if ("1".equals(map.get("flag"))) {
                sql.append(" ,cmpn_status='04' ");
                sql.append(" ,valid=1 ");
            } else {
                sql.append(" ,cmpn_status='01' ");
                sql.append(" ,valid=1 ");
            }
            sql.append(" where 1=1 and cmpn_id in (?)", (Object)map.get("id"), ",");
            result = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            this.logger.debug("++++++++++addRecharge+++++++++++" + sql.toString());
            result = this.updateCmpnRecharge(map.get("id"), map);
            String[] cmpnId = map.get("logCmpnIds").split(",");
            if ("1".equals(map.get("flag"))) {
                for (int i = 0; i < cmpnId.length; ++i) {
                    HashMap<String, String> paramsMap = new HashMap<String, String>();
                    paramsMap.put("auditResult", "04");
                    paramsMap.put("auditInfo", "\u6d3b\u52a8\u63d0\u4ea4");
                    paramsMap.put("orgName", map.get("orgName"));
                    this.insertOperationLog(paramsMap, cmpnId[i]);
                }
            } else {
                for (int i = 0; i < cmpnId.length; ++i) {
                    HashMap<String, String> paramsMap = new HashMap<String, String>();
                    paramsMap.put("auditResult", "01");
                    paramsMap.put("auditInfo", "\u6d3b\u52a8\u7f16\u8f91");
                    paramsMap.put("orgName", map.get("orgName"));
                    this.insertOperationLog(paramsMap, cmpnId[i]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0;
    }

    @Override
    public boolean stopRecharge(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append(" update  ebmkt.ebmkt_cmpn set ");
            sql.append(" repealer=?", (Object)map.get("orgName"));
            sql.append(" ,repeal_time=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy.MM.dd HH:mm:ss"));
            sql.append(" ,cmpn_status='03' ");
            sql.append(" ,valid=0 ");
            sql.append(" where 1=1 and cmpn_id in (?) ", (Object)map.get("id"), ",");
            result = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            this.logger.debug("++++++++++addRecharge+++++++++++" + sql.toString());
            String[] cmpnId = map.get("id").split(",");
            for (int i = 0; i < cmpnId.length; ++i) {
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("auditResult", "03");
                paramsMap.put("auditInfo", map.get("logValue"));
                paramsMap.put("orgName", map.get("orgName"));
                this.insertOperationLog(paramsMap, cmpnId[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0;
    }

    @Override
    public List<Map<String, String>> getReChargeExpireId() {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            sql.append(" select cmpn_id from ebmkt.ebmkt_cmpn where 1=1 and DATE_FORMAT(NOW(),'%Y-%m-%d')> DATE_FORMAT(cmpn_enddate,'%Y-%m-%d')   and cmpn_status='02'  and cmpn_type='RECHARGE'  ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("cmpn_id", rs.getString("cmpn_id"));
                    return map;
                }
            });
            this.logger.debug("++++++++++getReChargeExpireId+++++++++++" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public boolean stopReChargeExpire(String cmpnId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        String[] ids = cmpnId.split(",");
        try {
            sql.append(" update  ebmkt.ebmkt_cmpn set valid=0,repealer='\u5e73\u53f0\u5230\u671f\u81ea\u52a8\u64a4\u4e0b' ");
            sql.append(" ,repeal_time=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy.MM.dd HH:mm:ss"));
            sql.append(" ,cmpn_status = CASE cmpn_id ");
            for (String stationId : ids) {
                sql.append(" WHEN ? ", (Object)stationId);
                sql.append(" THEN '03' ");
            }
            sql.append(" END where 1=1 ");
            sql.append(" and cmpn_id in (?) ", (Object)cmpnId, ",");
            result = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0;
    }

    @Override
    public boolean checkReChargeMoney(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append(" select count(1) from ebmkt.ebmkt_cmpn a  left join ebmkt.ebmkt_cmpn_recharge b on a.cmpn_id=b.cmpn_id where 1=1  and a.cmpn_status='02' ");
            sql.append(" and b.recharge_money=?", (Object)map.get("RechargeMoney"));
            sql.append(" and a.cmpn_id not in (?) ", (Object)map.get("id"), ",");
            result = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0;
    }

    @Override
    public String getCmpnName(String cmpnId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select a.cmpn_name from ebmkt.ebmkt_cmpn a  left join ebmkt.ebmkt_cmpn_recharge b on a.cmpn_id=b.cmpn_id where 1=1  ");
            sql.append(" and a.cmpn_id=? ", (Object)cmpnId);
            return (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    @Override
    public List<EbmktCmpnVo> getAuditInfo(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Object> list = new ArrayList<EbmktCmpnVo>();
        try {
            sql.append("  select a.cmpn_id,a.cmpn_name,a.cmpn_enddate,a.cmpn_type,b.presend_redpkt_money,b.recharge_money,case WHEN a.cmpn_status='04' then '\u5f85\u5ba1\u6838' when a.cmpn_status='02' then '\u5ba1\u6838\u901a\u8fc7' when a.cmpn_status='06' then '\u5ba1\u6838\u4e0d\u901a\u8fc7' end cmpn_status,a.create_time,a.update_time,a.cmpn_part_limit from ebmkt.ebmkt_cmpn a ");
            sql.append(" left join ebmkt.ebmkt_cmpn_recharge b on a.cmpn_id=b.cmpn_id ");
            sql.append(" where 1=1  and a.cmpn_status!='01' and a.cmpn_status!='05' and a.cmpn_status!='03' and a.cmpn_type='RECHARGE' ");
            sql.append(" and a.create_time>=?", (Object)map.get("startDay"));
            sql.append(" and a.create_time<=?", (Object)map.get("endDay"));
            sql.append(" and a.cmpn_status=?", (Object)map.get("auditStatus"));
            sql.append(" order by field(a.cmpn_status,'04','05','06'),a.create_time desc  ");
            sql.append(" limit ?, ", (Object)((Integer.parseInt(map.get("start")) - 1) * 10));
            sql.append(" 10 ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<EbmktCmpnVo>(){

                public EbmktCmpnVo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    EbmktCmpnVo cmpnVo = new EbmktCmpnVo();
                    cmpnVo.setCmpnId(rs.getString("cmpn_id"));
                    cmpnVo.setCmpnName(rs.getString("cmpn_name"));
                    cmpnVo.setCmpnEndDate(DateConvertUtils.convertToString((Date)rs.getDate("cmpn_enddate"), (String)"yyyy-MM-dd"));
                    cmpnVo.setCreateTime(DateConvertUtils.convertToString((Date)rs.getTimestamp("create_time"), (String)"yyyy-MM-dd HH:mm:ss"));
                    cmpnVo.setCmpnStatus(rs.getString("cmpn_status"));
                    cmpnVo.setCmpnType(rs.getString("cmpn_type"));
                    if (rs.getTimestamp("update_time") != null && !"".equals(rs.getTimestamp("update_time").toString())) {
                        cmpnVo.setUpdateTime(DateConvertUtils.convertToString((Date)rs.getTimestamp("update_time"), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    RechargeDaoImpl.this.logger.debug("cmpnVo " + cmpnVo.getCmpnEndDate());
                    cmpnVo.setCmpnPartLimit(rs.getInt("cmpn_part_limit"));
                    cmpnVo.setPresendRedpktMoney(rs.getDouble("presend_redpkt_money"));
                    cmpnVo.setRechargeMoney(rs.getDouble("recharge_money"));
                    return cmpnVo;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getAuditInfoCount(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("  select count(1) from ebmkt.ebmkt_cmpn a  where 1=1  and a.cmpn_status!='01' and a.cmpn_status!='05' and a.cmpn_status!='03' and a.cmpn_type='RECHARGE' ");
            sql.append(" and a.create_time>=?", (Object)map.get("startDay"));
            sql.append(" and a.create_time<=?", (Object)map.get("endDay"));
            sql.append(" and a.cmpn_status=?", (Object)map.get("auditStatus"));
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public int updateRechargeAuditResult(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append("  update  ebmkt.ebmkt_cmpn set ");
            sql.append(" update_time=?", (Object)new Date());
            sql.append(" ,updater=? ", (Object)map.get("orgName"));
            sql.append(" ,cmpn_status=?", (Object)map.get("auditResult"));
            sql.append(" where 1=1 ");
            sql.append(" and cmpn_id in (?) ", (Object)map.get("cmpnId"), ",");
            result = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            String[] cmpnId = map.get("cmpnId").split(",");
            for (int i = 0; i < cmpnId.length; ++i) {
                result = this.insertOperationLog(map, cmpnId[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return result;
    }

    public int insertOperationLog(Map<String, String> map, String cmpnId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("  insert into ebmkt.log_info(cmpn_id,log_type,log_time,log_value,log_operator) ");
            sql.append(" values(?,?,?,?,?)");
            return this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{cmpnId, map.get("auditResult"), new Date(), map.get("auditInfo"), map.get("orgName")});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> getOperationLog(String cmpnId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select b.log_time,c.user_name,b.log_value,");
            sql.append("case WHEN b.log_type='04' then '\u5f85\u5ba1\u6838' when b.log_type='02' then '\u5ba1\u6838\u901a\u8fc7' when b.log_type='06' then '\u5ba1\u6838\u4e0d\u901a\u8fc7' when b.log_type='01' then '\u5f85\u63d0\u4ea4' when b.log_type='03' then '\u5df2\u64a4\u4e0b' end log_type ");
            sql.append(" from ebmkt.log_info b left join cisp_sys.bp_user c ");
            sql.append("  on b.log_operator=c.user_no where 1=1   ");
            sql.append(" and b.cmpn_id=? ", (Object)cmpnId);
            sql.append("order by b.log_time desc ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("log_type", rs.getString("log_type"));
                    map.put("log_time", DateConvertUtils.convertToString((Date)rs.getTimestamp("log_time"), (String)"yyyy-MM-dd HH:mm:ss"));
                    map.put("user_name", rs.getString("user_name"));
                    map.put("log_value", rs.getString("log_value"));
                    RechargeDaoImpl.this.logger.debug("aaaa " + map.get("log_value"));
                    return map;
                }
            });
            this.logger.debug("++++++++++getReChargeExpireId+++++++++++" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }
}

