/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.finmgmt.jdbcdao.Impl;

import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.finmgmt.jdbcdao.YysAccountDao;
import com.ebike.openservices.finmgmt.util.EbikeCommonUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class YysAccountDaoImpl
extends AbstractEbikeBaseJdbcDao
implements YysAccountDao {
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public YysAccountDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, Object>> queryBikeAccount(String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append("  select a.bankCardNo,c.bankBranchName,b.orgoprName from ebike.ebike_orgacct_bcbinding a");
            sql.append("  left join ebike.ebike_orgopr b  on a.subburo=b.subburo ");
            sql.append(" left join ebike.code_bankbranchs c on a.bankBranchLinkNo=c.bankBranchLinkNo where 1=1 ");
            sql.append(" and a.subburo=?", (Object)subburo);
            this.logger.debug(">>>>>>>>>>queryBikeAccount<<<<<<<<<<<<<<<<" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryBikeCount(String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("  select count(1) from ebike.ebike_orgacct_bcbinding a");
            sql.append("  left join ebike.ebike_orgopr b  on a.subburo=b.subburo ");
            sql.append(" left join ebike.code_bankbranchs c on a.bankBranchLinkNo=c.bankBranchLinkNo where 1=1 ");
            sql.append(" and a.subburo=?", (Object)subburo);
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, String>> getChargePrinceList(int adlevel) {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append("SELECT t.* FROM ebike.code_adcode  t WHERE 1=1 ");
        sql.append(" and t.adlevel= ? ", (Object)adlevel);
        this.logger.debug("getChargePrinceList=" + sql.toString());
        try {
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", rs.getString("province"));
                    map.put("name", rs.getString("adfullname"));
                    return map;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, String>> getCityList(int level, String parentid) {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" SELECT t.* FROM ebike.code_adcode  t WHERE 1=1 ");
        sql.append(" and t.adlevel= ? ", (Object)level);
        sql.append(" and t.province= ? ", (Object)parentid);
        this.logger.debug("getCityList=" + sql.toString());
        try {
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", rs.getString("city"));
                    map.put("name", rs.getString("adfullname"));
                    return map;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, String>> getCountyList(int level, String parentid) {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" SELECT t.* FROM ebike.code_adcode  t WHERE 1=1 ");
        sql.append(" and t.adlevel= ? ", (Object)level);
        sql.append(" and t.city= ? ", (Object)parentid);
        this.logger.debug("getCityList=" + sql.toString());
        try {
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", rs.getString("country"));
                    map.put("name", rs.getString("adfullname"));
                    return map;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, String>> getBankList() {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select bankcode,bankname from ebike.code_bankcode ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("bankcode", rs.getString("bankcode"));
                    map.put("bankname", rs.getString("bankname"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, String>> queryBank(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (map.size() < 1 || map == null) {
            return list;
        }
        try {
            sql.append(" select bankBranchLinkNo,bankBranchName,bankcode from ebike.code_bankbranchs  where 1=1");
            sql.append(" and bankcode=?", (Object)map.get("bankcode"));
            sql.append(" and province=?", (Object)map.get("province"));
            sql.append(" and city=?", (Object)map.get("city"));
            sql.append(" and bankBranchName like ?", (Object)("%" + map.get("bankname") + "%"));
            if ("1".equals(map.get("start"))) {
                sql.append(" limit 0,10 ");
            } else {
                int start = (Integer.parseInt(map.get("start")) - 1) * 10;
                sql.append(" limit ? ", (Object)start);
                sql.append(" , 10 ");
            }
            this.logger.debug("<<<<<<<<>queryBank>>>>>>>>>>>>" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("bankBranchLinkNo", rs.getString("bankBranchLinkNo"));
                    map.put("bankBranchName", rs.getString("bankBranchName"));
                    map.put("bankcode", rs.getString("bankcode"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryBankCount(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        if (map.size() < 1 || map == null) {
            return 0;
        }
        try {
            sql.append(" select count(1) from ebike.code_bankbranchs  where 1=1");
            sql.append(" and bankcode=?", (Object)map.get("bankcode"));
            sql.append(" and province=?", (Object)map.get("province"));
            sql.append(" and city=?", (Object)map.get("city"));
            sql.append(" and bankBranchName like ?", (Object)("%" + map.get("bankname") + "%"));
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public String getYysByOrgNo(String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String yystype = "";
        try {
            sql.append(" select orgoprType from ebike.ebike_orgopr where 1=1 ");
            sql.append(" and subburo=? ", (Object)subburo);
            yystype = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return yystype;
        }
        return yystype;
    }

    @Override
    public boolean insertBankCardLog(Map<String, String> yysMap) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        String uuid = UuidUtils.generateUuidString();
        String verifyResult = "W";
        int results = this.updateOrg(yysMap);
        try {
            sql.append(" insert into ebike.ebike_log_orgacct_bcbinding ");
            sql.append(" (bcbapplyId,bcbapplyTime,buro,subburo,orgoprType,orgoprName,orgoprCredNo ");
            sql.append(" ,bankBranchLinkNo,bankCardNo,applicant,verifyResult )");
            sql.append("  values(?,?,?,?,?,?,?,?,?,?,?)");
            this.logger.debug(">>>>>>>>>>>>InsertBankCardLog<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<" + sql.toString());
            this.logger.debug(">>>>>>>>>>InsertBankCardLog<<<<<<<<<<<<<<<<" + sql.toString());
            result = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, new Date(), yysMap.get("subburo"), yysMap.get("subburo"), yysMap.get("yysType"), yysMap.get("orgoprName"), yysMap.get("orgoprCredNo"), yysMap.get("bankBranchLinkNo"), yysMap.get("bankCardNo"), yysMap.get("OrgName"), verifyResult});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0;
    }

    @Override
    public List<Map<String, Object>> queryApplication(Map<String, String> datamap) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.bcbapplyTime,a.orgoprName,d.USER_NAME as 'applicant',a.bcbapplyId,a.verifyResult,a.verifyRemark,a.bankCardNo,b.bankBranchName ");
            sql.append(" from ebike.ebike_log_orgacct_bcbinding a left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo ");
            sql.append(" left join cisp_sys.bp_user d on a.applicant=d.USER_NO where 1=1 ");
            sql.append(" and a.subburo=?", (Object)datamap.get("subburo"));
            sql.append(" and a.verifyResult=?", (Object)datamap.get("verifyResult"));
            sql.append(" and a.bcbapplyTime >= ?", (Object)DateConvertUtils.convertFromString((String)datamap.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            sql.append(" and a.bcbapplyTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)datamap.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            sql.append(" and a.orgoprName like ?", (Object)("%" + datamap.get("orgoprName") + "%"));
            sql.append("  order by field(a.verifyResult,'W','S','F')  asc , a.bcbapplyTime desc");
            this.logger.debug(">>>>>>>>>>queryApplication<<<<<<<<<<<<<<<<" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("bcbapplyTime", rs.getTimestamp("bcbapplyTime"));
                    map.put("orgoprName", rs.getString("orgoprName"));
                    map.put("verifyResult", rs.getString("verifyResult"));
                    map.put("bankCardNo", rs.getString("bankCardNo"));
                    map.put("bankBranchName", rs.getString("bankBranchName"));
                    map.put("applicant", rs.getString("applicant"));
                    map.put("bcbapplyId", rs.getString("bcbapplyId"));
                    map.put("verifyRemark", rs.getString("verifyRemark"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryApplicationCount(Map<String, String> datamap) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_log_orgacct_bcbinding a left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo ");
            sql.append(" left join cisp_sys.bp_user d on a.applicant=d.USER_NO where 1=1 ");
            sql.append(" and a.subburo=?", (Object)datamap.get("subburo"));
            sql.append(" and a.verifyResult=?", (Object)datamap.get("verifyResult"));
            sql.append(" and a.bcbapplyTime >= ?", (Object)DateConvertUtils.convertFromString((String)datamap.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            sql.append(" and a.bcbapplyTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)datamap.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            sql.append(" and a.orgoprName like ?", (Object)("%" + datamap.get("orgoprName") + "%"));
            this.logger.debug(">>>>>>>>>>queryApplicationCount<<<<<<<<<<<<<<<<" + sql.toString());
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryUnbundling(String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select d.USER_NAME as 'applicant',a.bankCardNo,a.bcbunbindTime,b.orgoprName,c.bankBranchName");
            sql.append(" from ebike.ebike_log_orgacct_bcunbinding a left join ebike.ebike_orgopr b on a.subburo=b.subburo");
            sql.append(" left join ebike.code_bankbranchs c on a.bankBranchLinkNo=c.bankBranchLinkNo ");
            sql.append(" left join cisp_sys.bp_user d on a.applicant=d.USER_NO where 1=1 ");
            sql.append(" and a.subburo=?", (Object)subburo);
            sql.append(" order by a.bcbunbindTime desc");
            this.logger.debug(">>>>>>>>>>queryUnbundling<<<<<<<<<<<<<<<<" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("applicant", rs.getString("applicant"));
                    map.put("orgoprName", rs.getString("orgoprName"));
                    map.put("bankCardNo", rs.getString("bankCardNo"));
                    map.put("bcbunbindTime", rs.getTimestamp("bcbunbindTime"));
                    map.put("bankBranchName", rs.getString("bankBranchName"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryUnbundlingCount(String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_log_orgacct_bcunbinding a left join ebike.ebike_orgopr b on a.subburo=b.subburo");
            sql.append(" left join ebike.code_bankbranchs c on a.bankBranchLinkNo=c.bankBranchLinkNo ");
            sql.append(" left join cisp_sys.bp_user d on a.applicant=d.USER_NO where 1=1 ");
            sql.append(" and a.subburo=?", (Object)subburo);
            this.logger.debug(">>>>>>>>>>queryUnbundlingCount<<<<<<<<<<<<<<<<" + sql.toString());
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public Map<String, String> getYysInfo(String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, String> map1 = new HashMap<String, String>();
        try {
            sql.append(" select orgoprName,orgoprCredNo from ebike.ebike_orgopr where 1=1");
            sql.append(" and subburo=?", (Object)subburo);
            this.logger.debug(">>>>>>>>>>getYysInfo<<<<<<<<<<<<<<<<" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("orgoprName", rs.getString("orgoprName"));
                    map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map1;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return map1;
    }

    @Override
    public boolean checkSameNo(String subburo, String bankCardNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_orgacct_bcbinding where 1=1 ");
            sql.append(" and subburo=?", (Object)subburo);
            sql.append(" and bankCardNo=?", (Object)bankCardNo);
            this.logger.debug(">>>>>>>>>>getYysInfo<<<<<<<<<<<<<<<<" + sql.toString());
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean deleteBankNo(String subburo, String bankCardNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" delete from ebike.ebike_orgacct_bcbinding where 1=1 ");
            sql.append(" and subburo=?", (Object)subburo);
            sql.append(" and bankCardNo=?", (Object)bankCardNo);
            this.logger.debug(">>>>>>>>>>deleteBankNo<<<<<<<<<<<<<<<<" + sql.toString());
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            this.logger.debug(">>>>>>>>>>deleteBankNo<<<<<<<<<<<<<<<<" + results);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean checkBankNo(String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_orgacct_bcbinding where 1=1 ");
            sql.append(" and subburo=?", (Object)subburo);
            this.logger.debug(">>>>>>>>>>checkBankNo<<<<<<<<<<<<<<<<" + sql.toString());
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 1;
    }

    @Override
    public boolean insertUnbindingLog(String subburo, String bankCardNo, String orgname) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String verifyResult = "S";
        int results = 0;
        try {
            Map<String, Object> map = this.getLogInfo(subburo, bankCardNo);
            sql.append(" insert into ebike.ebike_log_orgacct_bcunbinding ");
            sql.append(" (bcbunbindId,bcbunbindTime,buro,subburo,bankBranchLinkNo,bankCardNo,applicant,verifier,verifyTime,verifyResult) ");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{UuidUtils.generateUuidString(), new Date(), subburo, subburo, map.get("bankBranchLinkNo"), map.get("bankCardNo"), orgname, orgname, new Date(), verifyResult});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    public Map<String, Object> getLogInfo(String subburo, String bankCardNo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        try {
            sql.append(" select *  from ebike.ebike_log_orgacct_bcbinding a  where 1=1");
            sql.append(" and a.subburo=?", (Object)subburo);
            sql.append(" and a.bankCardNo=?", (Object)bankCardNo);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("orgoprName", rs.getString("orgoprName"));
                    map.put("bankCardNo", rs.getString("bankCardNo"));
                    map.put("applicant", rs.getString("applicant"));
                    map.put("orgoprType", rs.getString("orgoprType"));
                    map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
                    map.put("bankBranchLinkNo", rs.getString("bankBranchLinkNo"));
                    map.put("verifyTime", rs.getTimestamp("verifyTime"));
                    map.put("verifier", rs.getString("verifier"));
                    map.put("verifyResult", rs.getString("verifyResult"));
                    map.put("verifyRemark", rs.getString("verifyRemark"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list != null && list.size() > 0) {
            return (Map)list.get(0);
        }
        return map;
    }

    @Override
    public boolean bankExamine(String sftg, String examineInfo, String bcbapplyId, String orgName) {
        int results = 0;
        try {
            SqlParamsBuilder sql = new SqlParamsBuilder();
            sql.append(" update ebike.ebike_log_orgacct_bcbinding  set ");
            sql.append(" verifier=?", (Object)orgName);
            sql.append(" ,verifyTime =? ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy.MM.dd HH:mm:ss"));
            sql.append(" ,verifyResult = ?", (Object)sftg);
            sql.append(" ,verifyRemark=? ", (Object)examineInfo);
            sql.append(" where 1=1 ");
            sql.append(" and bcbapplyId=?", (Object)bcbapplyId);
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            if ("S".equals(sftg)) {
                HashMap<String, Object> map = new HashMap();
                map = this.getInfoByBcId(bcbapplyId);
                this.updateBcbinding(map);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public Map<String, Object> getInfoByBcId(String bcbapplyId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List list = new ArrayList();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select verifier,verifyTime,bankBranchLinkNo,bankCardNo,subburo,buro from ebike.ebike_log_orgacct_bcbinding  where 1=1 ");
            sql.append(" and bcbapplyId = ?", (Object)bcbapplyId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("verifier", rs.getString("verifier"));
                    map.put("verifyTime", rs.getTimestamp("verifyTime"));
                    map.put("bankBranchLinkNo", rs.getString("bankBranchLinkNo"));
                    map.put("bankCardNo", rs.getString("bankCardNo"));
                    map.put("subburo", rs.getString("subburo"));
                    map.put("buro", rs.getString("buro"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return resultMap;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return resultMap;
    }

    public void updateBcbinding(Map<String, Object> map) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_orgacct_bcbinding ");
            sql.append("(buro,subburo,bankCardNo,bankBranchLinkNo,verifier,verifyPassTime )");
            sql.append("values(?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{map.get("buro"), map.get("subburo"), map.get("bankCardNo"), map.get("bankBranchLinkNo"), map.get("verifier"), new Date()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String getSubburoById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String subburo = "";
        try {
            sql.append(" select  subburo from ebike.ebike_log_orgacct_bcbinding where 1=1 ");
            sql.append(" and bcbapplyId=?", (Object)id);
            subburo = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return subburo;
        }
        return subburo;
    }

    @Override
    public String getSubburoByNo(String getSubburoByNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String subburo = "";
        try {
            sql.append(" select  subburo from ebike.ebike_orgacct_bcbinding where 1=1 ");
            sql.append(" and bankCardNo=?", (Object)getSubburoByNo);
            subburo = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return subburo;
        }
        return subburo;
    }

    public int updateOrg(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" update ebike.ebike_orgopr set ");
            sql.append(" orgoprType=?", (Object)map.get("orgoprType"));
            sql.append(" ,orgoprCredNo=?", (Object)map.get("orgoprCredNo"));
            sql.append(" where 1=1 ");
            sql.append(" and subburo=?", (Object)map.get("subburo"));
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            this.logger.debug(">>>>>>>>>>>updateOrg<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return results;
    }
}

