/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.finmgmt.jdbcdao.Impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.finmgmt.jdbcdao.YysTxAuditingDao;
import com.ebike.openservices.finmgmt.util.EbikeCommonUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class YysTxAuditingDaoImpl
implements YysTxAuditingDao {
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public YysTxAuditingDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, Object>> queryExamineData(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.wdapplyId,a.wdapplyTime,b.orgoprName,a.wdAccountNo,a.wdMoney,a.wdDesc ");
            sql.append(" ,a.verifyResult,a.applicant,a.verifyTime,a.archiver, c.bankBranchName from ebike.ebike_log_orgacct_withdraw a ");
            sql.append(" left join ebike.ebike_orgopr  b on a.subburo=b.subburo ");
            sql.append(" left join ebike.code_bankbranchs c on a.bankBranchLinkNo=c.bankBranchLinkNo where 1=1 ");
            sql.append(" and a.verifyResult=? ", (Object)map.get("verifyResult"));
            sql.append(" and a.wdapplyTime >= ?", (Object)DateConvertUtils.convertFromString((String)map.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            sql.append(" and a.wdapplyTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)map.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            sql.append(" and b.orgoprName like ?", (Object)("%" + map.get("orgoprName") + "%"));
            if ("Y".endsWith(map.get("tranStatus"))) {
                sql.append(" and a.archiver!='' ");
            }
            if ("N".endsWith(map.get("tranStatus"))) {
                sql.append(" and a.archiver is null or trim(a.archiver)='' ");
            }
            sql.append(" order by a.wdapplyTime desc ");
            this.logger.debug(">>>>>>>>>>>>>>>>>queryExamineData<<<<<<<<<<<<<<<<<<<<" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("wdapplyId", rs.getString("wdapplyId"));
                    map.put("wdapplyTime", rs.getTimestamp("wdapplyTime"));
                    map.put("orgoprName", rs.getString("orgoprName"));
                    map.put("bankBranchName", rs.getString("bankBranchName"));
                    map.put("wdAccountNo", rs.getString("wdAccountNo"));
                    map.put("wdMoney", rs.getDouble("wdMoney"));
                    map.put("wdDesc", rs.getString("wdDesc"));
                    map.put("verifyTime", rs.getTimestamp("verifyTime"));
                    map.put("verifyResult", rs.getString("verifyResult"));
                    map.put("archiver", rs.getString("archiver"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryExamineCount(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_log_orgacct_withdraw a ");
            sql.append(" left join ebike.ebike_orgopr  b on a.subburo=b.subburo where 1=1");
            sql.append(" and a.verifyResult=? ", (Object)map.get("verifyResult"));
            sql.append(" and a.wdapplyTime >= ?", (Object)DateConvertUtils.convertFromString((String)map.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            sql.append(" and a.wdapplyTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)map.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            sql.append(" and b.orgoprName like ?", (Object)("%" + map.get("orgoprName") + "%"));
            if ("Y".endsWith(map.get("tranStatus"))) {
                sql.append(" and a.archiver!='' ");
            }
            if ("N".endsWith(map.get("tranStatus"))) {
                sql.append(" and a.archiver is null or trim(a.archiver)='' ");
            }
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public Map<String, Object> queryModalData(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        try {
            sql.append(" select a.wdapplyId,a.wdapplyTime,b.orgoprName,a.wdAccountNo,a.wdMoney,a.wdDesc,a.cashdrawId ");
            sql.append(" ,a.verifyResult,d.USER_NAME as 'applicant',a.wdBeforeBalance, e.USER_NAME as 'verifier',a.verifyTime,a.verifyRemark,f.USER_NAME as 'archiver',a.archiveTime,a.archiveDesc,a.archiveAttach");
            sql.append(",c.bankBranchName from ebike.ebike_log_orgacct_withdraw a");
            sql.append(" left join ebike.ebike_orgopr  b on a.subburo=b.subburo ");
            sql.append(" left join ebike.code_bankbranchs c on a.bankBranchLinkNo=c.bankBranchLinkNo  ");
            sql.append(" left join cisp_sys.bp_user d on a.applicant=d.USER_NO  ");
            sql.append(" left join cisp_sys.bp_user e on a.verifier=e.USER_NO  ");
            sql.append(" left join cisp_sys.bp_user f on a.archiver=f.USER_NO where 1=1 ");
            sql.append(" and a.wdapplyId= ?", (Object)id);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int numRow) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("wdapplyId", rs.getString("wdapplyId"));
                    map.put("applicant", rs.getString("applicant"));
                    map.put("wdapplyTime", DateConvertUtils.convertToString((Date)rs.getTimestamp("wdapplyTime"), (String)"yyyy.MM.dd HH:mm:ss"));
                    map.put("orgoprName", rs.getString("orgoprName"));
                    map.put("bankBranchName", rs.getString("bankBranchName"));
                    map.put("wdAccountNo", rs.getString("wdAccountNo"));
                    map.put("wdMoney", rs.getDouble("wdMoney"));
                    map.put("wdBeforeBalance", rs.getDouble("wdBeforeBalance"));
                    map.put("wdDesc", rs.getString("wdDesc"));
                    map.put("verifier", rs.getString("verifier"));
                    map.put("verifyTime", DateConvertUtils.convertToString((Date)rs.getTimestamp("verifyTime"), (String)"yyyy.MM.dd HH:mm:ss"));
                    map.put("verifyResult", rs.getString("verifyResult"));
                    map.put("verifyRemark", rs.getString("verifyRemark"));
                    map.put("archiver", rs.getString("archiver"));
                    map.put("archiveTime", DateConvertUtils.convertToString((Date)rs.getTimestamp("archiveTime"), (String)"yyyy.MM.dd HH:mm:ss"));
                    map.put("archiveDesc", rs.getString("archiveDesc"));
                    map.put("archiveAttach", rs.getString("archiveAttach"));
                    map.put("cashdrawId", rs.getString("cashdrawId"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map1;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return map1;
    }

    @Override
    public boolean toExamine(String verifyResult, String examineInfo, String wdapplyId, String orgname) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" update ebike.ebike_log_orgacct_withdraw set ");
            sql.append(" verifier=?", (Object)orgname);
            sql.append(" ,verifyTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy.MM.dd HH:mm:ss"));
            sql.append(" ,verifyResult=?", (Object)verifyResult);
            sql.append("  ,verifyRemark=?", (Object)examineInfo);
            sql.append(" where 1=1 ");
            sql.append(" and wdapplyId=?", (Object)wdapplyId);
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean transferAccount(String marchiveDesc, String wdapplyId, String orgname, String attach) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" update ebike.ebike_log_orgacct_withdraw set ");
            sql.append(" archiver=?,", (Object)orgname);
            sql.append(" archiveTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy.MM.dd HH:mm:ss"));
            sql.append(",archiveDesc=?", (Object)marchiveDesc);
            sql.append(",archiveAttach=?", (Object)attach);
            sql.append(" where 1=1 ");
            sql.append(" and wdapplyId=?", (Object)wdapplyId);
            this.logger.debug(">>>>>>>>>>>>>>>TransferAccount<<<<<<<<<<<<<<<<<" + sql.toString());
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public String getSubburoById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String subburo = "";
        try {
            sql.append(" select  subburo from ebike.ebike_log_orgacct_withdraw where 1=1 ");
            sql.append(" and wdapplyId=?", (Object)id);
            subburo = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return subburo;
        }
        return subburo;
    }

    @Override
    public String getNameBySubburo(String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String name = "";
        try {
            sql.append(" select  org_name from cisp_sys.bp_org where 1=1 ");
            sql.append(" and ORG_NO=?", (Object)subburo);
            name = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return name;
        }
        return name;
    }

    @Override
    public String getUrlById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String url = "";
        try {
            sql.append(" select archiveAttach from  ebike.ebike_log_orgacct_withdraw  where 1=1 ");
            sql.append(" and wdapplyId=? ", (Object)id);
            url = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return url;
        }
        return url;
    }

    @Override
    public int updateDataById(String id, String url) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        this.logger.debug("updateDataById" + id);
        try {
            sql.append(" update ebike.ebike_log_orgacct_withdraw ");
            if ("".equals(url)) {
                sql.append(" set  archiveAttach='' ");
            } else {
                sql.append(" set  archiveAttach=?", (Object)url);
            }
            sql.append(" where 1=1 ");
            sql.append(" and wdapplyId=?", (Object)id);
            this.logger.debug(">>>>>>>>>>>>>>>>updateDataById<<<<<<<<<<<<<<" + sql.toString());
            return this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public String getArchiveAttachById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String archiveAttach = "";
        try {
            sql.append(" select  archiveAttach from ebike.ebike_log_orgacct_withdraw where 1=1");
            sql.append(" and wdapplyId=? ", (Object)id);
            archiveAttach = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return archiveAttach;
        }
        return archiveAttach;
    }
}

